/*
 * Decompiled with CFR 0.152.
 */
package Server;

import MapFrame.Feature;
import MapFrame.Layer;
import MapFrame.Poly;
import MapFrame.Punto;
import Packet.Packet;
import Packet.PacketAuthR;
import Packet.PacketAuthS;
import Packet.PacketCNRst;
import Packet.PacketException;
import Packet.PacketLayerDataR;
import Packet.PacketLayerDataS;
import Packet.PacketModifLayerDataB;
import Packet.PacketModifLayerDataS;
import Users.UserManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkManager {
    public static final int AUT = 0;
    public static final int LDS = 1;
    public static final int LMS = 2;
    public static final int NO_VALID = -1;
    Socket client = null;
    UserManager bdM;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;
    boolean NetworkOK = true;

    public NetworkManager(Socket socket, UserManager bM) {
        this.client = socket;
        this.bdM = bM;
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.bdM.NetworkConnection(socket.getInetAddress().getHostAddress());
        }
        catch (IOException ex) {
            this.NetworkOK = false;
            this.bdM.NetworkDesconnection();
        }
    }

    private void write(Packet packetAux) {
        try {
            this.oos.writeObject(packetAux);
        }
        catch (IOException ex) {
            this.bdM.NetworkDesconnection();
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Packet read() {
        Packet packetAux = null;
        try {
            packetAux = (Packet)this.ois.readObject();
            System.out.println("SERVER packet received: " + packetAux);
            this.stateMachine(packetAux);
        }
        catch (IOException ex) {
            this.bdM.NetworkDesconnection();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return packetAux;
    }

    public void stateMachine(Packet packet) {
        switch (this.convert(packet.cmd)) {
            case 0: {
                PacketAuthS packetA = (PacketAuthS)packet;
                String user = packetA.Login;
                String pwd = packetA.Pwd;
                this.bdM.Authentication(user, pwd);
                break;
            }
            case 1: {
                PacketLayerDataS packetLayer = (PacketLayerDataS)packet;
                List<Punto> ptos = null;
                List<Poly> poly = null;
                String layerName = packetLayer.getLayerName();
                Feature.type tipo = packetLayer.getTypeLayer();
                if (tipo == Feature.type.Point) {
                    ptos = this.bdM.getPuntos(layerName);
                } else {
                    poly = this.bdM.getPoly(layerName);
                }
                this.sendLayerData(layerName, tipo, ptos, poly);
                break;
            }
            case 2: {
                PacketModifLayerDataS packetDataLayer = (PacketModifLayerDataS)packet;
                String layerNameMod = packetDataLayer.getLayerName();
                Feature.type tipoMod = packetDataLayer.getTypeLayer();
                Punto ptoMod = packetDataLayer.getPunto();
                boolean add = packetDataLayer.isADD();
                if (tipoMod == Feature.type.Point) {
                    this.bdM.ModifLayer(layerNameMod, ptoMod, add);
                    break;
                }
                Poly ptosMod = packetDataLayer.getPuntos();
                this.bdM.ModifLayer(layerNameMod, tipoMod, ptosMod, add);
                break;
            }
        }
    }

    public int convert(String cmd) {
        int ret = -1;
        if (cmd.contentEquals("AUS")) {
            ret = 0;
        } else if (cmd.contentEquals("LDS")) {
            ret = 1;
        } else if (cmd.contentEquals("LMS")) {
            ret = 2;
        }
        return ret;
    }

    public void sendAuth(List<Layer> layers) {
        try {
            PacketAuthR Auth = new PacketAuthR(layers);
            this.write(Auth);
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendErrAuth(boolean wrongPWD) {
        try {
            String cmd = wrongPWD ? "WPW" : "ONL";
            PacketAuthR Auth = new PacketAuthR(cmd);
            this.write(Auth);
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendLayerData(String layerName, Feature.type type2, List<Punto> ptos, List<Poly> polys) {
        try {
            PacketLayerDataR LayerData2 = type2 == Feature.type.Point ? new PacketLayerDataR(layerName, ptos) : new PacketLayerDataR(layerName, type2, polys);
            this.write(LayerData2);
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendConnexionReset(String User) {
        try {
            PacketCNRst ConexionRst = new PacketCNRst(User);
            this.write(ConexionRst);
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendDataBroadCastLayer(String layername, int tipo, boolean add) {
        try {
            PacketModifLayerDataB packet = new PacketModifLayerDataB(layername, tipo, add);
            this.write(packet);
            System.out.println("SERVER ENVIANDO --> " + packet);
        }
        catch (PacketException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isNetworkOK() {
        return this.NetworkOK;
    }
}

