/*
 * Decompiled with CFR 0.152.
 */
package Server;

import Server.Configuration;
import Server.Mediator;
import Users.ThreadUsers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JOptionPane;

public class Server
extends Thread {
    private ServerSocket listenSocket;
    private Configuration cfg = null;
    private boolean jobDone = false;
    Mediator med;

    public Server(Mediator md, Configuration configuration) {
        this.cfg = configuration;
        this.med = md;
        this.ini();
    }

    private void ini() {
        int serverPort = this.cfg.getPort();
        try {
            this.listenSocket = new ServerSocket(serverPort);
        }
        catch (Exception s) {
            System.out.println("S: Error try to listen port: " + serverPort);
        }
        String localIp = null;
        try {
            InetAddress local = InetAddress.getLocalHost();
            localIp = local.getHostAddress();
        }
        catch (IOException s) {
            localIp = new String("Unknow");
        }
        this.med.AddLog("S: Feature Server ready to listen on: " + localIp + ":" + serverPort);
    }

    @Override
    public void run() {
        this.bidderStage();
    }

    public void bidderStage() {
        while (!this.jobDone) {
            if (this.listenSocket == null) {
                int serverPort = this.cfg.getPort();
                JOptionPane.showMessageDialog(null, " This program needs the port " + serverPort + " to act as server.", "Server Error", 0);
                System.exit(-1);
            }
            Socket clientSocket = null;
            try {
                clientSocket = this.listenSocket.accept();
            }
            catch (IOException s) {
                break;
            }
            ThreadUsers cl = new ThreadUsers(this.med, clientSocket);
            cl.start();
        }
    }

    public void stopServer() {
        this.jobDone = true;
        try {
            this.listenSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

