/*
 * Decompiled with CFR 0.152.
 */
package Server;

import ButtonListener.ButtonAbstract;
import ButtonListener.Command;
import Server.MapFrame;
import Server.Mediator;
import Visual.LayerTable;
import Visual.featureModePanel;
import Visual.infoLog;
import Visual.newLayerPanel;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ServerDialog
implements ActionListener {
    private int x = 800;
    private int y = 715;
    private JFrame frame = new JFrame("Features Gateway");
    LayerTable table;
    Mediator med;

    public ServerDialog() {
        this.loadIcon();
        this.frame.setLocation(0, 0);
        this.frame.setLayout(null);
        this.frame.setResizable(false);
        this.frame.setPreferredSize(new Dimension(this.x, this.y));
        this.med = new Mediator(this.frame);
        ButtonAbstract cfgButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Config);
        ButtonAbstract startButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Start);
        ButtonAbstract usersButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Users);
        ButtonAbstract stopButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Stop);
        ButtonAbstract addLayerButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.AddLayer);
        ButtonAbstract delLayerButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.DelLayer);
        ButtonAbstract publishLayerButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Publish);
        ButtonAbstract importButton = new ButtonAbstract(this.med, this, Mediator.tipoBotones.Import);
        infoLog log = new infoLog(this.med);
        newLayerPanel layerPanel = new newLayerPanel(this.med);
        featureModePanel featurePanel = new featureModePanel(this.med);
        boolean database = this.med.init();
        JLabel titleL = new JLabel("Features Gateway");
        titleL.setFont(new Font("ARIAL", 1, 18));
        JSeparator separator1 = new JSeparator();
        JSeparator separator2 = new JSeparator();
        separator1.setBounds(this.x - 170, 35, 170, 15);
        separator2.setBounds(this.x - 160, 39, 160, 15);
        titleL.setBounds(this.x - 172, 8, 170, 30);
        this.table = new LayerTable(this.med);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBounds(20, 62, 450, 190);
        this.frame.add(scrollPane);
        this.frame.add(layerPanel);
        layerPanel.setBounds(this.x - 320, 60, 300, 80);
        this.frame.add(addLayerButton);
        addLayerButton.setBounds(this.x - 320, 140, 100, 30);
        this.frame.add(delLayerButton);
        delLayerButton.setBounds(this.x - 220, 140, 100, 30);
        this.frame.add(publishLayerButton);
        publishLayerButton.setBounds(this.x - 120, 140, 99, 30);
        this.frame.add(importButton);
        importButton.setBounds(this.x - 320, 170, 300, 30);
        this.frame.add(featurePanel);
        featurePanel.setBounds(this.x - 320, 200, 300, 55);
        MapFrame map = new MapFrame(this.med);
        map.getMap();
        this.frame.add((Component)map.getMap());
        map.getMap().setBounds(20, 255, 750, 270);
        JLabel LogInfoL = new JLabel("LOG INFO");
        LogInfoL.setFont(new Font("Tahoma", 1, 14));
        LogInfoL.setForeground(Color.GRAY);
        JScrollPane scrollPaneLog = new JScrollPane(log);
        this.frame.add(LogInfoL);
        this.frame.add(scrollPaneLog);
        scrollPaneLog.setBounds(20, this.y - 190, this.x - 40, 100);
        LogInfoL.setBounds(20, this.y - 208, 130, 15);
        cfgButton.setBounds(20, this.y - 80, 99, 30);
        startButton.setBounds(this.x / 2 - 110, this.y - 80, 99, 30);
        stopButton.setBounds(this.x / 2, this.y - 80, 99, 30);
        usersButton.setBounds(this.x - 120, this.y - 80, 99, 30);
        this.frame.add(titleL);
        this.frame.add(separator1);
        this.frame.add(separator2);
        this.frame.add(startButton);
        this.frame.add(stopButton);
        this.frame.add(usersButton);
        this.frame.add(cfgButton);
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setVisible(true);
        startButton.requestFocusInWindow();
        if (database) {
            this.med.LoadData();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command cmd = (Command)e.getSource();
        cmd.Execute();
    }

    public void loadIcon() {
        String OS = System.getProperty("os.name");
        URL url = ClassLoader.getSystemResource("world.png");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.createImage(url);
        if (OS.startsWith("Mac")) {
            Application application = Application.getApplication();
            application.setDockIconImage(img);
            application.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent arg0) {
                    JOptionPane.showMessageDialog(ServerDialog.this.frame, "Features Gateway \nCreated at University of Malaga.");
                }
            });
        } else {
            this.frame.setIconImage(img);
        }
    }

    public static void main(String[] args) {
        ServerDialog x = new ServerDialog();
    }
}

