/*
 * Decompiled with CFR 0.152.
 */
package Users;

import MapFrame.Feature;
import MapFrame.Layer;
import MapFrame.Poly;
import MapFrame.Punto;
import Server.Mediator;
import Server.NetworkManager;
import Users.ThreadUsers;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class UserManager {
    Mediator med;
    ThreadUsers thread = null;
    private String addressClient = "Unkown";
    private NetworkManager netManager = null;
    boolean isconnected = false;
    String userL = "Unkown";
    boolean isAuthticated = false;

    public UserManager(Mediator medP) {
        this.med = medP;
    }

    public void registerNetManager(NetworkManager netMag) {
        this.netManager = netMag;
    }

    public void NetworkConnection(String address) {
        this.isconnected = true;
        this.addressClient = address;
        this.med.AddLog("C->S: Client connected from " + this.addressClient + " not Authenticated");
    }

    public void NetworkDesconnection() {
        if (this.thread != null) {
            this.thread.stopThread();
        }
        this.isconnected = false;
        this.med.disconnected(this.userL, this.addressClient);
    }

    public boolean isNetworkConnected() {
        return this.isconnected;
    }

    public boolean isAuthenticated() {
        return this.isAuthticated;
    }

    public void Authentication(String user, String pwd) {
        int result = this.med.isAuthenticated(user, pwd);
        switch (result) {
            case 1: {
                this.med.AddLog("C->S: User " + user + " from " + this.addressClient + " Authenticated");
                List<Layer> layers = this.med.getLayers();
                this.netManager.sendAuth(layers);
                this.userL = user;
                this.isAuthticated = true;
                break;
            }
            case 0: {
                this.med.AddLog("C->S: User " + user + " from " + this.addressClient + " WRONG password");
                this.netManager.sendErrAuth(true);
                break;
            }
            case -1: {
                this.med.AddLog("C->S: User " + user + " from " + this.addressClient + " ONLINE");
                this.netManager.sendErrAuth(false);
            }
        }
    }

    public void ModifLayer(String layerName, Punto pto, boolean add) {
        GeoPosition ptoAdd = new GeoPosition(pto.getLatitude(), pto.getLongitude());
        if (add) {
            this.med.addWayPoint(layerName, ptoAdd);
        } else {
            this.med.delWayPoint(layerName, ptoAdd);
        }
        this.med.sendBroadCastModif(layerName, 0, add, this.userL);
    }

    public void ModifLayer(String layerName, Feature.type tipo, Poly poly, boolean add) {
        int type2 = 1;
        if (tipo == Feature.type.Polygon) {
            type2 = 2;
        }
        ArrayList<GeoPosition> ptosAdd = new ArrayList<GeoPosition>();
        for (Punto punto : poly.getPtos()) {
            ptosAdd.add(new GeoPosition(punto.getLatitude(), punto.getLongitude()));
        }
        if (add) {
            this.med.addLynePoint(layerName, ptosAdd);
        } else {
            this.med.delLynePoint(layerName, poly);
        }
        this.med.sendBroadCastModif(layerName, type2, add, this.userL);
    }

    public List<Punto> getPuntos(String layerName) {
        return this.med.getPuntos(layerName);
    }

    public List<Poly> getPoly(String layerName) {
        return this.med.getPoly(layerName);
    }

    public void sendConnexionReset(String User) {
        this.netManager.sendConnexionReset(User);
    }

    public void registerThread(ThreadUsers threadBidder) {
        this.thread = threadBidder;
    }

    public String getUser() {
        return this.userL;
    }

    public void sendDataBroadCastLayer(String layername, int tipo, boolean add) {
        this.netManager.sendDataBroadCastLayer(layername, tipo, add);
    }
}

