/*
 * Decompiled with CFR 0.152.
 */
package Visual;

import Server.GeoJSON;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ImportURLLayersWindow
extends JDialog
implements ActionListener {
    private final String UrlButton = "Get URL Layer";
    private final String DBButton = "Add Layer";
    JButton RunGenetic;
    JTextField URL;
    JTextField LayerLabel;
    JTextField dataToExport;
    GeoJSON importar = null;
    JButton ADD_DB;
    boolean save = false;
    JLabel Layer_L;
    JLabel info;
    JComboBox type;
    String[] typesLayer = new String[]{"GeoJSON", "KML", "SHP"};

    public ImportURLLayersWindow(JFrame frame) {
        super(frame, "Import Layer", true);
        this.setLocation(100, 100);
        this.setLayout(null);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(700, 140));
        JLabel URL_L = new JLabel("URL: ");
        URL_L.setForeground(Color.BLACK);
        URL_L.setBounds(10, 20, 150, 25);
        this.add(URL_L);
        this.URL = new JTextField(450);
        this.URL.setBounds(40, 20, 340, 20);
        this.add(this.URL);
        this.type = new JComboBox<String>(this.typesLayer);
        this.type.setBounds(380, 18, 125, 25);
        this.add(this.type);
        JButton URL_GET = new JButton("Get URL Layer");
        URL_GET.setBounds(510, 20, 140, 25);
        URL_GET.addActionListener(this);
        this.add(URL_GET);
        this.Layer_L = new JLabel("Layer Name: ");
        this.Layer_L.setForeground(Color.GRAY);
        this.Layer_L.setBounds(10, 50, 150, 25);
        this.add(this.Layer_L);
        this.LayerLabel = new JTextField(450);
        this.LayerLabel.setBounds(90, 50, 400, 20);
        this.LayerLabel.setEnabled(false);
        this.add(this.LayerLabel);
        this.info = new JLabel("");
        this.info.setForeground(Color.red);
        this.info.setBounds(95, 75, 350, 25);
        this.add(this.info);
        this.ADD_DB = new JButton("Add Layer");
        this.ADD_DB.setBounds(510, 50, 140, 25);
        this.ADD_DB.addActionListener(this);
        this.ADD_DB.setEnabled(false);
        this.add(this.ADD_DB);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Get URL Layer")) {
            this.Load();
        } else if (cmd.equals("Add Layer")) {
            this.Save();
        }
    }

    private void Save() {
        this.save = true;
        String layerl = this.LayerLabel.getText();
        if (layerl.length() > 0) {
            this.importar.setLayerName(layerl);
        }
        this.dispose();
    }

    private void Load() {
        String urlS = this.URL.getText();
        if (urlS.length() > 0) {
            switch (this.type.getSelectedIndex()) {
                case 0: {
                    this.getGJSON(urlS);
                    break;
                }
                case 1: {
                    this.getKML(urlS);
                    break;
                }
                case 2: {
                    this.getSHP(urlS);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "Please, insert a valid URL", "URL empty", 2);
        }
    }

    private void getGJSON(String urlS) {
        this.importar = new GeoJSON();
        try {
            this.importar.setURL(urlS);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, "Please, insert a valid URL", "URL error", 2);
            this.importar = null;
            return;
        }
        try {
            this.importar.readPoints();
        }
        catch (JsonParseException e) {
            JOptionPane.showMessageDialog(null, "Error parsing GeoJSON", "JsonParseException", 2);
            this.dataToExport.setText("");
            return;
        }
        catch (JsonMappingException e) {
            String msg = e.getLocalizedMessage();
            int index = msg.indexOf("at [Source:");
            msg = msg.substring(0, index);
            JOptionPane.showMessageDialog(null, msg, "Error parsing GeoJSON_JsonMappingException", 2);
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error parsing GeoJSON", "IOException", 2);
            e.printStackTrace();
            return;
        }
        String msg = "Found layer " + this.importar.getLayerName() + " with " + this.importar.getnumPoints() + " points";
        this.Layer_L.setForeground(Color.BLACK);
        this.LayerLabel.setEnabled(true);
        this.LayerLabel.setText(this.importar.getLayerName());
        this.info.setText(msg);
        this.ADD_DB.setEnabled(true);
    }

    private void getKML(String urlS) {
        JOptionPane.showMessageDialog(null, "Sorry, KML Not implemented yet", "ToDo", 2);
    }

    private void getSHP(String urlS) {
        JOptionPane.showMessageDialog(null, "Sorry, SHP Not implemented yet", "ToDo", 2);
    }

    public GeoJSON getResult() {
        return this.importar;
    }

    public boolean havetoSave() {
        return this.save;
    }
}

