/*
 * Decompiled with CFR 0.152.
 */
package Visual;

import MapFrame.Feature;
import Visual.ColumnData;
import Visual.LayerData;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class LayerDataTable
extends AbstractTableModel {
    public static final ColumnData[] m_columns = new ColumnData[]{new ColumnData("Layer", 3, 0), new ColumnData("Type", 17, 0), new ColumnData("Elements", 18, 0)};
    protected Vector m_vector = new Vector();

    public void clear() {
        this.m_vector.removeAllElements();
    }

    public void deleteElement(int index) {
        int size = this.m_vector.size();
        if (size > 0 & index < size) {
            this.m_vector.remove(index);
        }
    }

    public void addElement(String layer) {
        if (!this.isIncludeYet(layer)) {
            this.m_vector.addElement(new LayerData(layer));
        } else {
            JOptionPane.showMessageDialog(null, "Please, Introduce a new layer.", "Error Adding Layer", 2);
        }
    }

    public void addElement(String layer, Feature.type type2) {
        if (!this.isIncludeYet(layer)) {
            this.m_vector.addElement(new LayerData(layer, type2));
        } else {
            JOptionPane.showMessageDialog(null, "Please, Introduce a new layer.", "Error Adding Layer", 2);
        }
    }

    public void addElement(String layer, Feature.type type2, int numElement) {
        if (!this.isIncludeYet(layer)) {
            this.m_vector.addElement(new LayerData(layer, type2, numElement));
        } else {
            JOptionPane.showMessageDialog(null, "Please, Introduce a new layer.", "Error Adding Layer", 2);
        }
    }

    private boolean isIncludeYet(String layerLook) {
        int lon = this.m_vector.size();
        int i = 0;
        while (i < lon) {
            LayerData layer = (LayerData)this.m_vector.get(i);
            if (layer.m_layer.compareTo(layerLook) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateLayer(String layer, boolean add) {
        this.updateLayer(layer, add, 1);
    }

    public void updateLayer(String layer, boolean add, int quantity) {
        int lon = this.m_vector.size();
        int i = 0;
        while (i < lon) {
            LayerData datos = (LayerData)this.m_vector.get(i);
            if (datos.m_layer.contentEquals(layer)) {
                if (add) {
                    datos.m_numElements += quantity;
                    break;
                }
                if (datos.m_numElements <= 0) break;
                datos.m_numElements -= quantity;
                break;
            }
            ++i;
        }
    }

    public int size() {
        return this.m_vector.size();
    }

    @Override
    public int getRowCount() {
        return this.m_vector == null ? 0 : this.m_vector.size();
    }

    @Override
    public int getColumnCount() {
        return m_columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return LayerDataTable.m_columns[column].m_title;
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return false;
    }

    public String getLayerName(int nRow) {
        return (String)this.getValueAt(nRow, 0);
    }

    public Feature.type getType(int nRow) {
        return (Feature.type)((Object)this.getValueAt(nRow, 1));
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        LayerData row = (LayerData)this.m_vector.elementAt(nRow);
        switch (nCol) {
            case 0: {
                return row.m_layer;
            }
            case 1: {
                return row.m_typelayer;
            }
            case 2: {
                return row.m_numElements;
            }
        }
        return "";
    }
}

