/*
 * Decompiled with CFR 0.152.
 */
package Visual;

import Server.GeoDatabase;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class UserWindow
extends JDialog
implements ActionListener {
    JTable tableV;
    Vector rows;
    GeoDatabase database;

    public UserWindow(JFrame frame, GeoDatabase databaseP) {
        super(frame, "User Administration", true);
        this.database = databaseP;
        this.setLocation(10, 20);
        this.setLayout(null);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(400, 500));
        Hashtable<String, String> users = this.database.getUsers();
        JButton NewUser = new JButton("New User");
        NewUser.setBounds(70, 425, 100, 25);
        NewUser.addActionListener(this);
        this.add(NewUser);
        JButton DelUser = new JButton("Del. User");
        DelUser.setBounds(220, 425, 100, 25);
        DelUser.addActionListener(this);
        this.add(DelUser);
        NotEditableTableModel bulModel = new NotEditableTableModel();
        String[] columnNames = new String[]{"Login Name", "Password"};
        this.rows = new Vector();
        Vector<String> columns = new Vector<String>();
        int j = 0;
        while (j < columnNames.length) {
            columns.addElement(columnNames[j]);
            ++j;
        }
        bulModel.setDataVector(this.rows, columns);
        this.tableV = new JTable(bulModel);
        final UserWindow window = this;
        this.tableV.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable)e.getSource();
                    int row = target.getSelectedRow();
                    Vector selectedRow = (Vector)UserWindow.this.rows.elementAt(row);
                    String ID = (String)selectedRow.elementAt(0);
                    UserModif x = new UserModif(window, ID);
                    if (x.id) {
                        String PWD = x.getPassword();
                        if (PWD.length() == 0) {
                            JOptionPane.showMessageDialog(null, "Please, Introduce a valid password.", "Error Adding User", 2);
                        } else {
                            UserWindow.this.modifyDataTable(row, ID, PWD);
                        }
                    }
                }
            }
        });
        this.tableV.getTableHeader().setReorderingAllowed(false);
        JLabel TableV = new JLabel("Users:");
        JScrollPane scrollTableV = new JScrollPane(this.tableV);
        scrollTableV.setBounds(10, 15, 370, 400);
        this.add(scrollTableV);
        this.pack();
        this.loadDataTable(users);
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("New User")) {
            UserModif x = new UserModif(this, null);
            if (x.id) {
                String ID = x.getUserName();
                if (ID.length() == 0) {
                    JOptionPane.showMessageDialog(null, "Please, Introduce a valid user.", "Error Adding User", 2);
                } else if (this.isInTable(ID)) {
                    JOptionPane.showMessageDialog(null, "User is already included in database.", "Error Adding User", 2);
                } else {
                    String PWD = x.getPassword();
                    if (PWD.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Please, Introduce a valid password.", "Error Adding User", 2);
                    } else {
                        this.insertNewDataTable(ID, PWD);
                    }
                }
            }
        } else if (cmd.equals("Del. User")) {
            int NumItems;
            int selected = this.tableV.getSelectedRow();
            if (selected == -1 | selected >= (NumItems = this.rows.size())) {
                JOptionPane.showMessageDialog(null, "Please, select first the user to delete.", "Error Delete User", 2);
            } else {
                Vector selectedRow = (Vector)this.rows.elementAt(selected);
                String id = (String)selectedRow.elementAt(0);
                this.deleteDataTable(selected, id);
            }
        }
    }

    private static String stringHexa(byte[] bytes) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                s.append('0');
            }
            s.append(Integer.toHexString(parteAlta | parteBaixa));
            ++i;
        }
        return s.toString();
    }

    private String codifPwd(String pwd) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pwd.getBytes());
            return UserWindow.stringHexa(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public void loadDataTable(Hashtable USers) {
        for (String ID : USers.keySet()) {
            String PWD = (String)USers.get(ID);
            this.insertDataTable(ID, PWD);
        }
    }

    public boolean isInTable(String ID) {
        int tableSize = this.rows.size();
        int i = 0;
        while (i < tableSize) {
            Vector dataE = (Vector)this.rows.get(i);
            String IDd = (String)dataE.get(0);
            if (IDd.contentEquals(ID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void modifyDataTable(int row, String ID, String PWD) {
        String PwdC = this.codifPwd(PWD);
        Vector dataE = (Vector)this.rows.get(row);
        dataE.set(1, PwdC);
        this.rows.set(row, dataE);
        this.tableV.addNotify();
        this.tableV.repaint();
        this.database.updatePwd(ID, PwdC);
    }

    public void deleteDataTable(int row, String Id) {
        this.rows.remove(row);
        this.tableV.addNotify();
        this.tableV.repaint();
        this.database.deleteUser(Id);
    }

    public void insertDataTable(String ID, String PWD) {
        Vector<String> dataE = new Vector<String>();
        dataE.addElement(ID);
        dataE.addElement(PWD);
        this.rows.add(dataE);
        this.tableV.addNotify();
        this.tableV.repaint();
    }

    public void insertNewDataTable(String ID, String PWD) {
        String PwdC = this.codifPwd(PWD);
        this.insertDataTable(ID, PwdC);
        this.database.insertUser(ID, PwdC);
    }

    private class NotEditableTableModel
    extends DefaultTableModel {
        private NotEditableTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class UserModif
    extends Dialog
    implements ActionListener {
        boolean id;
        Button ok;
        Button can;
        JLabel username;
        JPasswordField password;
        JTextField username2;

        UserModif(JDialog dialog, String user) {
            super(dialog, "New User ", true);
            this.id = false;
            if (user != null) {
                this.setTitle("Change Password of User " + user);
            }
            Dimension d = new Dimension();
            d.width = 100;
            d.height = 100;
            this.setSize(d);
            this.setLayout(null);
            this.username = new JLabel(user);
            this.username2 = new JTextField(15);
            this.password = new JPasswordField(15);
            Label User = new Label("User:           ");
            Label Password = new Label("Password : ");
            User.setBounds(15, 45, 135, 10);
            if (user != null) {
                this.username.setBounds(100, 40, 150, 20);
                this.add(this.username);
            } else {
                this.username2.setBounds(100, 40, 150, 20);
                this.add(this.username2);
            }
            Password.setBounds(15, 75, 80, 10);
            this.password.setBounds(100, 70, 150, 20);
            this.add(User);
            this.add(Password);
            this.add(this.password);
            this.addOKCancelPanel();
            this.createFrame();
            this.pack();
            int width = 280;
            int height = 150;
            this.setSize(width, height);
            this.setResizable(false);
            this.setVisible(true);
        }

        void addOKCancelPanel() {
            Panel p = new Panel();
            p.setLayout(new FlowLayout());
            this.createButtons(p);
            this.add(p);
            p.setBounds(50, 100, 190, 40);
        }

        void createButtons(Panel p) {
            this.ok = new Button("      OK       ");
            p.add(this.ok);
            this.ok.addActionListener(this);
            this.can = new Button("    Cancel    ");
            p.add(this.can);
            this.can.addActionListener(this);
        }

        void createFrame() {
            Dimension d = this.getToolkit().getScreenSize();
            this.setLocation(d.width / 4, d.height / 3);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.ok) {
                this.id = true;
                this.setVisible(false);
            } else if (ae.getSource() == this.can) {
                this.id = false;
                this.setVisible(false);
            }
        }

        public String getPassword() {
            String Spassword = new String(this.password.getPassword());
            return Spassword;
        }

        public String getUserName() {
            return this.username2.getText();
        }
    }
}

