/*
 * Decompiled with CFR 0.152.
 */
package JSldComponents;

import JSldComponents.JSLDInfoPanel;
import JSldComponents.JSLDLabelToNodo;
import JSldComponents.JSLDLabelToUmg;
import JSldComponents.JSLDParametrosAlgoritmo;
import JSldComponents.JSLDParametrosDeImpresion;
import JSldComponents.JSLDParametrosVisuales;
import JSldComponents.JSLDProyect;
import JSldComponents.JSLDProyectFileFilter;
import JSldComponents.JSLDProyectParams;
import JSldComponents.JSLDTextBox;
import MySwing.PanelSwing;
import SldComponents.SLDArbol;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;

public class JSLDApplicationPanel
extends PanelSwing {
    JSLDProyect proyect;
    String rutaFuentes = ".\\misEjemplos\\";
    JFrame frame = null;
    JApplet applet = null;
    PrinterJob printer;
    PageFormat pf;
    public static int DEFAULT = 1;
    public static int WINDOWS = 2;
    public static int UNIX = 3;
    public static int APPLET = 4;
    private JMenuBar barraMenu;
    private JMenu mnuFile;
    private JMenuItem mnuNuevo;
    private JMenuItem mnuOpenProyect;
    private JMenuItem mnuSaveProyect;
    private JMenuItem mnuSaveProyectAs;
    private JMenuItem mnuSetPrinter;
    private JMenu mnuPrint;
    private JMenuItem mnuPrintBase;
    private JMenuItem mnuPrintCuestion;
    private JMenuItem mnuPrintArbol;
    private JMenuItem mnuOpenBase;
    private JMenuItem mnuOpenCuestion;
    private JMenu mnuBuild;
    private JMenuItem mnuBuildBase;
    private JMenuItem mnuBuildCuestion;
    private JRadioButtonMenuItem mnuBuildCompleto;
    private JRadioButtonMenuItem mnuBuildPasoAPaso;
    private JRadioButtonMenuItem mnuBuildHastaExito;
    private JMenuItem mnuBuildSld;
    private JMenuItem mnuBuildNext;
    private JMenu mnuConfig;
    private JMenuItem mnuConfigVisual;
    private JMenuItem mnuConfigAlg;
    private JMenuItem mnuConfigPrint;
    private JMenu mnuWindowsStyle;
    private JMenuItem mnuWindowsStyleDefault;
    private JMenuItem mnuWindowsStyleWindows;
    private JMenuItem mnuWindowsStyleUnix;
    private JMenuItem mnuWindowsStyleAppelt;
    private JMenu mnuAyuda;
    private JMenuItem mnuEjemplo;
    private JMenuItem mnuShowAyuda;
    private JMenuItem mnuAbout;
    private JTabbedPane tab;
    private JSplitPane pag1;
    private JPanel pag2;
    private JPanel pag3;
    private JPanel pag4;
    private JSLDTextBox txBoxFuenteBase;
    private JTextArea txFuenteBase;
    private JSLDTextBox txBoxFuenteCuestion;
    private JTextArea txFuenteCuestion;
    private JSLDTextBox txBoxParserBase;
    private JTextArea txParserBase;
    private JSLDTextBox txBoxParserCuestion;
    private JTextArea txParserCuestion;
    private JSLDTextBox txBoxSld;
    private JTextArea txSLD;
    private JTree treeSLD;

    public JSLDApplicationPanel(JFrame jFrame) {
        this.frame = jFrame;
        this.printer = PrinterJob.getPrinterJob();
        this.pf = this.printer.defaultPage();
        this.makeInterface(UNIX);
        this.proyect = new JSLDProyect("[sin t\u00edtulo]", this.txFuenteBase, this.txFuenteCuestion, this.txSLD, this, this.txParserBase, this.txParserCuestion, this.printer);
        this.nuevoProyecto();
    }

    public JSLDApplicationPanel(JApplet jApplet) {
        this.applet = jApplet;
        this.printer = PrinterJob.getPrinterJob();
        this.pf = this.printer.defaultPage();
        this.makeInterface(UNIX);
        this.proyect = new JSLDProyect("[sin t\u00edtulo]", this.txFuenteBase, this.txFuenteCuestion, this.txSLD, this, this.txParserBase, this.txParserCuestion, this.printer);
        this.nuevoProyecto();
    }

    public void cambiarEstilo(int n) {
        this.setStyle(n);
        if (this.applet != null) {
            SwingUtilities.updateComponentTreeUI(this.applet);
        } else {
            SwingUtilities.updateComponentTreeUI(this.frame);
        }
    }

    private void setStyle(int n) {
        try {
            switch (n) {
                case 1: {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    break;
                }
                case 2: {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    break;
                }
                case 3: {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    break;
                }
                case 4: {
                    UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
                }
            }
        }
        catch (Exception exception) {
            this.showError("No puedo cambiar a este estilo");
        }
    }

    private Container getContentPane() {
        if (this.applet != null) {
            return this.applet.getContentPane();
        }
        return this.frame.getContentPane();
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.applet != null) {
            this.applet.setJMenuBar(jMenuBar);
        } else {
            this.frame.setJMenuBar(jMenuBar);
        }
    }

    private void repaintApp() {
        if (this.applet != null) {
            this.applet.repaint();
        } else {
            this.frame.repaint();
        }
    }

    private void setMouseCursor(int n) {
        if (this.frame != null) {
            this.frame.setCursor(new Cursor(n));
        } else {
            this.applet.setCursor(new Cursor(n));
        }
        this.tab.setCursor(new Cursor(n));
        this.pag1.setCursor(new Cursor(n));
        this.pag2.setCursor(new Cursor(n));
        this.pag3.setCursor(new Cursor(n));
        this.pag4.setCursor(new Cursor(n));
        this.txBoxFuenteBase.setCursor(new Cursor(n));
        this.txBoxFuenteCuestion.setCursor(new Cursor(n));
        this.txBoxParserBase.setCursor(new Cursor(n));
        this.txBoxParserCuestion.setCursor(new Cursor(n));
        this.txBoxSld.setCursor(new Cursor(n));
        if (n == 0) {
            this.txFuenteBase.setCursor(new Cursor(2));
            this.txFuenteCuestion.setCursor(new Cursor(2));
            this.txParserBase.setCursor(new Cursor(2));
            this.txParserCuestion.setCursor(new Cursor(2));
            this.txSLD.setCursor(new Cursor(2));
        } else {
            this.txFuenteBase.setCursor(new Cursor(3));
            this.txFuenteCuestion.setCursor(new Cursor(3));
            this.txParserBase.setCursor(new Cursor(3));
            this.txParserCuestion.setCursor(new Cursor(3));
            this.txSLD.setCursor(new Cursor(3));
        }
    }

    private void makeInterface(int n) {
        this.setStyle(DEFAULT);
        this.barraMenu = new JMenuBar();
        this.mnuFile = new JMenu("Archivos");
        this.mnuNuevo = new JMenuItem("Nuevo");
        this.mnuNuevo.addActionListener(this);
        this.mnuFile.add(this.mnuNuevo);
        this.mnuFile.addSeparator();
        this.mnuOpenProyect = new JMenuItem("Abrir proyecto");
        this.mnuOpenProyect.addActionListener(this);
        this.mnuFile.add(this.mnuOpenProyect);
        this.mnuSaveProyect = new JMenuItem("Guardar proyecto");
        this.mnuSaveProyect.addActionListener(this);
        this.mnuFile.add(this.mnuSaveProyect);
        this.mnuSaveProyectAs = new JMenuItem("Guardar proyecto como");
        this.mnuSaveProyectAs.addActionListener(this);
        this.mnuFile.add(this.mnuSaveProyectAs);
        this.mnuFile.addSeparator();
        this.mnuSetPrinter = new JMenuItem("Configurar Impresora");
        this.mnuSetPrinter.addActionListener(this);
        this.mnuFile.add(this.mnuSetPrinter);
        this.mnuPrint = new JMenu("Imprimir");
        this.mnuFile.add(this.mnuPrint);
        this.mnuPrintBase = new JMenuItem("Imprimir programa");
        this.mnuPrintBase.addActionListener(this);
        this.mnuPrint.add(this.mnuPrintBase);
        this.mnuPrintCuestion = new JMenuItem("Imprimir objetivo");
        this.mnuPrintCuestion.addActionListener(this);
        this.mnuPrint.add(this.mnuPrintCuestion);
        this.mnuPrintArbol = new JMenuItem("Imprimir \u00e1rbol");
        this.mnuPrintArbol.addActionListener(this);
        this.mnuPrint.add(this.mnuPrintArbol);
        this.mnuFile.addSeparator();
        this.mnuOpenBase = new JMenuItem("Importar programa");
        this.mnuOpenBase.addActionListener(this);
        this.mnuFile.add(this.mnuOpenBase);
        this.mnuOpenCuestion = new JMenuItem("Importar objetivo");
        this.mnuOpenCuestion.addActionListener(this);
        this.mnuFile.add(this.mnuOpenCuestion);
        if (this.applet != null) {
            this.mnuOpenProyect.setEnabled(false);
            this.mnuSaveProyect.setEnabled(false);
            this.mnuSaveProyectAs.setEnabled(false);
            this.mnuOpenBase.setEnabled(false);
            this.mnuOpenCuestion.setEnabled(false);
        }
        this.barraMenu.add(this.mnuFile);
        this.mnuBuild = new JMenu("Creaci\u00f3n");
        this.mnuBuildBase = new JMenuItem("Interpretar programa");
        this.mnuBuildBase.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildBase);
        this.mnuBuildCuestion = new JMenuItem("Interpretar objetivo");
        this.mnuBuildCuestion.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildCuestion);
        this.mnuBuild.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mnuBuildCompleto = new JRadioButtonMenuItem("Generar \u00e1rbol completo");
        buttonGroup.add(this.mnuBuildCompleto);
        this.mnuBuildCompleto.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildCompleto);
        this.mnuBuildCompleto.setSelected(true);
        this.mnuBuildPasoAPaso = new JRadioButtonMenuItem("Generar \u00e1rbol nodo a nodo");
        buttonGroup.add(this.mnuBuildPasoAPaso);
        this.mnuBuildPasoAPaso.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildPasoAPaso);
        this.mnuBuildHastaExito = new JRadioButtonMenuItem("Generar \u00e1rbol \u00e9xito a \u00e9xito");
        buttonGroup.add(this.mnuBuildHastaExito);
        this.mnuBuildHastaExito.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildHastaExito);
        this.mnuBuild.addSeparator();
        this.mnuBuildSld = new JMenuItem("Ejecutar");
        this.mnuBuildSld.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildSld);
        this.mnuBuildNext = new JMenuItem("Siguiente paso");
        this.mnuBuildNext.addActionListener(this);
        this.mnuBuild.add(this.mnuBuildNext);
        this.barraMenu.add(this.mnuBuild);
        this.mnuConfig = new JMenu("Configuraci\u00f3n");
        this.mnuConfigVisual = new JMenuItem("Conf. Visual");
        this.mnuConfigVisual.addActionListener(this);
        this.mnuConfig.add(this.mnuConfigVisual);
        this.mnuConfigAlg = new JMenuItem("Conf. Algoritmo");
        this.mnuConfigAlg.addActionListener(this);
        this.mnuConfig.add(this.mnuConfigAlg);
        this.mnuConfigPrint = new JMenuItem("Conf. Impresi\u00f3n \u00c1rbol");
        this.mnuConfigPrint.addActionListener(this);
        this.mnuConfig.add(this.mnuConfigPrint);
        this.mnuConfig.addSeparator();
        this.mnuWindowsStyle = new JMenu("Estilo de ventana");
        this.mnuWindowsStyle.addActionListener(this);
        this.mnuConfig.add(this.mnuWindowsStyle);
        this.mnuWindowsStyleDefault = new JMenuItem("Por defecto (Applet)");
        this.mnuWindowsStyleDefault.addActionListener(this);
        this.mnuWindowsStyle.add(this.mnuWindowsStyleDefault);
        this.mnuWindowsStyleWindows = new JMenuItem("Windows");
        this.mnuWindowsStyleWindows.addActionListener(this);
        this.mnuWindowsStyle.add(this.mnuWindowsStyleWindows);
        this.mnuWindowsStyleUnix = new JMenuItem("Unix");
        this.mnuWindowsStyleUnix.addActionListener(this);
        this.mnuWindowsStyle.add(this.mnuWindowsStyleUnix);
        this.mnuWindowsStyleAppelt = new JMenuItem("Apple");
        this.mnuWindowsStyleAppelt.addActionListener(this);
        this.mnuWindowsStyle.add(this.mnuWindowsStyleAppelt);
        this.barraMenu.add(this.mnuConfig);
        this.mnuAyuda = new JMenu("Ayuda");
        this.mnuEjemplo = new JMenuItem("Ejemplo");
        this.mnuEjemplo.addActionListener(this);
        this.mnuAyuda.add(this.mnuEjemplo);
        this.mnuShowAyuda = new JMenuItem("Ayuda");
        this.mnuShowAyuda.addActionListener(this);
        this.mnuAyuda.add(this.mnuShowAyuda);
        this.mnuAyuda.addSeparator();
        this.mnuAbout = new JMenuItem("Sobre JSld");
        this.mnuAbout.addActionListener(this);
        this.mnuAyuda.add(this.mnuAbout);
        this.barraMenu.add(this.mnuAyuda);
        this.setJMenuBar(this.barraMenu);
        this.getContentPane().setLayout(new BorderLayout());
        this.tab = new JTabbedPane(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tab, "Center");
        this.getContentPane().add((Component)this, "Center");
        this.tab.addKeyListener(this);
        this.txBoxFuenteBase = new JSLDTextBox("C\u00f3digo fuente: programa", JSLDTextBox.INFOUP, this.printer);
        this.txFuenteBase = this.txBoxFuenteBase.getTxt();
        this.txFuenteBase.setFont(new Font("Arial", 0, 14));
        this.txFuenteBase.getDocument().addDocumentListener(this);
        this.txBoxFuenteCuestion = new JSLDTextBox("C\u00f3digo fuente: objetivo", JSLDTextBox.INFOUP, this.printer);
        this.txFuenteCuestion = this.txBoxFuenteCuestion.getTxt();
        this.txFuenteCuestion.setFont(new Font("Arial", 0, 14));
        this.txFuenteCuestion.setForeground(Color.blue);
        this.txFuenteCuestion.setCaretColor(Color.blue);
        this.txFuenteCuestion.getDocument().addDocumentListener(this);
        this.pag1 = new JSplitPane(0, true, this.txBoxFuenteBase, this.txBoxFuenteCuestion);
        this.pag1.setOneTouchExpandable(true);
        this.pag1.setResizeWeight(0.9);
        this.tab.addTab("Conocimiento", this.pag1);
        this.txBoxParserBase = new JSLDTextBox("Salida analizador (Programa)", this.printer);
        this.txParserBase = this.txBoxParserBase.getTxt();
        this.txParserBase.setFont(new Font("Arial", 2, 12));
        this.txParserBase.setEditable(false);
        this.txBoxParserCuestion = new JSLDTextBox("Salida analizador (Objetivo)", this.printer);
        this.txParserCuestion = this.txBoxParserCuestion.getTxt();
        this.txParserCuestion.setEditable(false);
        this.txParserCuestion.setFont(new Font("Arial", 2, 12));
        this.txParserCuestion.setEditable(false);
        this.pag2 = new JPanel(new BorderLayout());
        this.pag2.add((Component)this.txBoxParserBase, "Center");
        this.pag2.add((Component)this.txBoxParserCuestion, "South");
        this.tab.addTab("Sal. Analizador", this.pag2);
        this.txBoxSld = new JSLDTextBox("Salida Algoritmo SLD.", this.printer);
        this.txSLD = this.txBoxSld.getTxt();
        this.txSLD.setEditable(false);
        this.pag3 = new JPanel(new BorderLayout());
        this.pag3.add((Component)this.txBoxSld, "Center");
        this.tab.addTab("Traza", this.pag3);
        this.pag4 = new JPanel(new BorderLayout());
        this.tab.addTab("\u00c1rbol SLD", this.pag4);
        this.pag4.addKeyListener(this);
        this.setVisible(true);
    }

    public void onKeyPressed(KeyEvent keyEvent) {
        if (this.isTabArbol()) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (n2 == 2) {
                if (n == 37) {
                    this.getProyect().moveTreeIzq();
                } else if (n == 39) {
                    this.getProyect().moveTreeDer();
                } else if (n == 38) {
                    this.getProyect().moveTreeUp();
                } else if (n == 40) {
                    this.getProyect().moveTreeDown();
                }
            } else if (n2 == 1) {
                if (n == 39) {
                    this.getProyect().incFactorX();
                } else if (n == 37) {
                    this.getProyect().decFactorX();
                } else if (n == 40) {
                    this.getProyect().incFactorY();
                } else if (n == 38) {
                    this.getProyect().decFactorY();
                }
            } else if (n == 521) {
                this.setMouseCursor(3);
                this.getProyect().incNivelMaximo();
                this.repaintApp();
                this.setMouseCursor(0);
            } else if (n == 45) {
                this.setMouseCursor(3);
                this.getProyect().decNivelMaximo();
                this.repaintApp();
                this.setMouseCursor(0);
            } else if (n == 33) {
                this.getProyect().decFuente();
                this.repaintApp();
            } else if (n == 34) {
                this.getProyect().incFuente();
                this.repaintApp();
            } else if (n == 78) {
                this.paintNext();
            }
        }
    }

    public void onDocumentChanged(DocumentEvent documentEvent) {
        if (this.txFuenteBase.getDocument().equals(documentEvent.getDocument())) {
            this.proyect.setBaseChanged(true);
        }
        if (this.txFuenteCuestion.getDocument().equals(documentEvent.getDocument())) {
            this.proyect.setCuestionChanged(true);
        }
    }

    public void onButtonClick(ActionEvent actionEvent) {
        try {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.equals(this.mnuNuevo)) {
                this.nuevoProyecto();
            }
            if (jMenuItem.equals(this.mnuOpenProyect)) {
                this.leerFicheroProyecto();
            }
            if (jMenuItem.equals(this.mnuSaveProyect)) {
                this.guardarFicheroProyecto();
            }
            if (jMenuItem.equals(this.mnuSaveProyectAs)) {
                this.guardarFicheroProyectoAs();
            }
            if (jMenuItem.equals(this.mnuSetPrinter)) {
                this.pf = this.printer.pageDialog(this.pf);
                this.proyect.setPageFormat(this.pf);
            }
            if (jMenuItem.equals(this.mnuPrintBase)) {
                this.txBoxFuenteBase.printText();
            }
            if (jMenuItem.equals(this.mnuPrintCuestion)) {
                this.txBoxFuenteCuestion.printText();
            }
            if (jMenuItem.equals(this.mnuPrintArbol)) {
                this.getProyect().printerTree(this.printer, this.pf);
            }
            if (jMenuItem.equals(this.mnuOpenBase)) {
                this.leerFicheroBase();
                this.compileFicheroBase();
            }
            if (jMenuItem.equals(this.mnuOpenCuestion)) {
                this.leerFicheroCuestion();
                this.compileFicheroCuestion();
            }
            if (jMenuItem.equals(this.mnuBuildBase)) {
                this.compileFicheroBase();
            }
            if (jMenuItem.equals(this.mnuBuildCuestion)) {
                this.compileFicheroCuestion();
            }
            if (jMenuItem.equals(this.mnuBuildCompleto)) {
                this.proyect.setModoRepresentacion(JSLDProyectParams.MAKE_COMPLETO);
            }
            if (jMenuItem.equals(this.mnuBuildPasoAPaso)) {
                this.proyect.setModoRepresentacion(JSLDProyectParams.MAKE_PASOAPASO);
            }
            if (jMenuItem.equals(this.mnuBuildHastaExito)) {
                this.proyect.setModoRepresentacion(JSLDProyectParams.MAKE_EXITOAEXITO);
            }
            if (jMenuItem.equals(this.mnuBuildSld)) {
                if (this.getNumProyect() == -1) {
                    this.compileArbolSld();
                } else {
                    this.compileSubProyect(this.getNumProyect());
                }
            }
            if (jMenuItem.equals(this.mnuBuildNext)) {
                this.paintNext();
            }
            if (jMenuItem.equals(this.mnuConfigVisual)) {
                int n = this.getProyect().getProyectParams().getFuente();
                JSLDParametrosVisuales jSLDParametrosVisuales = new JSLDParametrosVisuales(this.getProyect().getProyectParams());
                jSLDParametrosVisuales.setModal(true);
                jSLDParametrosVisuales.setLocationRelativeTo(this);
                jSLDParametrosVisuales.setVisible(true);
                if (!jSLDParametrosVisuales.operacionCancelada()) {
                    this.getProyect().repaintTree();
                    this.repaintApp();
                }
            }
            if (jMenuItem.equals(this.mnuConfigAlg)) {
                JSLDParametrosAlgoritmo jSLDParametrosAlgoritmo = new JSLDParametrosAlgoritmo(this.getProyect().getProyectParams());
                jSLDParametrosAlgoritmo.setModal(true);
                jSLDParametrosAlgoritmo.setLocationRelativeTo(this);
                jSLDParametrosAlgoritmo.setVisible(true);
                if (!jSLDParametrosAlgoritmo.operacionCancelada()) {
                    if (this.getNumProyect() == -1) {
                        this.compileArbolSld();
                    } else {
                        this.compileSubProyect(this.getNumProyect());
                    }
                }
            }
            if (jMenuItem.equals(this.mnuConfigPrint)) {
                JSLDParametrosDeImpresion jSLDParametrosDeImpresion = new JSLDParametrosDeImpresion(this.getProyect().getProyectParams(), this.getProyect().getTreePanel());
                jSLDParametrosDeImpresion.setModal(true);
                jSLDParametrosDeImpresion.setLocationRelativeTo(this);
                jSLDParametrosDeImpresion.setVisible(true);
                this.getProyect().getTreePanel();
            }
            if (jMenuItem.equals(this.mnuWindowsStyleDefault)) {
                this.cambiarEstilo(DEFAULT);
            }
            if (jMenuItem.equals(this.mnuWindowsStyleWindows)) {
                this.cambiarEstilo(WINDOWS);
            }
            if (jMenuItem.equals(this.mnuWindowsStyleUnix)) {
                this.cambiarEstilo(UNIX);
            }
            if (jMenuItem.equals(this.mnuWindowsStyleAppelt)) {
                this.cambiarEstilo(APPLET);
            }
            if (jMenuItem.equals(this.mnuEjemplo)) {
                this.showEjemplo();
            }
            if (jMenuItem.equals(this.mnuShowAyuda)) {
                this.showAyuda();
            }
            if (jMenuItem.equals(this.mnuAbout)) {
                this.showAbout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n;
            if (mouseEvent.getSource().getClass().getName() == "JSldComponents.JSLDLabelToNodo") {
                if (!mouseEvent.isControlDown()) {
                    ((JSLDLabelToNodo)mouseEvent.getSource()).Show(this);
                } else {
                    n = ((JSLDLabelToNodo)mouseEvent.getSource()).getNodo().getTipoNodo();
                    if (n == SLDArbol._NODO || n == SLDArbol._RAIZ || n == SLDArbol._HOJAPODADA) {
                        this.setMouseCursor(3);
                        this.addSubProyect(((JSLDLabelToNodo)mouseEvent.getSource()).getNodo());
                        this.setMouseCursor(0);
                    }
                }
            }
            if (mouseEvent.getSource().getClass().getName() == "JSldComponents.JSLDLabelToUmg") {
                ((JSLDLabelToUmg)mouseEvent.getSource()).Show(this);
            }
            if (mouseEvent.getSource().getClass().getName() == "JSldComponents.JSLDLabelClose" && (n = this.getNumProyect()) > -1) {
                this.deleteSubProyect(this.getNumProyect());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void nuevoProyecto() {
        int n = this.proyect != null ? this.proyect.getProyectParams().getModoRepresentacion() : 0;
        this.proyect = new JSLDProyect("[sin t\u00edtulo]", this.txFuenteBase, this.txFuenteCuestion, this.txSLD, this, this.txParserBase, this.txParserCuestion, this.printer);
        this.txBoxFuenteBase.appendTitulo(" [sin t\u00edtulo]");
        this.txFuenteBase.setText("");
        this.txFuenteCuestion.setText("");
        this.txParserBase.setText("");
        this.txParserCuestion.setText("");
        this.txSLD.setText("");
        this.pag4.removeAll();
        int n2 = this.tab.getTabCount();
        int n3 = n2 - 1;
        while (n3 >= 4) {
            this.tab.remove(n3);
            --n3;
        }
        this.repaintApp();
        this.proyect.getProyectParams().setModoRepresentacion(n);
        this.proyect.setPageFormat(this.pf);
    }

    private String selectFichero() {
        JFileChooser jFileChooser = new JFileChooser(this.rutaFuentes);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.rutaFuentes = jFileChooser.getCurrentDirectory().toString() + "\\";
            return jFileChooser.getSelectedFile().getPath();
        }
        return "";
    }

    private String setFichero() {
        JFileChooser jFileChooser = new JFileChooser(this.rutaFuentes);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.rutaFuentes = jFileChooser.getCurrentDirectory().toString() + "\\";
            return jFileChooser.getSelectedFile().getPath();
        }
        return "";
    }

    private void readInTextArea(String string, JTextArea jTextArea) {
        try {
            byte[] byArray = new byte[1];
            jTextArea.setText("");
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            while (fileInputStream.read(byArray) != -1) {
                jTextArea.append(new String(byArray));
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            jTextArea.append("Error de lectura del fichero '" + string + "'.");
        }
    }

    private void writeFromTextArea(String string, JTextArea jTextArea) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(jTextArea.getText().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            jTextArea.append("Error de escritura del fichero '" + string + "'.");
        }
    }

    private void leerFicheroBase() {
        String string = this.selectFichero();
        this.repaint();
        if (string.compareTo("") != 0) {
            this.setMouseCursor(3);
            this.readInTextArea(string, this.txFuenteBase);
            this.proyect.setBaseChanged(true);
            this.setMouseCursor(0);
        }
    }

    private void leerFicheroCuestion() {
        String string = this.selectFichero();
        this.repaint();
        if (string.compareTo("") != 0) {
            this.setMouseCursor(3);
            this.readInTextArea(string, this.txFuenteCuestion);
            this.proyect.setCuestionChanged(true);
            this.setMouseCursor(0);
        }
    }

    private void leerFicheroProyecto() {
        JFileChooser jFileChooser = new JFileChooser(this.rutaFuentes);
        jFileChooser.setFileFilter(new JSLDProyectFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.repaint();
            this.rutaFuentes = jFileChooser.getCurrentDirectory().toString() + "\\";
            String string = jFileChooser.getCurrentDirectory().toString() + "\\";
            String string2 = jFileChooser.getSelectedFile().getPath().substring(string.length());
            if (string2.toUpperCase().endsWith(".PRJ")) {
                String string3 = string2.substring(0, string2.length() - 4);
                this.nuevoProyecto();
                this.setMouseCursor(3);
                this.proyect.loadProyect(string, string3);
                this.txBoxFuenteBase.appendTitulo(" [" + string3 + "]");
                this.compileArbolSld();
                this.setMouseCursor(0);
            } else {
                this.showError("El fichero no tiene extensi\u00f3n '.prj', no es un proyecto.");
            }
        }
    }

    private void guardarFicheroProyecto() {
        if (this.proyect.getPathProyect().compareTo("") == 0) {
            this.guardarFicheroProyectoAs();
        } else {
            this.setMouseCursor(3);
            this.proyect.saveProyect();
            this.setMouseCursor(0);
        }
    }

    private void guardarFicheroProyectoAs() {
        JFileChooser jFileChooser = new JFileChooser(this.rutaFuentes);
        jFileChooser.setFileFilter(new JSLDProyectFileFilter());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.repaint();
            this.rutaFuentes = jFileChooser.getCurrentDirectory().toString() + "\\";
            String string = jFileChooser.getCurrentDirectory().toString() + "\\";
            String string2 = jFileChooser.getSelectedFile().getPath().substring(string.length());
            if (string2.toUpperCase().endsWith(".PRJ")) {
                String string3 = string2.substring(0, string2.length() - 4);
                this.setMouseCursor(3);
                this.proyect.saveProyectAs(string, string3);
                this.txBoxFuenteBase.appendTitulo(" [" + string3 + "]");
                this.setMouseCursor(0);
            } else {
                this.showError("El fichero no tiene extension '.prj', p\u00f3ngale esta extensi\u00f3n.");
            }
        }
    }

    private void compileFicheroBase() {
        this.setMouseCursor(3);
        if (!this.proyect.compileBase()) {
            this.tab.setSelectedIndex(2);
        }
        this.setMouseCursor(0);
    }

    private void compileFicheroCuestion() {
        this.setMouseCursor(3);
        if (!this.proyect.compileCuestion()) {
            this.tab.setSelectedIndex(2);
        }
        this.setMouseCursor(0);
    }

    private void compileArbolSld() {
        this.setMouseCursor(3);
        this.txSLD.setText("");
        this.pag4.removeAll();
        this.txSLD.append("Iniciamos Algoritmo SLD del proyecto " + this.proyect.getNombre() + "\n");
        if (!this.proyect.compileArbol(this.txSLD)) {
            this.tab.setSelectedIndex(2);
        } else {
            this.tab.setSelectedIndex(3);
        }
        this.pag4.add(this.proyect.getScrollPanel());
        this.repaintApp();
        this.setMouseCursor(0);
    }

    private void paintNext() {
        this.setMouseCursor(3);
        this.getProyect().calcularNext();
        this.getProyect().paintTree();
        this.repaintApp();
        this.setMouseCursor(0);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error al guardar", 0);
    }

    public boolean isTabArbol() {
        return this.tab.getSelectedIndex() >= 3;
    }

    public int getNumProyect() {
        int n = 4;
        if (this.tab.getSelectedIndex() < n) {
            return -1;
        }
        return this.tab.getSelectedIndex() - n;
    }

    public JSLDProyect getProyect() {
        if (this.getNumProyect() == -1) {
            return this.proyect;
        }
        return this.proyect.getSubProyect(this.getNumProyect());
    }

    public void addSubProyect(SLDArbol sLDArbol) {
        this.setMouseCursor(3);
        int n = this.proyect.addSubProyect(sLDArbol, this.txSLD, this.getProyect().getProyectParams(), this.pf);
        this.proyect.compileSubProyect(n, this.txSLD);
        this.tab.add("SubArbol " + n, this.proyect.getSubProyect(n).getScrollPanel());
        this.tab.setSelectedIndex(this.tab.getTabCount() - 1);
        this.repaintApp();
        this.setMouseCursor(0);
    }

    public void deleteSubProyect(int n) {
        int n2 = 4;
        this.proyect.deleteSubProyect(n);
        this.tab.remove(n + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileSubProyect(int n) {
        try {
            try {
                this.setMouseCursor(3);
                this.proyect.compileSubProyect(n, this.txSLD);
                this.repaintApp();
                this.setMouseCursor(0);
            }
            catch (Exception exception) {
                this.txSLD.append("Error al mostrar SubTree " + n + ": " + exception.toString() + " \n");
                Object var4_3 = null;
                this.txSLD.append("Jtree mostrado\n");
                this.setMouseCursor(0);
            }
            Object var4_2 = null;
            this.txSLD.append("Jtree mostrado\n");
            this.setMouseCursor(0);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.txSLD.append("Jtree mostrado\n");
            this.setMouseCursor(0);
            throw throwable;
        }
    }

    public void showEjemplo() {
        this.nuevoProyecto();
        this.txFuenteBase.setText("");
        this.txFuenteCuestion.setText("");
        this.txFuenteBase.append("%\t\tejemplo de suma de naturales\n");
        this.txFuenteBase.append("%\n");
        this.txFuenteBase.append("% ------------------------------------\n");
        this.txFuenteBase.append("\n");
        this.txFuenteBase.append("nat(c).\n");
        this.txFuenteBase.append("nat(s(X)):-nat(X).\n");
        this.txFuenteBase.append("suma(c,Y,Y):-nat(Y).\n");
        this.txFuenteBase.append("suma(s(X),Y,s(Z)):-suma(X,Y,Z).\n");
        this.txFuenteCuestion.append("suma(X,Y,s(s(s(s(c))))).\n");
        this.proyect.getProyectParams().setFactorY(70);
        this.proyect.getProyectParams().setX(40);
        this.compileArbolSld();
    }

    public void showAyuda() {
        String string = "";
        string = string + "<HTML>";
        string = string + "<BODY bgcolor=white text=black>";
        string = string + "<CENTER><H3>Ayuda sobre el manejo de la aplicaci\u00f3n</H3></CENTER>";
        string = string + "<TABLE width=600>";
        string = string + "<TR><TD><BR>";
        string = string + "<U><B>1. Panel del \u00e1rbol </B></U><BR>";
        string = string + "<BR>";
        string = string + "<UL>";
        string = string + "<LI><B>1.1. Teclas de acceso r\u00e1pido</B> <BR>";
        string = string + "<BR>";
        string = string + "<TABLE border>";
        string = string + "<TR><TD>Ctrl + Flecha izquierda</TD><TD>Mueve el \u00e1rbol a la  izquierda </TD></TR>";
        string = string + "<TR><TD>Ctrl + Flecha derecha</TD><TD>Mueve el \u00e1rbol a la  derecha</TD></TR>";
        string = string + "<TR><TD>Ctrl + Flecha arriba</TD><TD>Mueve el \u00e1rbol hacia arriba</TD></TR>";
        string = string + "<TR><TD>Ctrl + Flecha abajo</TD><TD>Mueve el \u00e1rbol hacia abajo</TD></TR>";
        string = string + "</TABLE>";
        string = string + "<BR>\t ";
        string = string + "<TABLE border>\t";
        string = string + "<TR><TD>Shift + Flecha izquierda </TD><TD>Decrementa el factor de separaci\u00f3n horizontal </TD></TR>";
        string = string + "<TR><TD>Shift + Flecha derecha</TD><TD>Incrementa el factor de separaci\u00f3n horizontal </TD></TR>";
        string = string + "<TR><TD>Shift + Flecha arriba</TD><TD>Decrementa el factor de separaci\u00f3n vertical </TD></TR>";
        string = string + "<TR><TD>Shift + Flecha abajo</TD><TD>Incrementa el factor de separaci\u00f3n vertical </TD></TR>";
        string = string + "</TABLE>\t ";
        string = string + "<BR>\t ";
        string = string + "<TABLE border>\t";
        string = string + "<TR><TD>+ </TD><TD>Incrementa el nivel m\u00e1ximo de representaci\u00f3n del \u00e1rbol </TD></TR>";
        string = string + "<TR><TD>- </TD><TD>Decrementa el nivel m\u00e1ximo de representaci\u00f3n del \u00e1rbol </TD></TR>";
        string = string + "</TABLE>\t ";
        string = string + "<BR>";
        string = string + "<TABLE border>\t";
        string = string + "<TR><TD>Retrocede p\u00e1gina</TD><TD>Decrementa el tama\u00f1o de la fuente de texto del \u00e1rbol </TD></TR>";
        string = string + "<TR><TD>Avance p\u00e1gina</TD><TD>Incrementa el tama\u00f1o de la fuente de texto del \u00e1rbol </TD></TR>";
        string = string + "</TABLE>\t ";
        string = string + "<BR>";
        string = string + "<LI><b>1.2. Obtener informaci\u00f3n contenida en el \u00e1rbol</b>";
        string = string + "<TABLE>\t";
        string = string + "<TR><TD> Desde un nodo podemos obtener informaci\u00f3n de dicho nodo";
        string = string + " y desde una unificaci\u00f3n podemos ver el desarrollo del algoritmo de";
        string = string + "unificaci\u00f3n de Robinson para obtener esa unificaci\u00f3n. ";
        string = string + "<UL>";
        string = string + "\t<LI> Para obtener informaci\u00f3n de un nodo concreto hacer click sobre el nodo.";
        string = string + "\t<LI> Para obtener informaci\u00f3n del algoritmo de unificacion de Robinson hacer click sobre la unificaci\u00f3n.";
        string = string + "</UL>";
        string = string + "</TD></TR>";
        string = string + "</TABLE>\t";
        string = string + "<LI><B>1.3. Generar un subarbol desde un nodo concreto del \u00e1rbol.</B>";
        string = string + "<TABLE>\t";
        string = string + "<TR><TD>Para generar subarboles a partir de un nodo de un \u00e1rbol pulsar la tecla Ctrl y hacer click sobre dicho nodo.";
        string = string + "Esto generara un nuevo panel, con una configuraci\u00f3n personalizada con este nodo como ra\u00edz.  </TD></TR>";
        string = string + "</TABLE>";
        string = string + "</TD></TR></TABLE>";
        string = string + "</BODY>";
        string = string + "</HTML>";
        JSLDInfoPanel jSLDInfoPanel = new JSLDInfoPanel("Ayuda", string, 600, 400);
        jSLDInfoPanel.setModal(true);
        jSLDInfoPanel.pack();
        jSLDInfoPanel.setLocationRelativeTo(this);
        jSLDInfoPanel.setVisible(true);
    }

    public void showAbout() {
        String string = "";
        string = string + "<HTML>";
        string = string + "<BODY bgcolor=white text=black>";
        string = string + "<CENTER>";
        string = string + "<H3>JSLD</H3>";
        string = string + "<H4> Visor de \u00e1rboles SLD v 1.0</H4>";
        string = string + "<H5>Proyecto de fin de carrera. Curso 2002.</H5>";
        string = string + "<TABLE border cellpadding=5>";
        string = string + "<TR>";
        string = string + "\t<TD>Alumno</TD>";
        string = string + "\t<TD>Antonio Jes\u00fas Pareces Garc\u00eda<br><font size = 2 color=blue >parantjuma@supercable.es</font></TD>";
        string = string + "</TR>";
        string = string + "<TR>";
        string = string + "\t<TD>Tutor</TD>";
        string = string + "\t<TD>Francisco Guti\u00e9rrez L\u00f3pez<br><font size = 2 color=blue >pacog@lcc.uma.es</font></TD>";
        string = string + "</TR>";
        string = string + "<TR>";
        string = string + "\t<TD>Universidad</TD>";
        string = string + "\t<TD>LCC. UMA (M\u00e1laga)</TD>";
        string = string + "</TR>";
        string = string + "</TABLE>";
        string = string + "</CENTER>";
        string = string + "</BODY>";
        string = string + "</HTML>";
        JSLDInfoPanel jSLDInfoPanel = new JSLDInfoPanel("Sobre Jsld.", string, 0, 0);
        jSLDInfoPanel.setModal(true);
        jSLDInfoPanel.pack();
        jSLDInfoPanel.setLocationRelativeTo(this);
        jSLDInfoPanel.setVisible(true);
    }
}

