/*
 * Decompiled with CFR 0.152.
 */
package JSldComponents;

import JSldComponents.JSLDPainterTree;
import JSldComponents.JSLDProyectParams;
import JSldComponents.JSLDSubProyect;
import JSldComponents.JSLDTreePanel;
import ParserProlog.CUPError;
import ParserProlog.LexError;
import ParserProlog.PrologComponents.Cuestion;
import ParserProlog.PrologComponents.Programa;
import SldComponents.SLDAlgoritmo;
import SldComponents.SLDArbol;
import SldComponents.SLDReglaDeBusqueda;
import SldComponents.SLDReglaDeBusquedaAleatoria;
import SldComponents.SLDReglaDeBusquedaDownUp;
import SldComponents.SLDReglaDeBusquedaUpDown;
import SldComponents.SLDReglaDeSeleccion;
import SldComponents.SLDReglaDeSeleccionAleatoria;
import SldComponents.SLDReglaDeSeleccionDerIzq;
import SldComponents.SLDReglaDeSeleccionIzqDer;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JSLDProyect {
    protected String nombre = "";
    protected String pathProyect = "";
    protected String fileProyect = "";
    protected String fileBase = "";
    protected String fileCuestion = "";
    protected boolean baseChanged;
    protected boolean cuestionChanged;
    protected Programa objBase;
    protected Cuestion objCuestion;
    protected SLDAlgoritmo alg;
    protected SLDArbol arbol;
    protected JSLDProyectParams proyectParams;
    protected JSLDPainterTree painter;
    protected JSLDTreePanel treePanel;
    protected JScrollPane scrollPanel;
    protected JTextArea txCuestion;
    protected JTextArea txBase;
    protected JTextArea txOutCuestion;
    protected JTextArea txOutBase;
    protected JTextArea txOut;
    protected MouseListener mouseListener;
    protected Vector subProyectos;
    protected PrinterJob printer;

    public JSLDProyect(String string, JTextArea jTextArea, JTextArea jTextArea2, JTextArea jTextArea3, MouseListener mouseListener, JTextArea jTextArea4, JTextArea jTextArea5, PrinterJob printerJob) {
        this.printer = printerJob;
        this.proyectClear();
        this.nombre = string;
        this.txBase = jTextArea;
        this.txCuestion = jTextArea2;
        this.txOut = jTextArea3;
        this.txOutBase = jTextArea4;
        this.txOutCuestion = jTextArea5;
        this.mouseListener = mouseListener;
    }

    public JSLDProyect(String string, PrinterJob printerJob, PageFormat pageFormat) {
        this.printer = printerJob;
        this.proyectClear();
        this.getTreePanel().setPageFormat(pageFormat);
        this.nombre = string;
        this.txBase = null;
        this.txCuestion = null;
        this.txOut = null;
        this.txOutBase = null;
        this.txOutCuestion = null;
        this.mouseListener = null;
    }

    public void proyectClear() {
        this.nombre = "";
        this.baseChanged = true;
        this.cuestionChanged = true;
        this.objBase = null;
        this.objCuestion = null;
        this.arbol = null;
        if (this.getProyectParams() != null) {
            int n = this.getProyectParams().getModoRepresentacion();
            this.setProyectParams(new JSLDProyectParams());
            this.getProyectParams().setModoRepresentacion(n);
        } else {
            this.setProyectParams(new JSLDProyectParams());
        }
        this.treePanel = null;
        this.scrollPanel = new JScrollPane();
        this.alg = null;
        this.painter = new JSLDPainterTree(this.mouseListener);
        this.setSubProyectos(new Vector());
        this.setTreePanel(new JSLDTreePanel(null, this.getProyectParams(), this.printer));
        this.setScrollPanel(new JScrollPane(this.getTreePanel()));
    }

    public String getNombre() {
        return this.nombre;
    }

    public boolean getBaseChanged() {
        return this.baseChanged;
    }

    public boolean getCuestionChanged() {
        return this.cuestionChanged;
    }

    public boolean getArbolChanged() {
        return this.cuestionChanged || this.baseChanged;
    }

    public Cuestion getCuestion() {
        return this.objCuestion;
    }

    public Programa getBase() {
        return this.objBase;
    }

    public String getFileProyect() {
        return this.fileProyect;
    }

    public String getPathProyect() {
        return this.pathProyect;
    }

    public String getFileBase() {
        return this.fileBase;
    }

    public String getFileCuestion() {
        return this.fileCuestion;
    }

    public SLDArbol getArbol() {
        return this.arbol;
    }

    public JSLDProyectParams getProyectParams() {
        return this.proyectParams;
    }

    public JSLDTreePanel getTreePanel() {
        return this.treePanel;
    }

    public JScrollPane getScrollPanel() {
        return this.scrollPanel;
    }

    public JTextArea getTxBase() {
        return this.txBase;
    }

    public JTextArea getTxCuestion() {
        return this.txCuestion;
    }

    public SLDAlgoritmo getAlgoritmo() {
        return this.alg;
    }

    public JSLDPainterTree getPainter() {
        return this.painter;
    }

    public Vector getSubProyectos() {
        return this.subProyectos;
    }

    public JTextArea getTxOut() {
        return this.txOut;
    }

    public JTextArea getTxOutBase() {
        return this.txOutBase;
    }

    public JTextArea getTxOutCuestion() {
        return this.txOutCuestion;
    }

    public void setNombre(String string) {
        this.nombre = string;
    }

    public void setBaseChanged(boolean bl) {
        this.baseChanged = bl;
    }

    public void setCuestionChanged(boolean bl) {
        this.cuestionChanged = bl;
    }

    public void setCuestion(Cuestion cuestion) {
        this.objCuestion = cuestion;
    }

    public void setBase(Programa programa) {
        this.objBase = programa;
    }

    public void setFileProyect(String string) {
        this.fileProyect = string;
    }

    public void setPathProyect(String string) {
        this.pathProyect = string;
    }

    public void setFileBase(String string) {
        this.fileBase = string;
    }

    public void setFileCuestion(String string) {
        this.fileCuestion = string;
    }

    public void setArbol(SLDArbol sLDArbol) {
        this.arbol = sLDArbol;
    }

    public void setProyectParams(JSLDProyectParams jSLDProyectParams) {
        this.proyectParams = jSLDProyectParams;
    }

    public void setTreePanel(JSLDTreePanel jSLDTreePanel) {
        this.treePanel = jSLDTreePanel;
    }

    public void setScrollPanel(JScrollPane jScrollPane) {
        this.scrollPanel = jScrollPane;
    }

    public void setTxBase(JTextArea jTextArea) {
        this.txBase = jTextArea;
    }

    public void setTxCuestion(JTextArea jTextArea) {
        this.txCuestion = jTextArea;
    }

    public void setAlgoritmo(SLDAlgoritmo sLDAlgoritmo) {
        this.alg = sLDAlgoritmo;
    }

    public void setPainter(JSLDPainterTree jSLDPainterTree) {
        this.painter = jSLDPainterTree;
    }

    public void setSubProyectos(Vector vector) {
        this.subProyectos = vector;
    }

    public void setTxOut(JTextArea jTextArea) {
        this.txOut = jTextArea;
    }

    public void setTxOutBase(JTextArea jTextArea) {
        this.txOutBase = jTextArea;
    }

    public void setTxOutCuestion(JTextArea jTextArea) {
        this.txOutCuestion = jTextArea;
    }

    public String getLine(JTextArea jTextArea, int n) {
        try {
            int n2 = jTextArea.getLineStartOffset(n);
            int n3 = jTextArea.getLineEndOffset(n);
            String string = jTextArea.getText().substring(n2, n3);
            return string;
        }
        catch (Exception exception) {
            try {
                int n4 = jTextArea.getLineStartOffset(n);
                int n5 = jTextArea.getText().length() - 1;
                String string = jTextArea.getText().substring(n4, n5);
                return string;
            }
            catch (Exception exception2) {
                return "";
            }
        }
    }

    public boolean compileBase() {
        this.getTxOut().append("\n\n");
        if (this.getBaseChanged() || this.getBase() == null) {
            try {
                this.getTxOutBase().setText("");
                this.getTxOut().append(" Compilando base de conocimiento... \n");
                if (this.getTxBase().getText().compareTo("") != 0) {
                    this.setBase(new Programa());
                    this.getBase().compilarString(this.getTxBase().getText());
                    this.getTxOutBase().setText("");
                    this.getTxOutBase().append(this.getBase().toString());
                    this.setBaseChanged(false);
                    this.getTxOut().append(" Base de conocimiento compilada. \n");
                    return true;
                }
                return false;
            }
            catch (CUPError cUPError) {
                this.getTxOutBase().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion de la base. \n" + cUPError.toString());
                this.getTxOut().append(" ->   " + this.getLine(this.getTxBase(), cUPError.linea));
                return false;
            }
            catch (LexError lexError) {
                this.getTxOutBase().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion de la base. \n" + lexError.toString());
                this.getTxOut().append(" ->  " + this.getLine(this.getTxBase(), lexError.linea));
                return false;
            }
            catch (Exception exception) {
                this.getTxOutBase().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion de la base. \n" + exception.toString());
                return false;
            }
        }
        this.getTxOut().append(" Codigo de la base de conocimiento compilada previamente. \n");
        return true;
    }

    public boolean compileCuestion() {
        this.getTxOut().append("\n\n");
        if (this.getCuestionChanged() || this.getCuestion() == null) {
            try {
                this.getTxOutCuestion().setText("");
                this.getTxOut().append(" Compilando cuestion ... \n");
                if (this.getTxCuestion().getText().compareTo("") != 0) {
                    this.setCuestion(new Cuestion());
                    this.getCuestion().compilarString(this.getTxCuestion().getText());
                    this.getTxOutCuestion().setText("");
                    this.getTxOutCuestion().append(this.getCuestion().toString());
                    this.setCuestionChanged(false);
                    this.getTxOut().append(" Cuestion compilada. \n");
                    return true;
                }
                return false;
            }
            catch (CUPError cUPError) {
                this.getTxOutCuestion().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion de la base. \n" + cUPError.toString());
                this.getTxOut().append(" ->   " + this.getLine(this.getTxCuestion(), cUPError.linea));
                return false;
            }
            catch (LexError lexError) {
                this.getTxOutCuestion().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion de la base. \n" + lexError.toString());
                this.getTxOut().append(" ->   " + this.getLine(this.getTxCuestion(), lexError.linea));
                return false;
            }
            catch (Exception exception) {
                this.getTxOutCuestion().append(" Error en interpretacion de la base. \n");
                this.getTxOut().append(" Error en interpretacion del objetivo. \n" + exception.toString());
                this.getTxOutCuestion().append(" Error en interpretacion del objetivo. \n");
                return false;
            }
        }
        this.getTxOut().append(" Codigo de la cuestion compilada previamente. \n");
        return true;
    }

    public SLDReglaDeSeleccion getRds() {
        if (this.getProyectParams().getRds() == JSLDProyectParams.RDS_IZQDER) {
            return new SLDReglaDeSeleccionIzqDer();
        }
        if (this.getProyectParams().getRds() == JSLDProyectParams.RDS_DERIZQ) {
            return new SLDReglaDeSeleccionDerIzq();
        }
        if (this.getProyectParams().getRds() == JSLDProyectParams.RDS_ALEATORIA) {
            return new SLDReglaDeSeleccionAleatoria();
        }
        return new SLDReglaDeSeleccionIzqDer();
    }

    public SLDReglaDeBusqueda getRdb() {
        if (this.getProyectParams().getRdb() == JSLDProyectParams.RDB_UPDOWN) {
            return new SLDReglaDeBusquedaUpDown(this.getBase());
        }
        if (this.getProyectParams().getRdb() == JSLDProyectParams.RDB_DOWNUP) {
            return new SLDReglaDeBusquedaDownUp(this.getBase());
        }
        if (this.getProyectParams().getRdb() == JSLDProyectParams.RDB_ALEATORIA) {
            return new SLDReglaDeBusquedaAleatoria(this.getBase());
        }
        return new SLDReglaDeBusquedaUpDown(this.getBase());
    }

    public boolean compileArbol(JTextArea jTextArea) {
        boolean bl = true;
        this.getTxOut().setText("");
        if (this.compileBase() && this.compileCuestion()) {
            try {
                this.getTxOut().append("\n\n");
                this.getTxOut().append(" Generamos el arbol SLD\n\n");
                this.getTxOut().append(" (Out algoritmo)-------------------------------------\n");
                this.alg = new SLDAlgoritmo(this.getBase(), this.getCuestion(), this.getRdb(), this.getRds(), this.getProyectParams(), this.txOut);
                this.alg.runAlgoritmo();
                this.getTxOut().append("\n ----------------------------------------------------\n");
                this.setArbol(this.alg.getArbol());
                this.getProyectParams().setUltimoNodoAPintar(0);
                this.calcularNext();
                this.painter = new JSLDPainterTree(this.mouseListener);
                this.getTreePanel().removeAll();
                this.paintTree();
                this.getTxOut().append(" Arbol SLD generado \n");
                this.getTxOut().append("\n\n");
                this.getTxOut().append("EXITOS DEL ARBOL.\n");
                this.getTxOut().append("=================\n\n");
                this.getTxOut().append(this.alg.toStringExitos());
            }
            catch (Exception exception) {
                this.getTxOut().append(exception.toString() + "\n");
                this.getTxOut().append("\n\nERROR en ejecucion del arbol " + this.getNombre() + ".\n");
                bl = false;
                this.setArbol(null);
                this.paintTree();
            }
        } else {
            this.getTxOut().append("\n\nERROR en ejecucion del arbol " + this.getNombre() + ".\n");
            bl = false;
            this.setArbol(null);
            this.paintTree();
        }
        return bl;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.getTreePanel().setPageFormat(pageFormat);
        int n = 0;
        while (n < this.getNumOfSubProyect()) {
            this.getSubProyect(n).setPageFormat(pageFormat);
            ++n;
        }
    }

    public void printerTree(PrinterJob printerJob, PageFormat pageFormat) {
        printerJob.setPrintable(this.getTreePanel(), pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                this.showError("Error al imprimir::" + exception.toString());
            }
        }
    }

    public boolean canPaint() {
        return this.painter != null && this.getArbol() != null;
    }

    public void setTreePanelCompleto() {
        if (this.getAlgoritmo().isCompleto() && this.getProyectParams().getUltimoNodoAPintar() == (int)this.getAlgoritmo().getNumeroDeNodos()) {
            this.getTreePanel().setCompleto(true);
        } else {
            this.getTreePanel().setCompleto(false);
        }
    }

    public void paintTree() {
        if (this.canPaint()) {
            this.setTreePanelCompleto();
            this.painter.paintTree(this.getTreePanel(), this.getArbol(), this.getProyectParams());
        } else {
            this.setTreePanelCompleto();
            this.painter.paintTree(this.getTreePanel(), this.getArbol(), this.getProyectParams());
        }
    }

    public void repaintTree() {
        if (this.canPaint()) {
            this.setTreePanelCompleto();
            this.painter.repaintTree(this.getTreePanel(), this.getArbol(), this.getProyectParams());
        }
    }

    public void setModoRepresentacion(int n) {
        this.getProyectParams().setModoRepresentacion(n);
        int n2 = 0;
        while (n2 < this.subProyectos.size()) {
            this.getSubProyect(n2).setModoRepresentacion(n);
            ++n2;
        }
    }

    public void calcularNext() {
        if (this.getProyectParams().getModoRepresentacion() == JSLDProyectParams.MAKE_PASOAPASO) {
            this.calcularNextNodo();
        } else if (this.getProyectParams().getModoRepresentacion() == JSLDProyectParams.MAKE_EXITOAEXITO) {
            this.calcularNextExito();
        } else if (this.getProyectParams().getModoRepresentacion() == JSLDProyectParams.MAKE_COMPLETO) {
            this.getProyectParams().setUltimoNodoAPintar((int)this.getAlgoritmo().getNumeroDeNodos());
        }
    }

    public void calcularNextNodo() {
        if (this.getAlgoritmo() != null && this.getProyectParams().getModoRepresentacion() == JSLDProyectParams.MAKE_PASOAPASO) {
            int n = this.getProyectParams().getUltimoNodoAPintar();
            if (n == -1) {
                this.getProyectParams().setUltimoNodoAPintar(1);
            } else if ((long)n < this.getAlgoritmo().getNumeroDeNodos()) {
                this.getProyectParams().setUltimoNodoAPintar(n + 1);
            } else if ((long)n == this.getAlgoritmo().getNumeroDeNodos()) {
                this.getProyectParams().setUltimoNodoAPintar(1);
            }
        }
    }

    public void calcularNextExito() {
        if (this.getAlgoritmo() != null && this.getProyectParams().getModoRepresentacion() == JSLDProyectParams.MAKE_EXITOAEXITO) {
            if ((long)this.getProyectParams().getUltimoNodoAPintar() == this.getAlgoritmo().getNumeroDeNodos()) {
                this.getProyectParams().setUltimoNodoAPintar(1);
            }
            Vector vector = this.getAlgoritmo().getExitos();
            boolean bl = false;
            int n = 0;
            while (!bl && n < vector.size()) {
                SLDArbol sLDArbol = (SLDArbol)vector.elementAt(n);
                if (sLDArbol.getIndNodo() > (long)this.getProyectParams().getUltimoNodoAPintar()) {
                    this.getProyectParams().setUltimoNodoAPintar((int)sLDArbol.getIndNodo());
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                this.getProyectParams().setUltimoNodoAPintar((int)this.getAlgoritmo().getNumeroDeNodos());
            }
        }
    }

    public void incTreePanelHeight(int n) {
        int n2 = this.getTreePanel().getWidth();
        int n3 = this.getTreePanel().getHeight();
        this.getTreePanel().setPreferredSize(new Dimension(n2, n3 += n));
        this.getTreePanel().validate();
        this.getScrollPanel().validate();
        this.getTreePanel().repaint();
        this.getScrollPanel().repaint();
    }

    public void decTreePanelHeight(int n) {
        int n2 = this.getTreePanel().getWidth();
        int n3 = this.getTreePanel().getHeight();
        if (n3 > n) {
            n3 -= n;
        }
        this.getTreePanel().setPreferredSize(new Dimension(n2, n3));
        this.getTreePanel().validate();
        this.getScrollPanel().validate();
        this.getTreePanel().repaint();
        this.getScrollPanel().repaint();
    }

    public void incTreePanelWidth(int n) {
        int n2 = this.getTreePanel().getWidth();
        int n3 = this.getTreePanel().getHeight();
        this.getTreePanel().setPreferredSize(new Dimension(n2 += n, n3));
        this.getTreePanel().validate();
        this.getScrollPanel().validate();
        this.getTreePanel().repaint();
        this.getScrollPanel().repaint();
    }

    public void decTreePanelWidth(int n) {
        int n2 = this.getTreePanel().getWidth();
        int n3 = this.getTreePanel().getHeight();
        if (n2 > n) {
            n2 -= n;
        }
        this.getTreePanel().setPreferredSize(new Dimension(n2, n3));
        this.getTreePanel().validate();
        this.getScrollPanel().validate();
        this.getTreePanel().repaint();
        this.getScrollPanel().repaint();
    }

    public void moveTreeIzq() {
        if (this.canPaint() && this.getProyectParams().getX() >= 10) {
            this.getProyectParams().setX(this.getProyectParams().getX() - 10);
            this.repaintTree();
        }
    }

    public void moveTreeDer() {
        if (this.canPaint()) {
            this.getProyectParams().setX(this.getProyectParams().getX() + 10);
            this.repaintTree();
        }
    }

    public void moveTreeUp() {
        if (this.canPaint() && this.getProyectParams().getY() >= 10) {
            this.getProyectParams().setY(this.getProyectParams().getY() - 10);
            this.repaintTree();
        }
    }

    public void moveTreeDown() {
        if (this.canPaint()) {
            this.getProyectParams().setY(this.getProyectParams().getY() + 10);
            this.repaintTree();
        }
    }

    public void incFactorX() {
        if (this.canPaint()) {
            this.getProyectParams().setFactorX(this.getProyectParams().getFactorX() + 10);
            this.repaintTree();
        }
    }

    public void decFactorX() {
        if (this.canPaint() && this.getProyectParams().getFactorX() > 10) {
            this.getProyectParams().setFactorX(this.getProyectParams().getFactorX() - 10);
            this.repaintTree();
        }
    }

    public void incFactorY() {
        if (this.canPaint()) {
            this.getProyectParams().setFactorY(this.getProyectParams().getFactorY() + 10);
            this.repaintTree();
        }
    }

    public void decFactorY() {
        if (this.canPaint() && this.getProyectParams().getFactorY() > 10) {
            this.getProyectParams().setFactorY(this.getProyectParams().getFactorY() - 10);
            this.repaintTree();
        }
    }

    public void decNivelMaximo() {
        if (this.getProyectParams().getNivelMAX() > 1) {
            this.getProyectParams().setNivelMAX(this.getProyectParams().getNivelMAX() - 1);
            this.compileArbol(null);
        }
    }

    public void incNivelMaximo() {
        this.getProyectParams().setNivelMAX(this.getProyectParams().getNivelMAX() + 1);
        this.compileArbol(null);
    }

    public void decFuente() {
        if (this.canPaint() && this.getProyectParams().getFuente() >= 1) {
            this.getProyectParams().setFuente(this.getProyectParams().getFuente() - 1);
            this.repaintTree();
        }
    }

    public void incFuente() {
        if (this.canPaint() && this.getProyectParams().getFuente() <= 20) {
            this.getProyectParams().setFuente(this.getProyectParams().getFuente() + 1);
            this.repaintTree();
        }
    }

    public void loadProyect(String string, String string2) {
        this.proyectClear();
        this.getTxBase().setText("");
        this.getTxCuestion().setText("");
        this.setNombre(string2);
        this.setPathProyect(string);
        this.setPathProyect(string + string2 + ".PRJ");
        this.setFileBase(string + string2 + ".BSE");
        this.setFileCuestion(string + string2 + ".OBJ");
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(new File(this.getPathProyect())));
            this.getProyectParams().setNivelMAX(dataInputStream.readInt());
            this.getProyectParams().setFactorX(dataInputStream.readInt());
            this.getProyectParams().setFactorY(dataInputStream.readInt());
            this.getProyectParams().setX(dataInputStream.readInt());
            this.getProyectParams().setY(dataInputStream.readInt());
            this.getProyectParams().setFuente(dataInputStream.readInt());
            this.getProyectParams().setDetectarCiclos(dataInputStream.readBoolean());
            this.getProyectParams().setRds(dataInputStream.readInt());
            this.getProyectParams().setRdb(dataInputStream.readInt());
            dataInputStream.close();
            String string3 = "";
            String string4 = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFileBase()));
            string4 = bufferedReader.readLine();
            while (string4 != null) {
                string3 = string3 + string4 + "\n";
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.getTxBase().append(string3);
            string3 = "";
            string4 = "";
            bufferedReader = new BufferedReader(new FileReader(this.getFileCuestion()));
            string4 = bufferedReader.readLine();
            while (string4 != null) {
                string3 = string3 + string4 + "\n";
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.getTxCuestion().append(string3);
        }
        catch (Exception exception) {
            this.showError("Error al leer el proyecto " + this.getFileProyect());
        }
    }

    public void saveProyect() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(new File(this.getPathProyect())));
            dataOutputStream.writeInt(this.getProyectParams().getNivelMAX());
            dataOutputStream.writeInt(this.getProyectParams().getFactorX());
            dataOutputStream.writeInt(this.getProyectParams().getFactorY());
            dataOutputStream.writeInt(this.getProyectParams().getX());
            dataOutputStream.writeInt(this.getProyectParams().getY());
            dataOutputStream.writeInt(this.getProyectParams().getFuente());
            dataOutputStream.writeBoolean(this.getProyectParams().getDetectarCiclos());
            dataOutputStream.writeInt(this.getProyectParams().getRds());
            dataOutputStream.writeInt(this.getProyectParams().getRdb());
            dataOutputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.getFileBase()));
            fileOutputStream.write(this.getTxBase().getText().getBytes());
            fileOutputStream.close();
            fileOutputStream = new FileOutputStream(new File(this.getFileCuestion()));
            fileOutputStream.write(this.getTxCuestion().getText().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.showError("Error al guardar el proyecto " + this.getFileProyect());
        }
    }

    public void saveProyectAs(String string, String string2) {
        this.setNombre(string2);
        this.setPathProyect(string);
        this.setPathProyect(string + string2 + ".PRJ");
        this.setFileBase(string + string2 + ".BSE");
        this.setFileCuestion(string + string2 + ".OBJ");
        this.saveProyect();
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error al guardar", 0);
    }

    public int addSubProyect(SLDArbol sLDArbol, JTextArea jTextArea, JSLDProyectParams jSLDProyectParams, PageFormat pageFormat) {
        int n = this.getSubProyectos().size();
        JSLDSubProyect jSLDSubProyect = new JSLDSubProyect(this, "SubArbol " + n, sLDArbol, jTextArea, this.mouseListener, this.printer, pageFormat);
        jSLDSubProyect.getTreePanel().setPageFormat(pageFormat);
        jSLDSubProyect.getProyectParams().setModoRepresentacion(jSLDProyectParams.getModoRepresentacion());
        jSLDSubProyect.getProyectParams().setFactorX(jSLDProyectParams.getFactorX());
        jSLDSubProyect.getProyectParams().setFactorY(jSLDProyectParams.getFactorY());
        jSLDSubProyect.getProyectParams().setFuente(jSLDProyectParams.getFuente());
        jSLDSubProyect.getProyectParams().setNivelMAX(jSLDProyectParams.getNivelMAX() + 10);
        this.getSubProyectos().add(jSLDSubProyect);
        return n;
    }

    public void deleteSubProyect(int n) {
        this.getSubProyectos().remove(n);
    }

    public int getNumOfSubProyect() {
        return this.getSubProyectos().size();
    }

    public JSLDSubProyect getSubProyect(int n) {
        return (JSLDSubProyect)this.getSubProyectos().elementAt(n);
    }

    public boolean compileSubProyect(int n, JTextArea jTextArea) {
        return this.getSubProyect(n).compileArbol(jTextArea);
    }
}

