/*
 * Decompiled with CFR 0.152.
 */
package JSldComponents;

import MySwing.PanelSwing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSLDTextBox
extends PanelSwing
implements CaretListener,
Printable {
    static int NOINFO = 0;
    static int INFO = 1;
    static int INFOUP = 2;
    JTextArea txt;
    JLabel titulo;
    JLabel info;
    String txtTitulo;
    JPopupMenu submenu;
    JMenuItem mnuPaste;
    JMenuItem mnuCopy;
    JMenuItem mnuCut;
    JMenuItem mnuSelectAll;
    JMenuItem mnuPrint;
    static Clipboard portapapeles = null;
    PrinterJob printer;

    public JSLDTextBox(String string, int n, PrinterJob printerJob) {
        this.txtTitulo = string;
        this.printer = printerJob;
        this.makeInterface(string, n);
    }

    public JSLDTextBox(String string, PrinterJob printerJob) {
        this.txtTitulo = string;
        this.printer = printerJob;
        this.makeInterface(string, NOINFO);
    }

    public void setupClipboard() {
        try {
            if (portapapeles != null) {
                portapapeles = this.getToolkit().getSystemClipboard();
            }
        }
        catch (Exception exception) {
            System.out.println("No funciona el clipboard");
            portapapeles = null;
        }
    }

    public void updateInfo() {
        try {
            int n = this.txt.getLineOfOffset(this.txt.getCaretPosition());
            int n2 = this.txt.getCaretPosition() - this.txt.getLineStartOffset(n);
            this.info.setText("<HTML><TABLE border=0 cellspacing=0 cellpadding=1 height=10 width=100><TR height=10><TD ><Font size=2 color=blue>Ln " + n + "</font></TD><TD><font size=2 color=blue>Col " + n2 + "</font></TD></TR></TABLE>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showSubmenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.submenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void makeInterface(String string, int n) {
        if (n == INFO) {
            this.setLayout(new BorderLayout());
            this.txt = new JTextArea(3, 1);
            this.txt.addMouseListener(this);
            this.txt.addCaretListener(this);
            this.titulo = new JLabel(string);
            this.info = new JLabel();
            this.updateInfo();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.info, "East");
            this.add((Component)this.titulo, "North");
            this.add((Component)new JScrollPane(this.txt), "Center");
            this.add((Component)jPanel, "South");
        } else if (n == INFOUP) {
            this.setLayout(new BorderLayout());
            this.txt = new JTextArea(3, 1);
            this.txt.addMouseListener(this);
            this.txt.addCaretListener(this);
            this.info = new JLabel();
            this.titulo = new JLabel(string);
            this.updateInfo();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.info, "East");
            jPanel.add((Component)this.titulo, "West");
            this.add((Component)jPanel, "North");
            this.add((Component)new JScrollPane(this.txt), "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.txt = new JTextArea(3, 1);
            this.titulo = new JLabel(string);
            this.info = new JLabel();
            this.updateInfo();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.info, "East");
            this.add((Component)this.titulo, "North");
            this.add((Component)new JScrollPane(this.txt), "Center");
        }
        this.submenu = new JPopupMenu();
        this.mnuCut = new JMenuItem("Cortar");
        this.mnuCut.addActionListener(this);
        this.mnuCopy = new JMenuItem("Copiar");
        this.mnuCopy.addActionListener(this);
        this.mnuPaste = new JMenuItem("Pegar");
        this.mnuPaste.addActionListener(this);
        this.submenu.addSeparator();
        this.mnuSelectAll = new JMenuItem("Seleccionar todo");
        this.mnuSelectAll.addActionListener(this);
        this.submenu.add(this.mnuSelectAll);
        this.submenu.addSeparator();
        this.mnuPrint = new JMenuItem("Imprimir");
        this.mnuPrint.addActionListener(this);
        this.submenu.add(this.mnuPrint);
        this.submenu.addMouseListener(this);
    }

    public JTextArea getTxt() {
        return this.txt;
    }

    public String getTitulo() {
        return this.titulo.getText();
    }

    public void setTitulo(String string) {
        this.titulo.setText(string);
        this.txtTitulo = string;
    }

    public void appendTitulo(String string) {
        this.titulo.setText(this.txtTitulo + string);
    }

    public void copyToClipBoard() {
        if (portapapeles != null) {
            String string = this.txt.getSelectedText();
            StringSelection stringSelection = new StringSelection(string);
            portapapeles.setContents(stringSelection, stringSelection);
        }
    }

    public void cutToClipBoard() {
        if (portapapeles != null) {
            String string = this.txt.getSelectedText();
            StringSelection stringSelection = new StringSelection(string);
            portapapeles.setContents(stringSelection, stringSelection);
            this.txt.replaceRange("", this.txt.getSelectionStart(), this.txt.getSelectionEnd());
        }
    }

    public void pasteFromClipBoard() {
        if (portapapeles != null) {
            Transferable transferable = portapapeles.getContents(this);
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.txt.replaceRange(string, this.txt.getSelectionStart(), this.txt.getSelectionEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printText() {
        this.printer.setPrintable(this);
        if (this.printer.printDialog()) {
            try {
                this.printer.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void selectAll() {
        this.txt.setSelectionStart(0);
        this.txt.setSelectionEnd(this.txt.getText().length());
    }

    public String getLine(int n) {
        try {
            int n2 = this.txt.getLineStartOffset(n);
            int n3 = this.txt.getLineEndOffset(n);
            String string = this.txt.getText().substring(n2, n3);
            return string;
        }
        catch (Exception exception) {
            try {
                int n4 = this.txt.getLineStartOffset(n);
                int n5 = this.txt.getText().length() - 1;
                String string = this.txt.getText().substring(n4, n5);
                return string;
            }
            catch (Exception exception2) {
                return "";
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(Color.white);
        graphics2D.setFont(new Font("Arial", 0, 9));
        graphics2D.setColor(Color.black);
        int n2 = graphics2D.getFontMetrics().getHeight();
        int n3 = 0;
        int n4 = (int)((double)(this.txt.getLineCount() * n2) / pageFormat.getImageableHeight());
        if ((double)(this.txt.getLineCount() * n2) % pageFormat.getImageableHeight() > 0.0) {
            ++n4;
        }
        if (n >= n4) {
            return 1;
        }
        double d = (double)n * pageFormat.getImageableHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY() + (double)n2 - d);
        int n5 = 0;
        while (n5 < this.txt.getLineCount()) {
            String string = this.getLine(n5);
            if (n5 != this.txt.getLineCount() && ((string = string.substring(0, string.length() - 1)).compareTo("") == 0 || string == null)) {
                string = " ";
            }
            graphics2D.drawString(string, 0, n3);
            n3 += n2;
            ++n5;
        }
        return 0;
    }

    public void drawText(Graphics2D graphics2D) {
        graphics2D.drawString("Hola", 1, 1);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateInfo();
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.showSubmenu(mouseEvent);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.showSubmenu(mouseEvent);
    }

    public void onButtonClick(ActionEvent actionEvent) {
        try {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.equals(this.mnuCut)) {
                this.cutToClipBoard();
            }
            if (jMenuItem.equals(this.mnuCopy)) {
                this.copyToClipBoard();
            }
            if (jMenuItem.equals(this.mnuPaste)) {
                this.pasteFromClipBoard();
            }
            if (jMenuItem.equals(this.mnuSelectAll)) {
                this.selectAll();
            }
            if (jMenuItem.equals(this.mnuPrint)) {
                this.printText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("lostOwnership " + clipboard);
    }
}

