/*
 * Decompiled with CFR 0.152.
 */
package JSldComponents;

import JSldComponents.JSLDProyectParams;
import MySwing.PanelSwing;
import SldComponents.SLDArbol;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JSLDTreePanel
extends PanelSwing
implements Printable {
    private SLDArbol tree;
    int desfaseV = 0;
    JSLDProyectParams params;
    private boolean completo;
    PrinterJob printer;
    PageFormat pf;
    JPopupMenu submenu;
    JMenuItem mnuShowLimits;
    JMenuItem mnuPrint;
    boolean canShowLimits = true;

    public JSLDTreePanel(SLDArbol sLDArbol, JSLDProyectParams jSLDProyectParams, PrinterJob printerJob) {
        this.tree = sLDArbol;
        this.params = jSLDProyectParams;
        this.completo = true;
        this.printer = printerJob;
        this.pf = this.printer.defaultPage();
        this.makeInterface();
    }

    public void setDesfaseV(int n) {
        this.desfaseV = n;
    }

    public void setArbol(SLDArbol sLDArbol) {
        this.tree = sLDArbol;
    }

    public void setCompleto(boolean bl) {
        this.completo = bl;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pf = pageFormat;
        this.repaint();
    }

    private void makeInterface() {
        this.submenu = new JPopupMenu();
        this.mnuShowLimits = new JMenuItem("Mostrar/ocultar limites de imp.");
        this.mnuShowLimits.addActionListener(this);
        this.submenu.add(this.mnuShowLimits);
        this.mnuPrint = new JMenuItem("Imprimir");
        this.mnuPrint.addActionListener(this);
        this.submenu.add(this.mnuPrint);
        this.submenu.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.canShowLimits) {
            this.paintLimites(graphics);
        }
        if (this.tree != null) {
            this.paintArrows(graphics, this.tree);
        }
        this.paintReglas(graphics, 20, 50);
    }

    private void paintLimites(Graphics graphics) {
        int n;
        int n2 = 10;
        int n3 = 15;
        if (this.pf.getOrientation() == 1) {
            n2 = 10;
            n3 = 15;
        } else if (this.pf.getOrientation() == 0) {
            n2 = 15;
            n3 = 10;
        } else if (this.pf.getOrientation() == 2) {
            n2 = 15;
            n3 = 10;
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.gray);
        double d = this.params.getEscalaX() / 100.0;
        double d2 = this.params.getEscalaY() / 100.0;
        int n4 = (int)((double)this.getWidth());
        int n5 = (int)this.pf.getImageableWidth();
        int n6 = (int)((double)this.getHeight());
        int n7 = (int)this.pf.getImageableHeight();
        int n8 = 0;
        int n9 = (int)((double)n5 * (1.0 / d) / (double)n2);
        while (n8 < n4) {
            graphics.setColor(new Color(210, 210, 210));
            n = 1;
            while (n < n2) {
                if (n8 + n * n9 < n4) {
                    graphics.drawLine(n8 + n * n9, 0, n8 + n * n9, n6);
                }
                ++n;
            }
            graphics.setColor(Color.gray);
            if ((n8 += (int)((double)n5 * (1.0 / d))) >= n4) continue;
            graphics.drawLine(n8, 0, n8, n6);
        }
        int n10 = 0;
        int n11 = (int)((double)n7 * (1.0 / d2) / (double)n3);
        while (n10 < n6) {
            graphics.setColor(new Color(210, 210, 210));
            n = 1;
            while (n < n3) {
                if (n10 + n * n11 < n6) {
                    graphics.drawLine(0, n10 + n * n11, n4, n10 + n * n11);
                }
                ++n;
            }
            graphics.setColor(Color.gray);
            if ((n10 += (int)((double)n7 * (1.0 / d2))) >= n6) continue;
            graphics.drawLine(0, n10, n4, n10);
        }
        graphics.setColor(color);
    }

    private void paintArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2 + this.desfaseV + 3, n3, n4);
        graphics.fillOval(n3 - 3, n4 - 3, 7, 7);
        graphics.setColor(Color.green);
        graphics.fillOval(n - 5, n2 + this.desfaseV - 5 + 3, 9, 9);
        graphics.setColor(Color.black);
        graphics.drawOval(n - 5, n2 + this.desfaseV - 5 + 3, 9, 9);
    }

    public void paintArrows(Graphics graphics, SLDArbol sLDArbol) {
        int n = sLDArbol.getAbsX();
        int n2 = sLDArbol.getAbsY();
        Vector vector = sLDArbol.getRamas();
        if (sLDArbol.getIndNodo() < (long)this.params.getUltimoNodoAPintar() && vector != null) {
            int n3 = 0;
            while (n3 < vector.size()) {
                SLDArbol sLDArbol2 = (SLDArbol)vector.elementAt(n3);
                if (sLDArbol2.getIndNodo() <= (long)this.params.getUltimoNodoAPintar()) {
                    int n4 = sLDArbol2.getAbsX();
                    int n5 = sLDArbol2.getAbsY();
                    this.paintArrow(graphics, n, n2, n4, n5);
                    this.paintArrows(graphics, sLDArbol2);
                }
                ++n3;
            }
        }
    }

    public void paintReglas(Graphics graphics, int n, int n2) {
        Polygon polygon;
        Color color = graphics.getColor();
        graphics.drawLine(n + 7 - 20, n2 + 7, n + 7 + 20, n2 + 7);
        graphics.drawLine(n + 7, n2 + 7 - 20, n + 7, n2 + 7 + 20);
        if (this.completo) {
            graphics.setColor(Color.green);
        } else {
            graphics.setColor(Color.red);
        }
        graphics.fillOval(n, n2, 14, 14);
        graphics.setColor(Color.black);
        graphics.drawOval(n, n2, 14, 14);
        n += 7;
        n2 -= 2;
        if (this.params.getRdb() == JSLDProyectParams.RDB_DOWNUP) {
            polygon = new Polygon();
            polygon.addPoint(n, n2 - 11);
            polygon.addPoint(n - 6, n2);
            polygon.addPoint(n + 6, n2);
            graphics.fillPolygon(polygon);
        }
        n2 += 18;
        if (this.params.getRdb() == JSLDProyectParams.RDB_UPDOWN) {
            polygon = new Polygon();
            polygon.addPoint(n, n2 + 11);
            polygon.addPoint(n - 6, n2);
            polygon.addPoint(n + 6, n2);
            graphics.fillPolygon(polygon);
        }
        n += 11;
        n2 -= 9;
        if (this.params.getRds() == JSLDProyectParams.RDS_IZQDER) {
            polygon = new Polygon();
            polygon.addPoint(n + 11, n2);
            polygon.addPoint(n, n2 - 6);
            polygon.addPoint(n, n2 + 6);
            graphics.fillPolygon(polygon);
        }
        n -= 20;
        if (this.params.getRds() == JSLDProyectParams.RDS_DERIZQ) {
            polygon = new Polygon();
            polygon.addPoint(n - 11, n2);
            polygon.addPoint(n, n2 + 6);
            polygon.addPoint(n, n2 - 6);
            graphics.fillPolygon(polygon);
        }
        graphics.setColor(color);
    }

    public int getDivisionEnteraDown(int n, int n2) {
        if (n > n2) {
            n -= n % n2;
            return n / n2;
        }
        if (n == n2) {
            return n / n2;
        }
        return 0;
    }

    public int getDivisionEnteraUp(int n, int n2) {
        int n3 = this.getDivisionEnteraDown(n, n2);
        if (n % n2 > 0) {
            ++n3;
        }
        return n3;
    }

    public int getHorizontalPages(double d) {
        int n = (int)((double)this.getWidth() * d);
        int n2 = (int)this.pf.getImageableWidth();
        int n3 = 0;
        n3 = this.getDivisionEnteraUp(n, n2);
        return n3;
    }

    public int getVerticalPages(double d) {
        int n = (int)((double)this.getHeight() * d);
        int n2 = (int)this.pf.getImageableHeight();
        int n3 = 0;
        n3 = this.getDivisionEnteraUp(n, n2);
        return n3;
    }

    public int getNumPages(double d, double d2) {
        return this.getHorizontalPages(d) * this.getVerticalPages(d2);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d;
        int n2 = this.desfaseV;
        this.desfaseV += 6;
        double d2 = this.params.getEscalaX() / 100.0;
        if (n >= this.getNumPages(d2, d = this.params.getEscalaY() / 100.0)) {
            this.desfaseV = n2;
            return 1;
        }
        int n3 = n % this.getHorizontalPages(d2);
        int n4 = this.getDivisionEnteraDown(n, this.getHorizontalPages(d2));
        double d3 = (double)n3 * pageFormat.getImageableWidth() * (1.0 / d2);
        double d4 = (double)n4 * pageFormat.getImageableHeight() * (1.0 / d);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(Color.white);
        graphics2D.scale(d2, d);
        graphics2D.translate(pageFormat.getImageableX() * (1.0 / d2) - d3, pageFormat.getImageableY() * (1.0 / d) - d4);
        graphics2D.setFont(new Font("Arial", 0, this.params.getFuente() + 7));
        this.printTree(graphics2D, this.tree);
        this.paintArrows(graphics2D, this.tree);
        this.paintReglas(graphics2D, 20, 50);
        this.desfaseV = n2;
        return 0;
    }

    public void printTree(Graphics2D graphics2D, SLDArbol sLDArbol) {
        if (sLDArbol.getIndNodo() <= (long)this.params.getUltimoNodoAPintar()) {
            this.printUmg(graphics2D, sLDArbol);
            this.printNodo(graphics2D, sLDArbol);
            Vector vector = sLDArbol.getRamas();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    SLDArbol sLDArbol2 = (SLDArbol)vector.elementAt(n);
                    this.printTree(graphics2D, sLDArbol2);
                    ++n;
                }
            }
        }
    }

    public void printNodo(Graphics2D graphics2D, SLDArbol sLDArbol) {
        Color color = graphics2D.getColor();
        String string = "";
        int n = graphics2D.getFontMetrics().getHeight();
        int n2 = sLDArbol.getLabelToNodo().getX();
        int n3 = sLDArbol.getLabelToNodo().getY() + n;
        int n4 = sLDArbol.getTipoNodo();
        if (n4 == SLDArbol._RAIZ || n4 == SLDArbol._NODO) {
            graphics2D.setColor(Color.blue);
            string = "" + sLDArbol.getNumNodo() + ". " + sLDArbol.resolventeToString();
            graphics2D.drawString(string, n2, n3);
        } else if (n4 == SLDArbol._HOJAFALLO_UMG || n4 == SLDArbol._HOJAFALLO || n4 == SLDArbol._HOJAFALLO_BUSQUEDA || n4 == SLDArbol._HOJAFALLO_EXPRESION) {
            graphics2D.setColor(Color.red);
            if (sLDArbol.getResolvente() != null && sLDArbol.getResolvente().size() != 0) {
                if (sLDArbol.getNumNodo() != -1L) {
                    string = "" + sLDArbol.getNumNodo() + ". ";
                }
                string = string + sLDArbol.resolventeToString();
                graphics2D.drawString(string, n2, n3);
            }
            string = "fallo. ";
            graphics2D.drawString(string, n2, n3 + n);
        } else if (n4 == SLDArbol._ERRORENALGORITMO) {
            graphics2D.setColor(Color.red);
            string = "error. ";
            graphics2D.drawString(string, n2, n3);
        } else if (n4 == SLDArbol._HOJACORTE) {
            graphics2D.setColor(Color.green);
            string = "corte. ";
            graphics2D.drawString(string, n2, n3);
        } else if (n4 == SLDArbol._HOJAPODADA) {
            graphics2D.setColor(Color.gray);
            string = "" + sLDArbol.getNumNodo() + ". " + sLDArbol.resolventeToString();
            graphics2D.drawString(string, n2, n3);
            string = "rama truncada.";
            graphics2D.drawString(string, n2, n3 + n);
        } else if (n4 == SLDArbol._RAMACICLO) {
            graphics2D.setColor(new Color(66, 0, 66));
            string = "ciclo -> nodo(" + sLDArbol.getNodoEquivalente().getNumNodo() + "). ";
            graphics2D.drawString(string, n2, n3);
        } else if (n4 == SLDArbol._RAMAREPETIDA) {
            graphics2D.setColor(new Color(66, 0, 66));
            string = "repetida -> nodo(" + sLDArbol.getNodoEquivalente().getNumNodo() + "). ";
            graphics2D.drawString(string, n2, n3);
        } else if (n4 == SLDArbol._HOJAEXITO) {
            graphics2D.setColor(Color.green);
            string = "" + sLDArbol.getNumNodo() + ".\u00e9xito. ";
            graphics2D.drawString(string, n2, n3);
            string = sLDArbol.incognitasToString();
            graphics2D.drawString(string, n2, n3 + n);
        } else if (n4 == SLDArbol._TIPONOIMPLEMENTADO) {
            graphics2D.setColor(Color.red);
            string = "" + sLDArbol.getNumNodo() + "nodo desconocido -> Error. ";
            graphics2D.drawString(string, n2, n3);
        }
        graphics2D.setColor(color);
    }

    public void printUmg(Graphics2D graphics2D, SLDArbol sLDArbol) {
        Color color = graphics2D.getColor();
        String string = "";
        if (sLDArbol.getUnificador() != null && sLDArbol.getPadre() != null || sLDArbol.getNumCorteAct() != -1 && sLDArbol.getPadre() != null) {
            int n = graphics2D.getFontMetrics().getHeight();
            int n2 = sLDArbol.getLabelToUmg().getX();
            int n3 = sLDArbol.getLabelToUmg().getY() + n;
            if (sLDArbol.getNumCorteAct() == -1) {
                graphics2D.setColor(new Color(99, 66, 0));
                string = "" + sLDArbol.unificadorToString();
                graphics2D.drawString(string, n2, n3);
            } else if (sLDArbol.getTipoNodo() == SLDArbol._HOJACORTE) {
                graphics2D.setColor(new Color(99, 66, 0));
                string = "    #!" + sLDArbol.getNumCorteAct();
                graphics2D.drawString(string, n2, n3);
            } else {
                graphics2D.setColor(new Color(99, 66, 0));
                string = "!" + sLDArbol.getNumCorteAct() + "    ";
                graphics2D.drawString(string, n2, n3);
            }
        }
        graphics2D.setColor(color);
    }

    private void showSubmenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.submenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.showSubmenu(mouseEvent);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.showSubmenu(mouseEvent);
    }

    public void onButtonClick(ActionEvent actionEvent) {
        try {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.equals(this.mnuShowLimits)) {
                this.canShowLimits = !this.canShowLimits;
                this.repaint();
            }
            if (jMenuItem.equals(this.mnuPrint)) {
                this.printer.setPrintable(this, this.pf);
                if (this.printer.printDialog()) {
                    try {
                        this.printer.print();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

