/*
 * Decompiled with CFR 0.152.
 */
package ParserProlog.PrologComponents;

import ParserProlog.CUPError;
import ParserProlog.LexError;
import ParserProlog.PrologComponents.PrologError;
import ParserProlog.PrologComponents.Salida;
import ParserProlog.PrologComponents.TEstructura;
import ParserProlog.PrologComponents.TExpresion;
import ParserProlog.PrologComponents.TLista;
import ParserProlog.PrologComponents.TVar;
import ParserProlog.PrologComponents.Termino;
import ParserProlog.Yylex;
import ParserProlog.parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java_cup.runtime.Symbol;

public class Cuestion {
    private Vector cuestion;

    public Cuestion() {
        this.cuestion = new Vector();
    }

    public Cuestion(Vector vector) {
        this.cuestion = vector;
    }

    public Cuestion(String string) throws PrologError {
        this.loadCuestion(string);
    }

    public void loadCuestion(String string) throws PrologError {
        block6: {
            try {
                parser parser2 = new parser(new Yylex(new FileInputStream(new File(string))));
                Symbol symbol = null;
                symbol = parser2.parse();
                if (((Salida)symbol.value).isCuestion()) {
                    this.cuestion = ((Salida)symbol.value).getCuestion();
                    break block6;
                }
                if (((Salida)symbol.value).isOneHecho()) {
                    ((Salida)symbol.value).toCuestion();
                    this.cuestion = ((Salida)symbol.value).getCuestion();
                    break block6;
                }
                throw new PrologError("El fichero no es una cuestion");
            }
            catch (CUPError cUPError) {
                throw cUPError;
            }
            catch (LexError lexError) {
                throw lexError;
            }
            catch (Exception exception) {
                String string2 = "Lectura/interpretacion del fichero '" + string + "':/n " + exception.toString();
                throw new PrologError(string2);
            }
        }
    }

    public void compilarString(String string) throws PrologError {
        block6: {
            try {
                parser parser2 = new parser(new Yylex(new StringReader(string)));
                Symbol symbol = null;
                symbol = parser2.parse();
                if (((Salida)symbol.value).isCuestion()) {
                    this.cuestion = ((Salida)symbol.value).getCuestion();
                    break block6;
                }
                if (((Salida)symbol.value).isOneHecho()) {
                    ((Salida)symbol.value).toCuestion();
                    this.cuestion = ((Salida)symbol.value).getCuestion();
                    break block6;
                }
                throw new PrologError("El codigo no es una cuestion");
            }
            catch (CUPError cUPError) {
                throw cUPError;
            }
            catch (LexError lexError) {
                throw lexError;
            }
            catch (Exception exception) {
                String string2 = "Lectura/interpretacion del codigo Cuestion (objetivo):/n " + exception.toString();
                throw new PrologError(string2);
            }
        }
    }

    public String toString() {
        String string = "";
        if (!this.cuestion.isEmpty()) {
            string = ((Termino)this.cuestion.elementAt(0)).toString();
            int n = 1;
            while (n < this.cuestion.size()) {
                string = string + "," + ((Termino)this.cuestion.elementAt(n)).toString();
                ++n;
            }
        }
        string = string + ".";
        return string;
    }

    public Vector getCuestion() {
        return this.cuestion;
    }

    public void setCuestion(Vector vector) {
        this.cuestion = vector;
    }

    public Vector cloneCuestion() {
        Vector<Termino> vector = new Vector<Termino>();
        int n = 0;
        while (n < this.getCuestion().size()) {
            vector.addElement((Termino)((Termino)this.getCuestion().elementAt(n)).clone());
            ++n;
        }
        return vector;
    }

    public Object clone() {
        return new Cuestion(this.cloneCuestion());
    }

    private void copiarElementos(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.containsKey(string)) continue;
            hashtable.put(string, hashtable2.get(string));
        }
    }

    public Hashtable getIncognitas(Termino termino) {
        Hashtable<String, TVar> hashtable = new Hashtable<String, TVar>();
        Hashtable hashtable2 = new Hashtable();
        if (termino != null) {
            if (termino.isVar()) {
                TVar tVar = (TVar)((TVar)termino).clone();
                tVar.setValor((Termino)((TVar)termino).clone());
                hashtable.put(((TVar)termino).getNombreConIndice(), tVar);
            } else if (termino.isLista()) {
                this.copiarElementos(hashtable, this.getIncognitas(((TLista)termino).getHead()));
                this.copiarElementos(hashtable, this.getIncognitas(((TLista)termino).getTail()));
            } else if (termino.isEstructura()) {
                int n = 0;
                while (n < ((TEstructura)termino).getArguments().size()) {
                    this.copiarElementos(hashtable, this.getIncognitas((Termino)((TEstructura)termino).getArguments().elementAt(n)));
                    ++n;
                }
            } else if (termino.isExpresion()) {
                this.copiarElementos(hashtable, this.getIncognitas(((TExpresion)termino).getOperando1()));
                this.copiarElementos(hashtable, this.getIncognitas(((TExpresion)termino).getOperando2()));
            }
        }
        return hashtable;
    }

    public Hashtable getIncognitas() {
        Vector vector = this.cuestion;
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < vector.size()) {
            this.copiarElementos(hashtable, this.getIncognitas((Termino)vector.elementAt(n)));
            ++n;
        }
        return hashtable;
    }
}

