/*
 * Decompiled with CFR 0.152.
 */
package ParserProlog.PrologComponents;

import ParserProlog.CUPError;
import ParserProlog.LexError;
import ParserProlog.PrologComponents.Clausula;
import ParserProlog.PrologComponents.Hecho;
import ParserProlog.PrologComponents.PrologError;
import ParserProlog.PrologComponents.Regla;
import ParserProlog.PrologComponents.Salida;
import ParserProlog.Yylex;
import ParserProlog.parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java_cup.runtime.Symbol;

public class Programa {
    private Hashtable baseConocimiento;

    public Programa() {
        this.baseConocimiento = new Hashtable();
    }

    public Programa(Hashtable hashtable) {
        this.baseConocimiento = hashtable;
    }

    public Programa(String string) throws PrologError {
        this.loadBaseConocimiento(string);
    }

    public void loadBaseConocimiento(String string) throws PrologError {
        try {
            parser parser2 = new parser(new Yylex(new FileInputStream(new File(string))));
            Symbol symbol = null;
            symbol = parser2.parse();
            if (!((Salida)symbol.value).isBase()) {
                throw new PrologError("El fichero no es una base de conocimiento");
            }
            this.baseConocimiento = ((Salida)symbol.value).getBase();
        }
        catch (CUPError cUPError) {
            throw cUPError;
        }
        catch (LexError lexError) {
            throw lexError;
        }
        catch (Exception exception) {
            String string2 = "Lectura/interpretacion del fichero '" + string + "':\n " + exception.toString();
            throw new PrologError(string2);
        }
    }

    public void compilarString(String string) throws PrologError {
        try {
            parser parser2 = new parser(new Yylex(new StringReader(string)));
            Symbol symbol = null;
            symbol = parser2.parse();
            if (!((Salida)symbol.value).isBase()) {
                throw new PrologError("El fichero no es una base de conocimiento");
            }
            this.baseConocimiento = ((Salida)symbol.value).getBase();
        }
        catch (CUPError cUPError) {
            throw cUPError;
        }
        catch (LexError lexError) {
            throw lexError;
        }
        catch (Exception exception) {
            String string2 = "Lectura/interpretacion del codigo fuente Base :\n " + exception.toString();
            throw new PrologError(string2);
        }
    }

    public String toString() {
        String string = "";
        String string2 = "";
        Enumeration enumeration = this.baseConocimiento.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.baseConocimiento.get(string3);
            if (vector.isEmpty()) continue;
            Clausula clausula = (Clausula)vector.elementAt(0);
            string2 = clausula.isHecho() ? ((Hecho)clausula).getEstructura().getFunctor() + " / " + ((Hecho)clausula).getEstructura().getArguments().size() : ((Regla)clausula).getEstructura().getFunctor() + " / " + ((Regla)clausula).getEstructura().getArguments().size();
            string = string + "\n\n{ " + string2 + " } ___________________ \n\n";
            int n = 0;
            while (n < vector.size()) {
                string = string + ((Clausula)vector.elementAt(n)).toString();
                ++n;
            }
        }
        return string;
    }

    public Hashtable getBase() {
        return this.baseConocimiento;
    }

    public void setBase(Hashtable hashtable) {
        this.baseConocimiento = hashtable;
    }

    public Object clone() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.getBase().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.getBase().get(string);
            Vector<Object> vector2 = new Vector<Object>();
            int n = 0;
            while (n < vector.size()) {
                vector2.addElement(((Clausula)vector.elementAt(n)).clone());
                ++n;
            }
            hashtable.put(string, vector2);
        }
        return new Programa(hashtable);
    }
}

