/*
 * Decompiled with CFR 0.152.
 */
package SldComponents;

import JSldComponents.JSLDProyectParams;
import ParserProlog.PrologComponents.Clausula;
import ParserProlog.PrologComponents.Cuestion;
import ParserProlog.PrologComponents.Hecho;
import ParserProlog.PrologComponents.Programa;
import ParserProlog.PrologComponents.Regla;
import ParserProlog.PrologComponents.TAtom;
import ParserProlog.PrologComponents.TCompound;
import ParserProlog.PrologComponents.TEstructura;
import ParserProlog.PrologComponents.TExpresion;
import ParserProlog.PrologComponents.TLista;
import ParserProlog.PrologComponents.TVar;
import ParserProlog.PrologComponents.Termino;
import SldComponents.SLDArbol;
import SldComponents.SLDAtomoSeleccionado;
import SldComponents.SLDBusquedaNodosEquivalentes;
import SldComponents.SLDCorte;
import SldComponents.SLDError;
import SldComponents.SLDEvalueExpresion;
import SldComponents.SLDEvaluePrimitiva;
import SldComponents.SLDReglaDeBusqueda;
import SldComponents.SLDReglaDeSeleccion;
import SldComponents.SLDResultado;
import SldComponents.SLDTablaCortes;
import SldComponents.SLDUnificador;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextArea;

public class SLDAlgoritmo {
    private JSLDProyectParams params;
    private Programa programa;
    private Cuestion cuestion;
    private SLDReglaDeBusqueda rdBusqueda;
    private SLDReglaDeSeleccion rdSeleccion;
    private SLDArbol raiz;
    private Vector exitos;
    private SLDTablaCortes cortes;
    private long numNodo;
    private long numeroDeNodos;
    private boolean completo;
    private JTextArea debug;

    public SLDAlgoritmo(Programa programa, Cuestion cuestion, SLDReglaDeBusqueda sLDReglaDeBusqueda, SLDReglaDeSeleccion sLDReglaDeSeleccion, JSLDProyectParams jSLDProyectParams, JTextArea jTextArea) {
        this.programa = programa;
        this.cuestion = cuestion;
        this.rdBusqueda = sLDReglaDeBusqueda;
        this.rdSeleccion = sLDReglaDeSeleccion;
        this.params = jSLDProyectParams;
        this.cortes = null;
        this.exitos = null;
        this.debug = jTextArea;
        this.numeroDeNodos = 0L;
        this.completo = true;
    }

    public Vector getExitos() {
        return this.exitos;
    }

    private long getNumNodo() {
        return this.numNodo;
    }

    public long getNumeroDeNodos() {
        return this.numeroDeNodos;
    }

    public SLDArbol getArbol() {
        return this.raiz;
    }

    public boolean isCompleto() {
        return this.completo;
    }

    private void setNumNodo(long l) {
        this.numNodo = l;
    }

    public void setNumeroDeNodos(long l) {
        this.numeroDeNodos = l;
    }

    public void setCompleto(boolean bl) {
        this.completo = bl;
    }

    private void incNumNodo() {
        ++this.numNodo;
    }

    private void incNumeroDeNodos() {
        ++this.numeroDeNodos;
    }

    public void out(String string) {
        if (this.params.getShowDebugSLDInfo() && this.debug != null) {
            this.debug.append(" ALGSLD==>  " + string + "\n");
        }
    }

    public void write(String string) {
        if (this.debug != null) {
            this.debug.append(string);
        }
    }

    private Vector clonarVectorTerminos(Vector vector) {
        Vector<Termino> vector2 = new Vector<Termino>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement((Termino)((Termino)vector.elementAt(n)).clone());
            ++n;
        }
        return vector2;
    }

    private void redenominarTermino(Termino termino, long l) {
        if (termino != null && termino != null) {
            if (termino.isVar()) {
                ((TVar)termino).setIndice(l);
            } else if (termino.isLista()) {
                this.redenominarTermino(((TLista)termino).getHead(), l);
                this.redenominarTermino(((TLista)termino).getTail(), l);
            } else if (termino.isEstructura()) {
                int n = 0;
                while (n < ((TEstructura)termino).getArguments().size()) {
                    this.redenominarTermino((Termino)((TEstructura)termino).getArguments().elementAt(n), l);
                    ++n;
                }
            } else if (termino.isExpresion()) {
                this.redenominarTermino(((TExpresion)termino).getOperando1(), l);
                this.redenominarTermino(((TExpresion)termino).getOperando2(), l);
            }
        }
    }

    private void redenominarClausula(Clausula clausula, long l) {
        if (clausula.isHecho()) {
            this.redenominarTermino(((Hecho)clausula).getEstructura(), l);
        } else if (clausula.isRegla()) {
            Regla regla = (Regla)clausula;
            this.redenominarTermino(regla.getEstructura(), l);
            int n = 0;
            while (n < regla.getCuerpo().size()) {
                this.redenominarTermino((Termino)regla.getCuerpo().elementAt(n), l);
                ++n;
            }
        }
    }

    private void insertarVectorEnOtro(Vector vector, Vector vector2, int n) {
        if (n < vector.size()) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector.insertElementAt(vector2.elementAt(n2), n + n2);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < vector2.size()) {
                vector.addElement(vector2.elementAt(n3));
                ++n3;
            }
        }
    }

    public void runSubAlgoritmo(SLDArbol sLDArbol, long l) {
        this.out("Empezamos a generar el arbol (metodo runSubAlgoritmo)");
        this.raiz = sLDArbol;
        this.cortes = new SLDTablaCortes();
        this.exitos = new Vector();
        this.setNumNodo(1L);
        this.setNumeroDeNodos(1L);
        this.out("Clonamos el vector de terminos de la cuestion.");
        this.out("Buscamos cortes y los creamos");
        Vector vector = new Vector();
        this.inicializarCortes(sLDArbol.getResolvente());
        this.makeCortes(sLDArbol.getResolvente(), vector);
        this.raiz.setCortes(vector);
        this.raiz.setIndNodo(this.getNumeroDeNodos());
        this.incNumNodo();
        this.out("Nodo creado");
        this.out("Empezamos a resolver el 1\u00banodo raiz!! METODO resuelveNodo (Peligro es recursivo)");
        this.resuelveNodo(this.raiz, l);
    }

    public void runAlgoritmo() {
        this.out("Empezamos a generar el arbol (metodo runAlgoritmo)");
        this.cortes = new SLDTablaCortes();
        this.exitos = new Vector();
        this.setNumNodo(1L);
        this.setNumeroDeNodos(1L);
        this.out("Clonamos el vector de terminos de la cuestion.");
        Vector vector = this.clonarVectorTerminos(this.cuestion.getCuestion());
        this.out("Buscamos cortes y los creamos");
        Vector vector2 = new Vector();
        this.makeCortes(vector, vector2);
        Hashtable hashtable = this.cuestion.getIncognitas();
        this.out("Creamos el primer nodo");
        this.raiz = new SLDArbol(SLDArbol._RAIZ, this.getNumNodo(), null, vector, vector2, hashtable);
        this.raiz.setIndNodo(this.getNumeroDeNodos());
        this.incNumNodo();
        this.out("Nodo creado");
        this.out("Empezamos a resolver el 1\u00banodo raiz!! METODO resuelveNodo (Peligro es recursivo)");
        this.resuelveNodo(this.raiz, 1L);
    }

    public void resuelveNodo(SLDArbol sLDArbol, long l) {
        this.out("\n\n======================================================================================\n");
        this.out("[resuelveNodo] Funcion 'resuelveNodo' NUMERO NODO  -" + sLDArbol.getNumNodo() + "- nivel -" + String.valueOf(l) + "-");
        this.out("\n\n======================================================================================");
        sLDArbol.setNivel(l);
        this.out("[resuelveNodo] Resolvemos el nodo :: \n" + sLDArbol.toString() + "\n");
        this.out("[resuelveNodo] Vamos a buscar un nodo que sea equivalente a este.\n");
        SLDBusquedaNodosEquivalentes sLDBusquedaNodosEquivalentes = new SLDBusquedaNodosEquivalentes(this);
        SLDArbol sLDArbol2 = null;
        if (this.params.getDetectarCiclos()) {
            sLDArbol2 = sLDBusquedaNodosEquivalentes.buscaNodoEquivalente(this.raiz, sLDArbol);
        }
        if (sLDArbol2 != null) {
            SLDArbol sLDArbol3;
            this.out("[resuelveNodo] Encontramos un nodo equivalente!!");
            if (sLDArbol.isPadre(sLDArbol2)) {
                this.out("[resuelveNodo] La rama es un ciclo, terminamos este hilo");
                sLDArbol3 = this.generarNodoError(SLDArbol._RAMACICLO);
            } else {
                this.out("[resuelveNodo] La rama es una repeticion, terminamos este hilo");
                sLDArbol3 = this.generarNodoError(SLDArbol._RAMAREPETIDA);
            }
            sLDArbol3.setNodoEquivalente(sLDArbol2);
            sLDArbol.addRama(sLDArbol3);
        } else if (this.params.getNivelMAX() != 0 && l == (long)this.params.getNivelMAX()) {
            this.out("[resuelveNodo] Hemos llegado al nivel maximo, fin de este hilo");
            sLDArbol.setTipoNodo(SLDArbol._HOJAPODADA);
            this.setCompleto(false);
        } else {
            this.out("[resuelveNodo] Vamos a seleccionar un atomo del nodo");
            SLDAtomoSeleccionado sLDAtomoSeleccionado = this.rdSeleccion.getFormula(sLDArbol.getResolvente());
            this.out("[resuelveNodo] El atomo ha sido seleccionado");
            if (sLDAtomoSeleccionado == null) {
                throw new SLDError("No puedo seleccionar ningun atomo del resolvente, devuelve nulo.");
            }
            Termino termino = sLDAtomoSeleccionado.getAtomo();
            this.out("El atomo seleccionado es " + termino.toString());
            if (this.isAtomExpresion(termino)) {
                this.out("[resuelveNodo] El atomo es una expresion");
                SLDArbol sLDArbol4 = this.obtenerNodoExpresion(sLDArbol, sLDAtomoSeleccionado);
                sLDArbol.addRama(sLDArbol4);
                if (sLDArbol4.getTipoNodo() == SLDArbol._NODO) {
                    this.resuelveNodo(sLDArbol4, l + 1L);
                }
            } else if (this.isAtomPrimitiva(termino)) {
                this.out("[resuelveNodo] El atomo es una primitiva");
                SLDArbol sLDArbol5 = this.obtenerNodoPrimitiva(sLDArbol, sLDAtomoSeleccionado);
                this.out("[resuelveNodo] Despues de consumir la primitiva hemos obtenido el nodo : " + sLDArbol5.toString());
                this.out("[resuelveNodo] A\u00f1adimos como nodo hijo.");
                sLDArbol.addRama(sLDArbol5);
                if (sLDArbol5.getTipoNodo() == SLDArbol._NODO) {
                    this.out("[resuelveNodo] Como es de timo _NODO resolvemos.");
                    this.resuelveNodo(sLDArbol5, l + 1L);
                }
            } else if (termino.isEstructura()) {
                this.out("[resuelveNodo] El atomo es una estructura");
                this.out("[resuelveNodo] Obtenemos el vector de clausulas que coinciden con el atomo");
                Vector vector = this.rdBusqueda.getClausulas((TEstructura)termino);
                if (vector == null || vector.size() == 0) {
                    this.out("[resuelveNodo] El el vecto de clausulas obtenido esta a null o vacio, creamos rama al respecto");
                    sLDArbol.setTipoNodo(SLDArbol._HOJAFALLO_BUSQUEDA);
                } else {
                    this.out("[resuelveNodo] Para cada clausula que hayamos encontrado(" + vector.size() + ").");
                    int n = 0;
                    while (n < vector.size()) {
                        this.out("[resuelveNodo]   -- Comprobamos existencias de cortes activos antes de generar el nuevo nodo.");
                        int n2 = this.algunCorteActivado(sLDArbol.getCortes());
                        if (n2 != -1) {
                            Clausula clausula = (Clausula)((Clausula)vector.elementAt(n)).clone();
                            Vector vector2 = this.clonarVectorTerminos(sLDArbol.getResolvente());
                            Termino termino2 = (Termino)sLDAtomoSeleccionado.getAtomo().clone();
                            this.redenominarClausula(clausula, l);
                            SLDUnificador sLDUnificador = clausula.isRegla() ? new SLDUnificador(((Regla)clausula).getEstructura(), termino2) : new SLDUnificador(((Hecho)clausula).getEstructura(), termino2);
                            if (sLDUnificador.isUnificable()) {
                                this.out("[resuelveNodo] Hay cortes activos, no se genera el nuevo nodo, sino un nodo  de tipo Corte");
                                SLDArbol sLDArbol6 = this.generarNodoError(SLDArbol._HOJACORTE);
                                sLDArbol6.setNumCorteAct(n2);
                                sLDArbol.addRama(sLDArbol6);
                            }
                        } else {
                            this.out("[resuelveNodo] No hay cortes activos que afecten por lo tanto llamamos al metodo 'obtenerNodoClausula'");
                            SLDArbol sLDArbol7 = this.obtenerNodoClausula(sLDArbol, sLDAtomoSeleccionado, (Clausula)vector.elementAt(n), l);
                            this.out("[resuelveNodo] A\u00f1adimos el nodo como rama");
                            sLDArbol.addRama(sLDArbol7);
                            this.out("[resuelveNodo] Si el nuevo nodo es de tipo _NODO lo resolvemos tambien llamando recursivamente a 'resuelveNodo'");
                            if (sLDArbol7.getTipoNodo() == SLDArbol._NODO) {
                                this.out("[resuelveNodo] LLamamos a resuelve nodo por que es de tipo _NODO");
                                this.resuelveNodo(sLDArbol7, l + 1L);
                            }
                        }
                        ++n;
                    }
                    if (sLDArbol.getRamas() != null && sLDArbol.getRamas().size() == 0) {
                        sLDArbol.setTipoNodo(SLDArbol._HOJAFALLO);
                    }
                }
            } else {
                this.out("[resuelveNodo] No reconocimos el tipo de atomo seleccionado");
                sLDArbol.addRama(this.generarNodoError(SLDArbol._TIPONOIMPLEMENTADO));
            }
        }
        this.out("[resuelveNodo] Fin resuelveNodo nivel " + String.valueOf(l));
    }

    private int algunCorteActivado(Vector vector) {
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        if (vector != null) {
            while (!bl && n2 < vector.size()) {
                bl = ((SLDCorte)vector.elementAt(n2)).activado();
                if (bl) {
                    n = ((SLDCorte)vector.elementAt(n2)).getNombre();
                    continue;
                }
                ++n2;
            }
        }
        return n;
    }

    private void inicializarCortes(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Termino termino = (Termino)vector.elementAt(n);
            if (termino.isExpresion() && ((TExpresion)termino).getOperador() == "!" && ((TExpresion)termino).getNumCorte() != -1) {
                ((TExpresion)termino).setNumCorte(-1);
            }
            ++n;
        }
    }

    private boolean makeCortes(Vector vector, Vector vector2) {
        boolean bl = false;
        this.out(" [makeCortes] Realizamos una busqueda de nuevos cortes en el vector de terminos : " + vector.toString() + " y un vector de cortes inicial " + vector2.toString());
        int n = 0;
        while (n < vector.size()) {
            Termino termino = (Termino)vector.elementAt(n);
            if (termino.isExpresion() && ((TExpresion)termino).getOperador() == "!" && ((TExpresion)termino).getNumCorte() == -1) {
                this.out(" [makeCortes] Encontramos una nueva expresion de corte : " + termino.toString());
                bl = true;
                SLDCorte sLDCorte = this.cortes.createCorte();
                this.out(" [makeCortes] A\u00f1adimos una entrada en la tabla cortes : " + this.cortes.toString());
                ((TExpresion)termino).setNumCorte(sLDCorte.getNombre());
                this.out(" [makeCortes] Modificamos el termino expresion quedando asi: " + termino.toString());
                this.cortes.addCorte(sLDCorte);
                vector2.addElement(sLDCorte);
            }
            ++n;
        }
        this.out(" [makeCortes]  Fin makeCortes. Resultados: vectCortes= " + vector2.toString() + " vecTerminos= " + vector.toString());
        return bl;
    }

    private Vector clonarVectorCortes(Vector vector) {
        Vector<SLDCorte> vector2 = new Vector<SLDCorte>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement((SLDCorte)vector.elementAt(n));
            ++n;
        }
        return vector2;
    }

    private boolean isAtomExpresion(Termino termino) {
        SLDEvalueExpresion sLDEvalueExpresion = new SLDEvalueExpresion();
        if (termino.isExpresion()) {
            return sLDEvalueExpresion.isExpresion((TExpresion)termino);
        }
        return false;
    }

    private boolean isAtomPrimitiva(Termino termino) {
        return termino.isEstructura() && SLDEvaluePrimitiva.isPrimitive((TEstructura)termino);
    }

    private boolean operandosUnificablesConUniv(Termino termino, Termino termino2) {
        boolean bl = true;
        this.out(" [operandosUnificablesConUniv] Comprobamos que no son nulos");
        if (termino == null || termino2 == null) {
            bl = false;
        }
        this.out(" [operandosUnificablesConUniv] " + String.valueOf(bl));
        this.out(" [operandosUnificablesConUniv] Comprobamos que los dos no son variables a la vez");
        if (termino.isVar() && termino2.isVar()) {
            bl = false;
        }
        this.out(" [operandosUnificablesConUniv] " + String.valueOf(bl));
        this.out(" [operandosUnificablesConUniv] Comprobamos que si la izq es variable, la derecha es lista sin cola var.");
        if (termino.isVar() && termino2.isLista() && ((TLista)termino2).containVar()) {
            bl = false;
        }
        this.out(" [operandosUnificablesConUniv] " + String.valueOf(bl));
        this.out(" [operandosUnificablesConUniv] Comprobamos que la parte derecha sea una variable o una lista");
        if (!termino2.isVar() && !termino2.isLista()) {
            bl = false;
        }
        this.out(" [operandosUnificablesConUniv] " + String.valueOf(bl));
        this.out(" [operandosUnificablesConUniv] Comprobamos que si es una lista la derecha, tenga aridad mayor que 0");
        if (termino2.isLista() && ((TLista)termino2).aridad() == 0L) {
            bl = false;
        }
        this.out(" [operandosUnificablesConUniv] " + String.valueOf(bl));
        if (bl) {
            this.out(" [operandosUnificablesConUniv] Son unificables!!! <==");
        } else {
            this.out(" [operandosUnificablesConUniv] NOOOO Son unificables!!! <==");
        }
        return bl;
    }

    private Termino toLista(Termino termino) {
        if (termino == null) {
            return null;
        }
        if (termino.isVar()) {
            return termino;
        }
        if (termino.isAtomic()) {
            return new TLista(termino);
        }
        if (termino.isLista()) {
            TLista tLista = (TLista)termino;
            TLista tLista2 = new TLista(new TAtom("."));
            tLista2.insert(tLista.getHead());
            tLista2.insert(tLista.getTail());
            return tLista2;
        }
        if (termino.isEstructura() || termino.isExpresion()) {
            TCompound tCompound = (TCompound)termino;
            TAtom tAtom = new TAtom(tCompound.getCompoundFunctor());
            if (tCompound.getCompoundNumArguments() == 0L) {
                return new TLista(tAtom);
            }
            TLista tLista = new TLista();
            int n = 0;
            while ((long)n < tCompound.getCompoundNumArguments()) {
                tLista.insert(tCompound.getCompoundArgumentAt(n));
                ++n;
            }
            return new TLista(tAtom, tLista);
        }
        return null;
    }

    private boolean isOperadorAritmetico(Termino termino) {
        String string;
        boolean bl = false;
        if (termino.isAtom() && ((string = ((TAtom)termino).getValor()).compareTo("+") == 0 || string.compareTo("-") == 0 || string.compareTo("*") == 0 || string.compareTo("/") == 0 || string.compareTo("mod") == 0 || string.compareTo("//") == 0 || string.compareTo("**") == 0 || string.compareTo("--") == 0 || string.compareTo("()") == 0)) {
            bl = true;
        }
        return bl;
    }

    private Termino toEstructura(Termino termino) {
        if (termino == null) {
            return null;
        }
        if (termino.isVar()) {
            return termino;
        }
        if (termino.isLista()) {
            TLista tLista = (TLista)termino;
            Termino termino2 = tLista.getCompoundArgumentAt(0);
            if (termino2.isAtom() && ((TAtom)termino2).getValor().compareTo(".") == 0 && tLista.getCompoundNumArguments() == 3L && tLista.getCompoundArgumentAt(2).isLista()) {
                return new TLista(tLista.getCompoundArgumentAt(1), tLista.getCompoundArgumentAt(2));
            }
            if (this.isOperadorAritmetico(termino2) && tLista.getCompoundNumArguments() == 3L && (tLista.getCompoundArgumentAt(1).isNumeric() || tLista.getCompoundArgumentAt(1).isExpresion() || tLista.getCompoundArgumentAt(1).isVar()) && (tLista.getCompoundArgumentAt(2).isNumeric() || tLista.getCompoundArgumentAt(2).isExpresion() || tLista.getCompoundArgumentAt(2).isVar())) {
                return new TExpresion(((TAtom)termino2).getValor(), tLista.getCompoundArgumentAt(1), tLista.getCompoundArgumentAt(2));
            }
            if (tLista.getCompoundNumArguments() == 1L) {
                return termino2;
            }
            if (termino2.isAtom()) {
                TEstructura tEstructura = new TEstructura(((TAtom)termino2).getValor());
                int n = 1;
                while ((long)n < tLista.getCompoundNumArguments()) {
                    tEstructura.getArguments().add(tLista.getCompoundArgumentAt(n));
                    ++n;
                }
                return tEstructura;
            }
            return null;
        }
        return null;
    }

    private SLDArbol obtenerNodoExpresion(SLDArbol sLDArbol, SLDAtomoSeleccionado sLDAtomoSeleccionado) {
        SLDArbol sLDArbol2 = null;
        TExpresion tExpresion = (TExpresion)sLDAtomoSeleccionado.getAtomo();
        this.out(" [obtenerNodoExpresion] Inicio metodo Obtener Nodo Expresion");
        SLDEvalueExpresion sLDEvalueExpresion = new SLDEvalueExpresion();
        if (sLDEvalueExpresion.isExpresionAritmetica(tExpresion)) {
            this.out(" [obtenerNodoExpresion] Expresion aritmetica, generamos rama error.");
            sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
        } else if (sLDEvalueExpresion.isExpresionLogica(tExpresion)) {
            this.out(" [obtenerNodoExpresion] Expresion logica, comprobamos su veracidad");
            if (!sLDEvalueExpresion.evalueExpRelacional(tExpresion)) {
                this.out(" [obtenerNodoExpresion] La expresion logica da False de resultado, generamos hoja error.");
                sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
            } else {
                this.out(" [obtenerNodoExpresion] La expresion logica da True de resultado");
                this.out(" [obtenerNodoExpresion] Clonamos el resolvente");
                Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                this.out(" [obtenerNodoExpresion] Eliminamos la expresion de la resolvente clonada");
                vector.remove(sLDAtomoSeleccionado.getPosicion());
                this.out(" [obtenerNodoExpresion] Generamos el nuevo nodo de tipo _NODO");
                sLDArbol2 = vector.size() == 0 ? this.generarNodoExito(null, vector, this.clonarVectorCortes(sLDArbol.getCortes()), sLDArbol.cloneIncognitas()) : this.generarNodoNormal(null, vector, this.clonarVectorCortes(sLDArbol.getCortes()), sLDArbol.cloneIncognitas());
            }
        } else if (sLDEvalueExpresion.isExpresionControl(tExpresion)) {
            this.out(" [obtenerNodoExpresion] La expresion es de tipo Control");
            this.out(" [obtenerNodoExpresion] Comprobamos que operador es, y lo resolvemos.");
            if (tExpresion.getOperador().compareTo("IS") == 0) {
                Termino termino = tExpresion.getOperando1();
                if (termino.isVar() || termino.isNumeric()) {
                    Termino termino2 = sLDEvalueExpresion.evalueExpAritmetica(tExpresion.getOperando2());
                    if (termino2 != null) {
                        SLDUnificador sLDUnificador = new SLDUnificador(termino, termino2);
                        if (sLDUnificador.isUnificable()) {
                            Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                            vector.remove(sLDAtomoSeleccionado.getPosicion());
                            vector = sLDUnificador.getUMG().sustituirVectorTerminos(vector);
                            Hashtable hashtable = sLDUnificador.getUMG().sustituirIncognitas(sLDArbol.cloneIncognitas());
                            sLDArbol2 = vector.size() == 0 ? this.generarNodoExito(sLDUnificador, vector, this.clonarVectorCortes(sLDArbol.getCortes()), hashtable) : this.generarNodoNormal(sLDUnificador, vector, this.clonarVectorCortes(sLDArbol.getCortes()), hashtable);
                        } else {
                            sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                        }
                    } else {
                        sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                    }
                } else {
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
            } else if (tExpresion.getOperador().compareTo("=") == 0) {
                this.out(" [obtenerNodoExpresion] El operador es '='");
                Termino termino = tExpresion.getOperando1();
                Termino termino3 = tExpresion.getOperando2();
                SLDUnificador sLDUnificador = new SLDUnificador(termino, termino3);
                if (sLDUnificador.isUnificable()) {
                    Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                    vector.remove(sLDAtomoSeleccionado.getPosicion());
                    vector = sLDUnificador.getUMG().sustituirVectorTerminos(vector);
                    Hashtable hashtable = sLDUnificador.getUMG().sustituirIncognitas(sLDArbol.cloneIncognitas());
                    sLDArbol2 = vector.size() == 0 ? this.generarNodoExito(sLDUnificador, vector, this.clonarVectorCortes(sLDArbol.getCortes()), hashtable) : this.generarNodoNormal(sLDUnificador, vector, this.clonarVectorCortes(sLDArbol.getCortes()), hashtable);
                } else {
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
            } else if (tExpresion.getOperador().compareTo("!") == 0) {
                SLDCorte sLDCorte = null;
                this.out(" [obtenerNodoExpresion] Estamos tratando una expresion '!' ");
                boolean bl = false;
                Vector vector = sLDArbol.getCortes();
                int n = 0;
                this.out(" [obtenerNodoExpresion] Buscamos la referencia del corte en la lista de cortes para activarlo.");
                this.out(" [obtenerNodoExpresion] Buscamos la referencia del corte en la lista de cortes para activarlo.");
                this.out(" [obtenerNodoExpresion] El vector de cortes inicialmente es : " + vector.toString());
                while (!bl && n < vector.size()) {
                    sLDCorte = (SLDCorte)vector.elementAt(n);
                    if (tExpresion.getNumCorte() == sLDCorte.getNombre()) {
                        sLDCorte.setActivado(true);
                        bl = true;
                        continue;
                    }
                    ++n;
                }
                if (!bl) {
                    this.out(" [obtenerNodoExpresion] No encontramos existencia de dicho corte! asi que generamos una hoja fallo.. ya que esto no estaba previsto.");
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                } else {
                    this.out(" [obtenerNodoExpresion] Si encontramos existencia de dicho corte! .");
                    Vector vector2 = this.clonarVectorTerminos(sLDArbol.getResolvente());
                    vector2.remove(sLDAtomoSeleccionado.getPosicion());
                    Vector vector3 = this.clonarVectorCortes(sLDArbol.getCortes());
                    vector3.remove(n);
                    if (vector2.size() == 0) {
                        this.out(" [obtenerNodoExpresion] Generamos nodo EXITO.");
                        sLDArbol2 = this.generarNodoExito(null, vector2, vector3, sLDArbol.cloneIncognitas());
                    } else {
                        this.out(" [obtenerNodoExpresion] Generamos nodo _NODO_.");
                        sLDArbol2 = this.generarNodoNormal(null, vector2, vector3, sLDArbol.cloneIncognitas());
                    }
                    sLDArbol2.setNumCorteAct(sLDCorte.getNombre());
                }
            } else if (tExpresion.getOperador().compareTo("fail") == 0) {
                sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
            } else if (tExpresion.getOperador().compareTo("\\+") == 0) {
                Vector<Termino> vector = new Vector<Termino>();
                vector.add(tExpresion.getOperando1());
                SLDAlgoritmo sLDAlgoritmo = new SLDAlgoritmo(this.programa, new Cuestion(vector), this.rdBusqueda, this.rdSeleccion, this.params, this.debug);
                sLDAlgoritmo.runAlgoritmo();
                SLDArbol sLDArbol3 = sLDAlgoritmo.getArbol();
                if (sLDAlgoritmo.getExitos().size() == 0) {
                    Vector vector4 = this.clonarVectorTerminos(sLDArbol.getResolvente());
                    vector4.remove(sLDAtomoSeleccionado.getPosicion());
                    Vector vector5 = this.clonarVectorCortes(sLDArbol.getCortes());
                    sLDArbol2 = vector4.size() == 0 ? this.generarNodoExito(null, vector4, vector5, sLDArbol.cloneIncognitas()) : this.generarNodoNormal(null, vector4, vector5, sLDArbol.cloneIncognitas());
                } else {
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
            } else if (tExpresion.getOperador().compareTo("=..") == 0) {
                this.out(" [obtenerNodoExpresion] El operador es '=..' ");
                this.out(" [obtenerNodoExpresion] Obtenemos el operando 1 y 2");
                Termino termino = tExpresion.getOperando1();
                Termino termino4 = tExpresion.getOperando2();
                if (!this.operandosUnificablesConUniv(termino, termino4)) {
                    this.out(" [obtenerNodoExpresion] No se cumplieron las condiciones y generamos nodo error, no puede unificar.");
                    if (termino4 != null) {
                        this.out(" [obtenerNodoExpresion] Resultado" + termino4.toString());
                    } else {
                        this.out(" [obtenerNodoExpresion] Termino izquierdo nulo");
                    }
                    if (termino != null) {
                        this.out(" [obtenerNodoExpresion] Resultado" + termino.toString());
                    } else {
                        this.out(" [obtenerNodoExpresion] Termino izquierdo nulo");
                    }
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                } else {
                    this.out(" [obtenerNodoExpresion] Se cumplieron las condiciones");
                    if (termino.isVar()) {
                        this.out(" [obtenerNodoExpresion] Pasamos el termino derecho a estructura, por que el izquierdo es variable");
                        termino4 = this.toEstructura(termino4);
                    } else {
                        this.out(" [obtenerNodoExpresion] Pasamos el termino izquierdo a lista por que el derecho es variable o lista");
                        termino = this.toLista(termino);
                    }
                    if (termino4 != null) {
                        this.out(" [obtenerNodoExpresion] Resultado" + termino4.toString());
                    } else {
                        this.out(" [obtenerNodoExpresion] Termino izquierdo nulo");
                    }
                    if (termino != null) {
                        this.out(" [obtenerNodoExpresion] Resultado" + termino.toString());
                    } else {
                        this.out(" [obtenerNodoExpresion] Termino izquierdo nulo");
                    }
                    this.out(" [obtenerNodoExpresion] Unificamos");
                    SLDUnificador sLDUnificador = new SLDUnificador(termino, termino4);
                    this.out(" [obtenerNodoExpresion] Unificacion:" + sLDUnificador.getUMG().toString());
                    if (sLDUnificador.isUnificable()) {
                        this.out(" [obtenerNodoExpresion] Son estructuras unificables");
                        Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                        vector.remove(sLDAtomoSeleccionado.getPosicion());
                        vector = sLDUnificador.getUMG().sustituirVectorTerminos(vector);
                        Vector vector6 = this.clonarVectorCortes(sLDArbol.getCortes());
                        Hashtable hashtable = sLDUnificador.getUMG().sustituirIncognitas(sLDArbol.cloneIncognitas());
                        sLDArbol2 = vector.size() == 0 ? this.generarNodoExito(sLDUnificador, vector, vector6, hashtable) : this.generarNodoNormal(sLDUnificador, vector, vector6, hashtable);
                        this.out(" [obtenerNodoExpresion] Creamos el nodo " + sLDArbol2.toString());
                    } else {
                        sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO_UMG, sLDUnificador);
                    }
                }
            } else {
                sLDArbol2 = this.generarNodoError(SLDArbol._TIPONOIMPLEMENTADO);
            }
        } else {
            sLDArbol2 = this.generarNodoError(SLDArbol._TIPONOIMPLEMENTADO);
        }
        return sLDArbol2;
    }

    private SLDArbol obtenerNodoPrimitiva(SLDArbol sLDArbol, SLDAtomoSeleccionado sLDAtomoSeleccionado) {
        SLDArbol sLDArbol2;
        block17: {
            sLDArbol2 = null;
            TEstructura tEstructura = (TEstructura)sLDAtomoSeleccionado.getAtomo();
            if (SLDEvaluePrimitiva.isAritmeticPrimitive(tEstructura)) {
                this.out("[obtenerNodoPrimitiva]Primitiva de tipo aritmetico, error!, no se pueden encontrar en resolvente");
                sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
            } else if (SLDEvaluePrimitiva.isControlPrimitive(tEstructura)) {
                this.out("[obtenerNodoPrimitiva]Primitiva de tipo control");
                try {
                    SLDResultado sLDResultado = SLDEvaluePrimitiva.invokePrimitive(tEstructura);
                    if (sLDResultado.isTermino()) {
                        this.out("[obtenerNodoPrimitiva]La primitiva devolvio un termino por lo que debe de ser Call(X)");
                        Termino termino = sLDResultado.getTerminoResult();
                        this.out("[obtenerNodoPrimitiva]Obtenemos el resultado " + termino.toString());
                        Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                        vector.remove(sLDAtomoSeleccionado.getPosicion());
                        this.out("[obtenerNodoPrimitiva]Sustituimos en el resolvelte el atomo seleccionado por el obtenido en call");
                        Vector<Object> vector2 = new Vector<Object>();
                        vector2.addElement(termino.clone());
                        this.insertarVectorEnOtro(vector, vector2, sLDAtomoSeleccionado.getPosicion());
                        this.out("[obtenerNodoPrimitiva]Resolvente queda asi: " + vector.toString());
                        this.out("[obtenerNodoPrimitiva]Clonamos los cortes");
                        Vector vector3 = this.clonarVectorCortes(sLDArbol.getCortes());
                        if (vector.size() == 0) {
                            this.out("[obtenerNodoPrimitiva]Creamos un nodo exito");
                            sLDArbol2 = this.generarNodoExito(null, vector, vector3, sLDArbol.cloneIncognitas());
                        } else {
                            this.out("[obtenerNodoPrimitiva]Creamos un nodo normal");
                            sLDArbol2 = this.generarNodoNormal(null, vector, vector3, sLDArbol.cloneIncognitas());
                            this.out("[obtenerNodoPrimitiva]NodoNormalGenerado");
                        }
                        break block17;
                    }
                    if (sLDResultado.isString()) {
                        this.out("[obtenerNodoPrimitiva]La primitiva devuelve un string ");
                        String string = sLDResultado.getStringResult();
                        this.write(string);
                        this.out("[obtenerNodoPrimitiva]El valor es [" + string + "]");
                        Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                        vector.remove(sLDAtomoSeleccionado.getPosicion());
                        Vector vector4 = this.clonarVectorCortes(sLDArbol.getCortes());
                        if (vector.size() == 0) {
                            this.out("[obtenerNodoPrimitiva]Creamos un nodo exito");
                            sLDArbol2 = this.generarNodoExito(null, vector, vector4, sLDArbol.cloneIncognitas());
                        } else {
                            this.out("[obtenerNodoPrimitiva]Creamos un nodo normal");
                            sLDArbol2 = this.generarNodoNormal(null, vector, vector4, sLDArbol.cloneIncognitas());
                        }
                        break block17;
                    }
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
                catch (Exception exception) {
                    this.out("[obtenerNodoPrimitiva]Error durante tratamiento de primitiva, generamos nodo error");
                    sLDArbol2 = this.generarNodoError(SLDArbol._ERRORENALGORITMO);
                }
            } else if (SLDEvaluePrimitiva.isMetaPrimitive(tEstructura)) {
                try {
                    SLDResultado sLDResultado = SLDEvaluePrimitiva.invokePrimitive(tEstructura);
                    if (sLDResultado.isBoolean() && sLDResultado.getBooleanResult()) {
                        Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
                        vector.remove(sLDAtomoSeleccionado.getPosicion());
                        Vector vector5 = this.clonarVectorCortes(sLDArbol.getCortes());
                        sLDArbol2 = vector.size() == 0 ? this.generarNodoExito(null, vector, vector5, sLDArbol.cloneIncognitas()) : this.generarNodoNormal(null, vector, vector5, sLDArbol.cloneIncognitas());
                        break block17;
                    }
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
                catch (Exception exception) {
                    sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO);
                }
            } else {
                sLDArbol2 = this.generarNodoError(SLDArbol._ERRORENALGORITMO);
            }
        }
        return sLDArbol2;
    }

    private SLDArbol obtenerNodoClausula(SLDArbol sLDArbol, SLDAtomoSeleccionado sLDAtomoSeleccionado, Clausula clausula, long l) {
        SLDArbol sLDArbol2 = null;
        this.out(" [obtenerNodoClausula] Inicio metodo OBTENER NODO CLAUSULA en nodo :\n" + sLDArbol.toString() + " y resolvente : \n" + clausula.toString());
        this.out(" [obtenerNodoClausula] Clonamos la clausula");
        Clausula clausula2 = (Clausula)clausula.clone();
        this.out(" [obtenerNodoClausula] Clonamos el resolvente");
        Vector vector = this.clonarVectorTerminos(sLDArbol.getResolvente());
        this.out(" [obtenerNodoClausula] Clonamos el atomo");
        Termino termino = (Termino)sLDAtomoSeleccionado.getAtomo().clone();
        this.out(" [obtenerNodoClausula] Redenominamos la clausula");
        this.redenominarClausula(clausula2, l);
        this.out(" [obtenerNodoClausula] Clausula redenominada --> \n" + clausula2.toString() + "\n");
        this.out(" [obtenerNodoClausula] Unificamos");
        SLDUnificador sLDUnificador = clausula2.isRegla() ? new SLDUnificador(((Regla)clausula2).getEstructura(), termino) : new SLDUnificador(((Hecho)clausula2).getEstructura(), termino);
        this.out(" [obtenerNodoClausula] Comprobamos si hay unificacion de terminos");
        if (!sLDUnificador.isUnificable()) {
            this.out(" [obtenerNodoClausula] No existe unificacion, generamos error y nodo hoja");
            this.out("[obtenerNodoClausula] Vemos unificacion fallida \n\n" + sLDUnificador.toString() + "\n");
            sLDArbol2 = this.generarNodoError(SLDArbol._HOJAFALLO_UMG, sLDUnificador);
        } else {
            this.out(" [obtenerNodoClausula] Existe unificacion");
            if (sLDUnificador.getUMG() != null) {
                this.out(" [obtenerNodoClausula] UMG = " + sLDUnificador.getUMG().toString());
            } else {
                this.out(" [obtenerNodoClausula] ERROR!! NO PUEDO MOSTRAR EL UMG EN PANTALLA");
                this.out(" Veamos el algoritmo de robinson...\n" + sLDUnificador.toString());
            }
            this.out(" [obtenerNodoClausula] Eliminamos el atomo seleccionado del resolvente clonado");
            vector.remove(sLDAtomoSeleccionado.getPosicion());
            this.out(" [obtenerNodoClausula] Resolvente :: " + vector.toString());
            this.out(" [obtenerNodoClausula] Insertamos el cuerpo de la clausula en la resolvente");
            if (clausula2.isRegla()) {
                this.insertarVectorEnOtro(vector, ((Regla)clausula2).getCuerpo(), sLDAtomoSeleccionado.getPosicion());
            }
            this.out(" [obtenerNodoClausula] Resolvente amplificada :: " + vector.toString());
            this.out(" [obtenerNodoClausula] Realizamos una sustitucion del resulvente nuevo con el UMG ");
            vector = sLDUnificador.getUMG().sustituirVectorTerminos(vector);
            this.out(" [obtenerNodoClausula] Resolvente unificada :: " + vector.toString());
            this.out(" [obtenerNodoClausula] Clonamos las incognitas");
            Hashtable hashtable = sLDArbol.getIncognitas();
            if (sLDArbol.getIncognitas() == null) {
                this.out(" [obtenerNodoClausula] las incognitas son NULAS!!! NULL");
            } else {
                hashtable = sLDArbol.cloneIncognitas();
                this.out(" [obtenerNodoClausula] Resultado:" + hashtable.toString());
                this.out(" [obtenerNodoClausula] Sustituimos las incognitas");
                hashtable = sLDUnificador.getUMG().sustituirIncognitas(hashtable);
                this.out(" [obtenerNodoClausula] Clonadas y sustituidas");
                this.out(" [obtenerNodoClausula] Resultado:" + hashtable.toString());
            }
            this.out(" [obtenerNodoClausula] Esta la resolvente vacia?");
            if (vector.size() == 0) {
                this.out(" [obtenerNodoClausula] Esta vacia tenemos una HOJA EXITO");
                sLDArbol2 = this.generarNodoExito(sLDUnificador, vector, null, hashtable);
            } else {
                this.out(" [obtenerNodoClausula] Buscamos cortes nuevos en la resolvente y los creamos");
                this.makeCortes(vector, sLDArbol.getCortes());
                this.out(" [obtenerNodoClausula] Generamos un nuevo nodo con todos estos componentes y lo devolvemos");
                sLDArbol2 = this.generarNodoNormal(sLDUnificador, vector, this.clonarVectorCortes(sLDArbol.getCortes()), hashtable);
            }
        }
        return sLDArbol2;
    }

    private SLDArbol generarNodoError(int n) {
        SLDArbol sLDArbol = new SLDArbol(n, -1L, null, null, null, null);
        if (n != SLDArbol._HOJAFALLO_UMG) {
            this.incNumeroDeNodos();
            sLDArbol.setIndNodo(this.getNumeroDeNodos());
        }
        return sLDArbol;
    }

    private SLDArbol generarNodoError(int n, SLDUnificador sLDUnificador) {
        SLDArbol sLDArbol = new SLDArbol(n, -1L, sLDUnificador, null, null, null);
        if (n != SLDArbol._HOJAFALLO_UMG) {
            this.incNumeroDeNodos();
            sLDArbol.setIndNodo(this.getNumeroDeNodos());
        }
        return sLDArbol;
    }

    private SLDArbol generarNodoNormal(SLDUnificador sLDUnificador, Vector vector, Vector vector2, Hashtable hashtable) {
        SLDArbol sLDArbol = new SLDArbol(SLDArbol._NODO, this.getNumNodo(), sLDUnificador, vector, vector2, hashtable);
        this.incNumNodo();
        this.incNumeroDeNodos();
        sLDArbol.setIndNodo(this.getNumeroDeNodos());
        return sLDArbol;
    }

    private SLDArbol generarNodoExito(SLDUnificador sLDUnificador, Vector vector, Vector vector2, Hashtable hashtable) {
        SLDArbol sLDArbol = new SLDArbol(SLDArbol._HOJAEXITO, this.getNumNodo(), sLDUnificador, vector, vector2, hashtable);
        this.incNumNodo();
        this.incNumeroDeNodos();
        sLDArbol.setIndNodo(this.getNumeroDeNodos());
        this.exitos.addElement(sLDArbol);
        return sLDArbol;
    }

    public String toStringExitos() {
        String string = "Resultados :\n\n";
        int n = 0;
        while (n < this.getExitos().size()) {
            string = string + ((SLDArbol)this.getExitos().elementAt(n)).toString() + "\n\n";
            ++n;
        }
        return string;
    }
}

