/*
 * Decompiled with CFR 0.152.
 */
package SldComponents;

import ParserProlog.PrologComponents.TDecimal;
import ParserProlog.PrologComponents.TEntero;
import ParserProlog.PrologComponents.TEstructura;
import ParserProlog.PrologComponents.TExpresion;
import ParserProlog.PrologComponents.Termino;
import SldComponents.SLDError;
import SldComponents.SLDEvaluePrimitiva;
import SldComponents.SLDResultado;

public class SLDEvalueExpresion {
    public boolean isExpresionLogicaAritmetica(TExpresion tExpresion) {
        String string = tExpresion.getOperador();
        return string.compareTo("=:=") == 0 || string.compareTo("=\\=") == 0 || string.compareTo("<") == 0 || string.compareTo("=<") == 0 || string.compareTo(">") == 0 || string.compareTo(">=") == 0;
    }

    public boolean isExpresionLogicaNoAritmetica(TExpresion tExpresion) {
        String string = tExpresion.getOperador();
        return string.compareTo("==") == 0 || string.compareTo("\\==") == 0 || string.compareTo("@<") == 0 || string.compareTo("@=<") == 0 || string.compareTo("@>") == 0 || string.compareTo("@>=") == 0;
    }

    public boolean isExpresionLogica(TExpresion tExpresion) {
        String string = tExpresion.getOperador();
        return this.isExpresionLogicaAritmetica(tExpresion) || this.isExpresionLogicaNoAritmetica(tExpresion);
    }

    public boolean isExpresionAritmetica(TExpresion tExpresion) {
        String string = tExpresion.getOperador();
        return string.compareTo("+") == 0 || string.compareTo("-") == 0 || string.compareTo("*") == 0 || string.compareTo("/") == 0 || string.compareTo("mod") == 0 || string.compareTo("//") == 0 || string.compareTo("**") == 0 || string.compareTo("--") == 0 || string.compareTo("()") == 0;
    }

    public boolean isExpresionControl(TExpresion tExpresion) {
        String string = tExpresion.getOperador();
        return string.compareTo("IS") == 0 || string.compareTo("=") == 0 || string.compareTo("!") == 0 || string.compareTo("fail") == 0 || string.compareTo("\\+") == 0 || string.compareTo("=..") == 0;
    }

    public boolean isExpresion(TExpresion tExpresion) {
        return this.isExpresionControl(tExpresion) || this.isExpresionAritmetica(tExpresion) || this.isExpresionLogica(tExpresion);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Termino evalueExpAritmetica(Termino termino) {
        void var2_26;
        Object var2_2 = null;
        Termino termino2 = null;
        Termino termino3 = null;
        if (termino == null) {
            return var2_26;
        }
        if (termino.isVar()) {
            return var2_26;
        }
        if (termino.isNumeric()) {
            Termino termino4 = termino;
            return var2_26;
        }
        if (termino.isEstructura()) {
            SLDEvaluePrimitiva sLDEvaluePrimitiva = new SLDEvaluePrimitiva();
            if (!SLDEvaluePrimitiva.isAritmeticPrimitive((TEstructura)termino)) {
                Object var2_9 = null;
                throw new SLDError(" Se ha encontrado un predicado no aritmetico " + termino.toString() + " dentro de una expresion. ");
            }
            try {
                SLDResultado sLDResultado = SLDEvaluePrimitiva.invokePrimitive((TEstructura)termino);
                if (sLDResultado.isTermino()) {
                    Termino termino5 = sLDResultado.getTerminoResult();
                    return var2_26;
                }
                Object var2_7 = null;
                throw new SLDError(" Error en expresion Aritmetica al evaluar primitiva " + termino.toString() + " ::\n\n -> " + "El valor obtenido no es un termino.");
            }
            catch (Exception exception) {
                Object var2_8 = null;
                throw new SLDError(" Error en expresion Aritmetica al evaluar primitiva " + termino.toString() + " ::\n\n -> " + exception.toString());
            }
        }
        if (termino.isExpresion() && this.isExpresionAritmetica((TExpresion)termino)) {
            TExpresion tExpresion = (TExpresion)termino;
            String string = tExpresion.getOperador();
            if (string.compareTo("()") == 0) {
                Termino termino6 = this.evalueExpAritmetica(tExpresion.getOperando1());
                return var2_26;
            }
            if (string.compareTo("--") == 0) {
                termino2 = this.evalueExpAritmetica(tExpresion.getOperando1());
                if (!this.isOperable(termino2)) {
                    return var2_26;
                }
                Termino termino7 = this.getAsTermino(-this.getAsDouble(termino2));
                return var2_26;
            }
            termino2 = this.evalueExpAritmetica(tExpresion.getOperando1());
            if (!this.isOperable(termino2, termino3 = this.evalueExpAritmetica(tExpresion.getOperando2()))) {
                return var2_26;
            }
            double d = this.getAsDouble(termino2);
            double d2 = this.getAsDouble(termino3);
            if (string.compareTo("+") == 0) {
                Termino termino8 = this.getAsTermino(d + d2);
                return var2_26;
            }
            if (string.compareTo("-") == 0) {
                Termino termino9 = this.getAsTermino(d - d2);
                return var2_26;
            }
            if (string.compareTo("*") == 0) {
                Termino termino10 = this.getAsTermino(d * d2);
                return var2_26;
            }
            if (string.compareTo("**") == 0) {
                Termino termino11 = this.getAsTermino(Math.pow(d, d2));
                return var2_26;
            }
            if (string.compareTo("/") == 0) {
                if (d2 == 0.0) return var2_26;
                Termino termino12 = this.getAsTermino(d / d2);
                return var2_26;
            }
            if (string.compareTo("mod") == 0) {
                if (d2 == 0.0) return var2_26;
                Termino termino13 = this.getAsTermino(d % d2);
                return var2_26;
            }
            if (string.compareTo("//") != 0) return var2_26;
            if (d2 == 0.0) return var2_26;
            Termino termino14 = this.getAsTermino((int)(d / d2));
            return var2_26;
        }
        Object var2_25 = null;
        return var2_26;
    }

    private boolean isOperable(Termino termino, Termino termino2) {
        boolean bl = true;
        if (termino == null || termino2 == null) {
            bl = false;
        } else {
            if (!termino.isNumeric()) {
                bl = false;
            }
            if (!termino2.isNumeric()) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isOperable(Termino termino) {
        boolean bl = true;
        if (termino == null) {
            bl = false;
        } else if (!termino.isNumeric()) {
            bl = false;
        }
        return bl;
    }

    private double getAsDouble(Termino termino) {
        double d = termino.isEntero() ? (double)((TEntero)termino).getValor() : ((TDecimal)termino).getValor();
        return d;
    }

    private Termino getAsTermino(double d) {
        if (d == (double)((long)d)) {
            return new TEntero((long)d);
        }
        return new TDecimal(d);
    }

    public boolean evalueExpRelacional(Termino termino) {
        boolean bl = false;
        if (termino == null) {
            bl = false;
        } else if (termino.isExpresion() && this.isExpresionLogica((TExpresion)termino)) {
            TExpresion tExpresion = (TExpresion)termino;
            if (this.isExpresionLogicaAritmetica(tExpresion)) {
                Termino termino2;
                Termino termino3 = this.evalueExpAritmetica(tExpresion.getOperando1());
                if (!this.isComparableAritmeticamente(termino3, termino2 = this.evalueExpAritmetica(tExpresion.getOperando2()))) {
                    bl = false;
                } else {
                    String string = tExpresion.getOperador();
                    double d = this.getAsDouble(termino3);
                    double d2 = this.getAsDouble(termino2);
                    if (string.compareTo("=:=") == 0) {
                        bl = d == d2;
                    } else if (string.compareTo("=\\=") == 0) {
                        bl = d != d2;
                    } else if (string.compareTo("<") == 0) {
                        bl = d < d2;
                    } else if (string.compareTo("=<") == 0) {
                        bl = d <= d2;
                    } else if (string.compareTo(">") == 0) {
                        bl = d > d2;
                    } else if (string.compareTo(">=") == 0) {
                        bl = d >= d2;
                    }
                }
            } else {
                String string = tExpresion.getOperador();
                Termino termino4 = tExpresion.getOperando1();
                Termino termino5 = tExpresion.getOperando2();
                bl = string.compareTo("==") == 0 ? termino4.compareTo(termino5) == 0 : (string.compareTo("\\==") == 0 ? termino4.compareTo(termino5) != 0 : (string.compareTo("@<") == 0 ? termino4.compareTo(termino5) < 0 : (string.compareTo("@=<") == 0 ? termino4.compareTo(termino5) <= 0 : (string.compareTo("@>") == 0 ? termino4.compareTo(termino5) > 0 : (string.compareTo("@>=") == 0 ? termino4.compareTo(termino5) >= 0 : false)))));
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isComparableAritmeticamente(Termino termino, Termino termino2) {
        boolean bl = true;
        if (termino == null || termino2 == null) {
            bl = false;
        } else {
            if (!termino.isNumeric()) {
                bl = false;
            }
            if (!termino2.isNumeric()) {
                bl = false;
            }
        }
        return bl;
    }
}

