/*
 * Decompiled with CFR 0.152.
 */
package SldComponents;

import ParserProlog.PrologComponents.TAtom;
import ParserProlog.PrologComponents.TCompound;
import ParserProlog.PrologComponents.TDecimal;
import ParserProlog.PrologComponents.TEntero;
import ParserProlog.PrologComponents.TEstructura;
import ParserProlog.PrologComponents.TExpresion;
import ParserProlog.PrologComponents.TLista;
import ParserProlog.PrologComponents.TVar;
import ParserProlog.PrologComponents.Termino;
import SldComponents.SLDLigadura;
import SldComponents.SLDParDiscordante;
import SldComponents.SLDSustitucion;

public class SLDUnificador {
    private SLDSustitucion UMG;
    private Termino termino1;
    private Termino termino2;
    private boolean unificable;

    public SLDUnificador(Termino termino, Termino termino2) {
        this.termino1 = termino;
        this.termino2 = termino2;
        this.unificable = this.algoritmoRobinson();
    }

    public void out(String string) {
        System.out.println(string);
    }

    private boolean listasIguales(TLista tLista, TLista tLista2) {
        if (tLista.containVar() || tLista2.containVar()) {
            return !tLista.isEmpty() && !tLista2.isEmpty();
        }
        return tLista.aridad() == tLista2.aridad();
    }

    private boolean estructurasIguales(TEstructura tEstructura, TEstructura tEstructura2) {
        boolean bl = true;
        if (tEstructura.getFunctor().compareTo(tEstructura2.getFunctor()) != 0) {
            bl = false;
        }
        if (tEstructura.getArguments().size() != tEstructura2.getArguments().size()) {
            bl = false;
        }
        return bl;
    }

    private boolean compoundsIguales(TCompound tCompound, TCompound tCompound2) {
        boolean bl = true;
        if (tCompound.getCompoundFunctor().compareTo(tCompound2.getCompoundFunctor()) != 0) {
            bl = false;
        }
        if (tCompound.getCompoundNumArguments() != tCompound2.getCompoundNumArguments()) {
            bl = false;
        }
        return bl;
    }

    private boolean expresionesIguales(TExpresion tExpresion, TExpresion tExpresion2) {
        boolean bl = false;
        if (tExpresion.getOperador().compareTo(tExpresion2.getOperador()) == 0) {
            if (tExpresion.getNumArguments() == tExpresion2.getNumArguments()) {
                if (tExpresion.getNumArguments() == 1) {
                    bl = tExpresion.getOperando1() == null && tExpresion2.getOperando1() == null ? true : tExpresion.getOperando2() == null && tExpresion2.getOperando2() == null;
                } else if (tExpresion.getNumArguments() == 2) {
                    bl = true;
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private SLDParDiscordante buscarParDiscordante(Termino termino, Termino termino2) {
        SLDParDiscordante sLDParDiscordante;
        if (termino != null && termino2 != null) {
            if (termino.getTipo() == termino2.getTipo()) {
                if (termino.isVar()) {
                    sLDParDiscordante = ((TVar)termino).getNombreConIndice().compareTo(((TVar)termino2).getNombreConIndice()) != 0 ? new SLDParDiscordante(termino, termino2) : null;
                } else if (termino.isAtom()) {
                    sLDParDiscordante = ((TAtom)termino).getValor().compareTo(((TAtom)termino2).getValor()) != 0 ? new SLDParDiscordante(termino, termino2) : null;
                } else if (termino.isEntero()) {
                    sLDParDiscordante = ((TEntero)termino).getValor() != ((TEntero)termino2).getValor() ? new SLDParDiscordante(termino, termino2) : null;
                } else if (termino.isDecimal()) {
                    sLDParDiscordante = ((TDecimal)termino).getValor() != ((TDecimal)termino2).getValor() ? new SLDParDiscordante(termino, termino2) : null;
                } else if (termino.isLista()) {
                    if (!this.listasIguales((TLista)termino, (TLista)termino2)) {
                        sLDParDiscordante = new SLDParDiscordante(termino, termino2);
                    } else if (((TLista)termino).aridad() == 0L) {
                        sLDParDiscordante = null;
                    } else {
                        sLDParDiscordante = this.buscarParDiscordante(((TLista)termino).getHead(), ((TLista)termino2).getHead());
                        if (sLDParDiscordante == null) {
                            sLDParDiscordante = this.buscarParDiscordante(((TLista)termino).getTail(), ((TLista)termino2).getTail());
                        }
                    }
                } else if (termino.isEstructura()) {
                    if (!this.estructurasIguales((TEstructura)termino, (TEstructura)termino2)) {
                        sLDParDiscordante = new SLDParDiscordante(termino, termino2);
                    } else {
                        int n = 0;
                        sLDParDiscordante = null;
                        while (sLDParDiscordante == null && n < ((TEstructura)termino).getArguments().size()) {
                            sLDParDiscordante = this.buscarParDiscordante((Termino)((TEstructura)termino).getArguments().elementAt(n), (Termino)((TEstructura)termino2).getArguments().elementAt(n));
                            ++n;
                        }
                    }
                } else if (termino.isExpresion()) {
                    if (!this.expresionesIguales((TExpresion)termino, (TExpresion)termino2)) {
                        sLDParDiscordante = new SLDParDiscordante(termino, termino2);
                    } else {
                        sLDParDiscordante = this.buscarParDiscordante(((TExpresion)termino).getOperando1(), ((TExpresion)termino2).getOperando1());
                        if (sLDParDiscordante == null) {
                            sLDParDiscordante = this.buscarParDiscordante(((TExpresion)termino).getOperando2(), ((TExpresion)termino2).getOperando2());
                        }
                    }
                } else {
                    sLDParDiscordante = null;
                }
            } else if (termino.isCompound() && termino2.isCompound()) {
                if (!this.compoundsIguales((TCompound)termino, (TCompound)termino2)) {
                    sLDParDiscordante = new SLDParDiscordante(termino, termino2);
                } else {
                    int n = 0;
                    sLDParDiscordante = null;
                    while (sLDParDiscordante == null && (long)n < ((TCompound)termino).getCompoundNumArguments()) {
                        sLDParDiscordante = this.buscarParDiscordante(((TCompound)termino).getCompoundArgumentAt(n), ((TCompound)termino2).getCompoundArgumentAt(n));
                        ++n;
                    }
                }
            } else {
                sLDParDiscordante = new SLDParDiscordante(termino, termino2);
            }
        } else {
            sLDParDiscordante = termino == null && termino2 == null ? null : new SLDParDiscordante(termino, termino2);
        }
        return sLDParDiscordante;
    }

    private boolean occurChek(TVar tVar, Termino termino) {
        boolean bl = false;
        if (termino == null) {
            bl = false;
        } else if (termino.isVar()) {
            bl = tVar.equals((TVar)termino);
        } else if (termino.isLista()) {
            if (((TLista)termino).aridad() == 0L) {
                bl = false;
            } else {
                bl = this.occurChek(tVar, ((TLista)termino).getHead());
                if (!bl) {
                    bl = this.occurChek(tVar, ((TLista)termino).getTail());
                }
            }
        } else if (termino.isEstructura()) {
            int n = 0;
            while (!bl && n < ((TEstructura)termino).getArguments().size()) {
                bl = this.occurChek(tVar, (Termino)((TEstructura)termino).getArguments().elementAt(n));
                ++n;
            }
        } else if (termino.isExpresion() && !(bl = this.occurChek(tVar, ((TExpresion)termino).getOperando1()))) {
            bl = this.occurChek(tVar, ((TExpresion)termino).getOperando2());
        }
        return bl;
    }

    private boolean algoritmoRobinson() {
        SLDParDiscordante sLDParDiscordante;
        boolean bl = true;
        this.UMG = new SLDSustitucion();
        Termino termino = (Termino)this.termino1.clone();
        Termino termino2 = (Termino)this.termino2.clone();
        while (bl && (sLDParDiscordante = this.buscarParDiscordante(termino, termino2)) != null) {
            SLDLigadura sLDLigadura = sLDParDiscordante.getSLDLigadura();
            if (sLDLigadura == null) {
                bl = false;
                this.UMG = null;
                continue;
            }
            if (this.occurChek(sLDLigadura.getVariable(), sLDLigadura.getTermino())) {
                bl = false;
                this.UMG = null;
                continue;
            }
            SLDSustitucion sLDSustitucion = new SLDSustitucion();
            sLDSustitucion.getLigaduras().addElement(sLDLigadura);
            this.UMG = this.UMG.componerCon(sLDSustitucion);
            termino = this.UMG.sustituirTermino(termino);
            termino2 = this.UMG.sustituirTermino(termino2);
        }
        return bl;
    }

    public Termino getTermino1() {
        return this.termino1;
    }

    public Termino getTermino2() {
        return this.termino2;
    }

    public SLDSustitucion getUMG() {
        return this.UMG;
    }

    public boolean isUnificable() {
        return this.unificable;
    }

    public String toString() {
        SLDParDiscordante sLDParDiscordante;
        String string = "";
        String string2 = "     ";
        boolean bl = true;
        int n = 0;
        String string3 = String.valueOf(n);
        string = "Algoritmo de unificacion de Robinson.\n\n";
        SLDSustitucion sLDSustitucion = new SLDSustitucion();
        string = string + string2 + "UMG(" + string3 + ") = " + sLDSustitucion.toString() + "\n";
        Termino termino = (Termino)this.termino1.clone();
        Termino termino2 = (Termino)this.termino2.clone();
        string = string + string2 + "Termino t1(" + string3 + ")= " + termino.toString() + "\n";
        string = string + string2 + "Termino t2(" + string3 + ")= " + termino2.toString() + "\n";
        while (bl && (sLDParDiscordante = this.buscarParDiscordante(termino, termino2)) != null) {
            string = string + string2 + "ITERACION " + string3 + "\n\n";
            string = string + string2 + "Paso 1 : t1(" + string3 + ")<>t2(" + string3 + ") --> [" + termino.toString() + "] <> [" + termino2.toString() + "]\n";
            string = string + string2 + "Paso 2 : D(" + string3 + ")=" + sLDParDiscordante.toString() + "\n";
            SLDLigadura sLDLigadura = sLDParDiscordante.getSLDLigadura();
            if (sLDLigadura == null) {
                string = string + string2 + "Paso 3: ERROR!!! no hay un termino y una variable!!.\n";
                bl = false;
                sLDSustitucion = null;
                continue;
            }
            string = string + string2 + "Paso 3: Hay un termino y una variable.\n";
            if (this.occurChek(sLDLigadura.getVariable(), sLDLigadura.getTermino())) {
                string = string + string2 + "Paso 4: ERROR!!! Existe un occur check entre la variable y el termino!.\n";
                bl = false;
                sLDSustitucion = null;
                continue;
            }
            string = string + string2 + "Paso 4: No existe un occur check entre la variable y el termino.\n";
            string = string + string2 + "Paso 5: A\u00f1adimos ligadura a la sustitucion y construimos nuevos terminos.\n";
            SLDSustitucion sLDSustitucion2 = new SLDSustitucion();
            sLDSustitucion2.getLigaduras().addElement(sLDLigadura);
            sLDSustitucion = sLDSustitucion.componerCon(sLDSustitucion2);
            termino = sLDSustitucion.sustituirTermino(termino);
            termino2 = sLDSustitucion.sustituirTermino(termino2);
            string3 = String.valueOf(++n);
            string = string + string2 + "        " + "UMG(" + string3 + ") = " + sLDSustitucion.toString() + "\n";
            string = string + string2 + "        " + "Termino t1(" + string3 + ")= " + termino.toString() + "\n";
            string = string + string2 + "        " + "Termino t2(" + string3 + ")= " + termino2.toString() + "\n";
            string = string + "\n\n";
        }
        string = bl ? string + "FIN ALGORITMO!! Existe unificacion UMG=" + sLDSustitucion.toString() + "\n\n" : string + "FIN ALGORITMO!! No existe unificacion.\n\n";
        return string;
    }

    public String toHTML() {
        String string = "";
        String string2 = "&nbsp;&nbsp;&nbsp;";
        boolean bl = true;
        int n = 0;
        String string3 = String.valueOf(n);
        string = string + "<HTML> ";
        string = string + "<body bgcolor=white text=black > ";
        string = string + "<B><U>Algoritmo de unificacion de Robinson.</B></U><BR><BR>";
        string = string + string2 + "<b>ITERACION " + string3 + "</b><BR><BR>";
        SLDSustitucion sLDSustitucion = new SLDSustitucion();
        string = string + string2 + "UMG(" + string3 + ") = " + sLDSustitucion.toString() + "<BR>";
        Termino termino = (Termino)this.termino1.clone();
        Termino termino2 = (Termino)this.termino2.clone();
        string = string + string2 + "Termino t1(" + string3 + ")= " + termino.toString() + "<BR>";
        string = string + string2 + "Termino t2(" + string3 + ")= " + termino2.toString() + "<BR>";
        SLDParDiscordante sLDParDiscordante = this.buscarParDiscordante(termino, termino2);
        while (bl && sLDParDiscordante != null) {
            string = string + string2 + "<b>ITERACION " + string3 + "</b><BR><BR>";
            string = string + string2 + "<i>Paso 1</i> : t1(" + string3 + ")<>t2(" + string3 + ") --> [" + termino.toString() + "] <> [" + termino2.toString() + "]<BR>";
            string = string + string2 + "<i>Paso 2</i> : D(" + string3 + ")=" + sLDParDiscordante.toString() + "<BR>";
            SLDLigadura sLDLigadura = sLDParDiscordante.getSLDLigadura();
            if (sLDLigadura == null) {
                string = string + string2 + "<i>Paso 3</i> : ERROR!!! no hay un termino y una variable!!.<BR>";
                bl = false;
                sLDSustitucion = null;
                continue;
            }
            string = string + string2 + "<i>Paso 3<i> : Hay un termino y una variable.<BR>";
            if (this.occurChek(sLDLigadura.getVariable(), sLDLigadura.getTermino())) {
                string = string + string2 + "<i>Paso 4</i> : ERROR!!! Existe un occur check entre la variable y el termino!.<BR>";
                bl = false;
                sLDSustitucion = null;
                continue;
            }
            string = string + string2 + "<i>Paso 4</i> : No existe un occur check entre la variable y el termino.<BR>";
            string = string + string2 + "<i>Paso 5</i> : A\u00f1adimos ligadura a la sustitucion y construimos nuevos terminos.<BR>";
            SLDSustitucion sLDSustitucion2 = new SLDSustitucion();
            sLDSustitucion2.getLigaduras().addElement(sLDLigadura);
            sLDSustitucion = sLDSustitucion.componerCon(sLDSustitucion2);
            termino = sLDSustitucion.sustituirTermino(termino);
            termino2 = sLDSustitucion.sustituirTermino(termino2);
            string3 = String.valueOf(++n);
            string = string + string2 + "        " + "UMG(" + string3 + ") = " + sLDSustitucion.toString() + "<BR>";
            string = string + string2 + "        " + "Termino t1(" + string3 + ")= " + termino.toString() + "<BR>";
            string = string + string2 + "        " + "Termino t2(" + string3 + ")= " + termino2.toString() + "<BR>";
            string = string + "<BR><BR>";
            sLDParDiscordante = this.buscarParDiscordante(termino, termino2);
        }
        string = bl ? (sLDParDiscordante == null && n == 0 ? string + "<b>FIN ALGORITMO!! Sin iteraciones, t1 y t2 identicos</b><BR><BR>" : string + "<b>FIN ALGORITMO!! Existe unificacion UMG=" + sLDSustitucion.toString() + "</b><BR><BR>") : string + "<b>FIN ALGORITMO!! No existe unificacion.</b><BR><BR>";
        string = string + " </HTML>";
        return string;
    }
}

