/*----------------------------------------------------------------|
| Nombre:   Hotel Teatinos                                        |
| Autores:  Jos Luis Pastrana Brincones                          |
|-----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <cstdlib>
#include <string>
using namespace std;

// Zona de Declaracin de Constantes
const char ENTER     = '\n';
const char TAB = '\t';
const unsigned int MAX_PLANTAS = 3;
const unsigned int MAX_HABITACIONES = 10;
// Zona de Declaracin de Tipos
typedef unsigned int TNatural;
typedef enum {simple, doble, suite} TTipoHabitacion;

struct TFecha
{
       TNatural day, month,year;
};
       
struct TInfoHabitacion
{
       string nif, nombre, apellido1, apellido2;
       TTipoHabitacion tipo;
       TFecha fecha_entrada;
};

struct THabitacion
{
       TInfoHabitacion info;
       bool vacia;       
};

typedef THabitacion THotel[MAX_PLANTAS][MAX_HABITACIONES];
// Zona de Cabeceras de Procedimientos y Funciones
char Menu();
bool ConfirmarSalir();
void InicializaHotel(THotel &hotel);
void LeerInfoHabitacion(TInfoHabitacion &info);
void LeerTipoHabitacion(TTipoHabitacion &tipo);
TTipoHabitacion SUC (TTipoHabitacion t);
string TipoHabitacion_a_Cadena(TTipoHabitacion tipo);
string Mayusculas(string s);
void Cadena_a_TipoHabitacion(string s, TTipoHabitacion &tipo, bool &ok);
void LeerFecha(TFecha &f);
TNatural NumeroHabitacion(TNatural planta, TNatural habitacion);
void InsertarHabitacion(THotel &hotel, TInfoHabitacion info, TNatural &num, bool &ok);
TNatural NumeroHabitacionesLibresTipo(THotel hotel,TTipoHabitacion tipo);
void VisualizarHotel(THotel hotel);
void EscribirInfoHabitacion(TInfoHabitacion info);
void EscribirFecha(TFecha f);
void BuscarPersona(THotel hotel, string nombre,string ape1,string ape2,
                   TNatural &p, TNatural &h,bool &ok);
void AbandonarHabitacion(THotel &hotel,TNatural num, TFecha fecha_salida);
void Numero_a_Planta_Habitacion(TNatural num, TNatural &p, TNatural &h);
TNatural DiasEntreFechas(TFecha f2, TFecha f1);
double CalculaFactura(TTipoHabitacion tipo, TNatural dias);
double gregorianoajuliano(TFecha f);
// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir,ok;
  THotel hotel;
  TInfoHabitacion info;
  TNatural num,p,h;
  TTipoHabitacion tipo;
  string nombre, ape1, ape2;
  TFecha fecha_salida;
  
  salir = false;
  InicializaHotel(hotel);
  
  while (!salir)
  {
        op = Menu();
        switch(op)
        {
            case 'A': LeerInfoHabitacion(info);
                      InsertarHabitacion(hotel, info, num, ok);
                      if (ok)
                      {
                             cout << "Habitacin asignada: " << num << endl;
                      }
                      else
                      {
                             cout << "Error: No hay habitaciones libres del tipo requerido" << endl;
                      }
                      break;
            case 'B': cout << "Tipo Habitacion: ";
                      LeerTipoHabitacion(tipo);
                      num = NumeroHabitacionesLibresTipo(hotel,tipo);
                      cout << "Hay " << num << " habitaciones del tipo " 
                           << TipoHabitacion_a_Cadena(tipo) << " libres." << endl;
                      break;
            case 'C': VisualizarHotel(hotel);
                      break;
            case 'D': cout << "Nombre:          " ;
                      getline(cin,nombre,ENTER);
                      cout << "Apellido 1:      ";
                      getline(cin,ape1,ENTER);
                      cout << "Apellido 2:      ";
                      getline(cin,ape2,ENTER);
                      BuscarPersona(hotel,nombre,ape1,ape2,p,h,ok);
                      if (ok)
                      {
                             cout << "Habitacin Numero: " << NumeroHabitacion(p,h) << endl;
                             EscribirInfoHabitacion(hotel[p][h].info);
                      }
                      else
                      {
                          cout << "Esa persona no se encuentra alojada en el hotel" << endl;
                      }
                      break;
            case 'E': cout << "Numero de Habitacion:    ";
                      cin >> num;
                      cin.ignore();
                      cout << "Fecha Salida:    ";
                      LeerFecha(fecha_salida);
                      AbandonarHabitacion(hotel,num,fecha_salida);                  
                      break;
            case 'X': salir=ConfirmarSalir();
                      break;
            default:  cout << "Opcin Incorrecta ... " << endl;
                      break;  
        }
        cout << endl;
        system("Pause"); // Hacer una pausa
        system("CLS");   // Borrar la Pantalla
  }

  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
// Implementacin de Procedimientos y Funciones
char Menu()
{
     char op;
     
     cout << "     	HOTEL TEATINOS" << endl;
     cout << "     	==============" << endl;
     cout << "Elaborado Por : Nombre Apellidos" << endl;
     cout << "E.T.S.I Informatica 1C Gestion" << endl;
     cout << "Fecha: 8 de Febrero de 2.000" << endl;
     cout << endl;
     cout << "A. Reservar Habitaciones." << endl;
     cout << "B. Numero Habitaciones Libres de un Tipo." << endl;
     cout << "C. Visualizar el Hotel." << endl;
     cout << "D. Buscar Persona Alojada." << endl;
     cout << "E. Abandonar el Hotel y Emitir Factura." << endl;
     cout << "X. Salir del Programa" << endl;
     cout << endl;
     cout << "Introduzca Opcin: ";
     
     cin >> op;
     cin.ignore(); // Ignoro el ENTER
     op = toupper(op);
     
     return op;
}

bool ConfirmarSalir()
{
     char si_no;
     
     cout << "Est Seguro/a (S/N)?" << endl;
     cin >> si_no;
     cin.ignore(); // Ignoro el ENTER
     si_no = toupper(si_no);
     
     return (si_no=='S');

}
void InicializaHotel(THotel &hotel)
{
     TNatural planta, habitacion;
     
     for(planta=0;planta<MAX_PLANTAS;++planta)
     {
        for(habitacion=0;habitacion<MAX_HABITACIONES;++habitacion)
        {
            hotel[planta][habitacion].vacia=true;                                     
            switch (habitacion)
            {
                   case 0: hotel[planta][habitacion].info.tipo = suite;
                           break;
                   case MAX_HABITACIONES-1:hotel[planta][habitacion].info.tipo = simple;
                           break;
                   default: hotel[planta][habitacion].info.tipo = doble;
                           break;
            }
        }
     }
}

void LeerInfoHabitacion(TInfoHabitacion &info)
{
     cout << "NIF:             ";
     getline(cin,info.nif,ENTER);
     cout << "Nombre:          " ;
     getline(cin,info.nombre,ENTER);
     cout << "Apellido 1:      ";
     getline(cin,info.apellido1,ENTER);
     cout << "Apellido 2:      ";
     getline(cin,info.apellido2,ENTER);
     cout << "Tipo Habitacion: ";
     LeerTipoHabitacion(info.tipo);
     cout << "Fecha Entrada:   ";
     LeerFecha(info.fecha_entrada);
}

void LeerTipoHabitacion(TTipoHabitacion &tipo)
{
     string s;
     bool ok;
     
     getline(cin,s,ENTER);
     Cadena_a_TipoHabitacion(s,tipo,ok);     
     while (!ok)
     {
           cout << "Tipo Erroneo ... " << endl;
           cout << "Tipo Habitacion: ";
           getline(cin,s,ENTER);
           Cadena_a_TipoHabitacion(s,tipo,ok);     
     }
}

TTipoHabitacion SUC (TTipoHabitacion t)
{
     TNatural ord;       
     
     ord = TNatural(t)+1;
     
     return TTipoHabitacion(ord);
}

string TipoHabitacion_a_Cadena(TTipoHabitacion tipo)
{
       string res;
       
       switch(tipo)
       {
           case simple: res = "Simple"; break;
           case doble:  res = "Doble"; break;
           case suite:  res = "Suite"; break;
       }
       
       return res;
}

string Mayusculas(string s)
{
       string res;
       TNatural i;
       res="";
       
       for(i=0;i<s.length();++i)
       {
           res+=toupper(s[i]);                     
       }
       return res;
}

void Cadena_a_TipoHabitacion(string s, TTipoHabitacion &tipo, bool &ok)
{
     ok=false;
     tipo = simple;
     
     while ( (tipo<=suite) && (!ok) )
     {
           if (Mayusculas(s)==Mayusculas(TipoHabitacion_a_Cadena(tipo)))
           {
               ok = true;
           }
           else
           {
               tipo=SUC(tipo);
           }
     }
}

void LeerFecha(TFecha &f)
{
     cout << endl;
     cout << TAB << TAB << "Dia: ";
     cin >> f.day;
     cin.ignore();
     cout << TAB << TAB << "Mes: ";
     cin >> f.month;
     cin.ignore();
     cout << TAB << TAB << "Ao: ";
     cin >> f.year;
     cin.ignore();     
}

TNatural NumeroHabitacion(TNatural planta, TNatural habitacion)
{
     return ( (planta+1)*100 + (habitacion+1) );
}

void InsertarHabitacion(THotel &hotel, TInfoHabitacion info, TNatural &num, bool &ok)
{
     TNatural planta, habitacion;
     
     ok=false;
     planta=0;
     while ((planta<MAX_PLANTAS) && (!ok) )
     {
        habitacion=0;
        while ( (habitacion<MAX_HABITACIONES) && (!ok) )
        {
            if ( (hotel[planta][habitacion].vacia) && 
                 (hotel[planta][habitacion].info.tipo==info.tipo)
               )  
            {
                  ok=true;
                  hotel[planta][habitacion].vacia = false;
                  hotel[planta][habitacion].info = info;
                  num = NumeroHabitacion(planta,habitacion);
            }
            ++habitacion;
        }
        ++planta;
     }
}

TNatural NumeroHabitacionesLibresTipo(THotel hotel,TTipoHabitacion tipo)
{
     TNatural num,planta, habitacion;
     
     num=0;
     
     for(planta=0;planta<MAX_PLANTAS;++planta)
     {
        for(habitacion=0;habitacion<MAX_HABITACIONES;++habitacion)
        {
            if ( (hotel[planta][habitacion].vacia) && 
                 (hotel[planta][habitacion].info.tipo==tipo)
               )  
            {
                  ++num;
            }
        }
     }
     
     return num;
}

void VisualizarHotel(THotel hotel)
{
     TNatural planta, habitacion;     
     
     for(planta=0;planta<MAX_PLANTAS;++planta)
     {
        for(habitacion=0;habitacion<MAX_HABITACIONES;++habitacion)
        {
            if (!hotel[planta][habitacion].vacia)
            {
                  cout << "Habitacin Numero: " << NumeroHabitacion(planta,habitacion) 
                       << endl;
                  EscribirInfoHabitacion(hotel[planta][habitacion].info);
            }
        }
     }
     
}

void EscribirInfoHabitacion(TInfoHabitacion info)
{
     cout << endl;
     cout << "NIF:             " << info.nif << endl;
     cout << "Nombre:          " << info.nombre << endl;
     cout << "Apellido 1:      " << info.apellido1 << endl;
     cout << "Apellido 2:      " << info.apellido2 << endl;
     cout << "Tipo Habitacion: " << TipoHabitacion_a_Cadena(info.tipo) << endl;
     cout << "Fecha Entrada:   ";
     EscribirFecha(info.fecha_entrada);
     cout << endl;
}

void EscribirFecha(TFecha f)
{
     cout << f.day << "/" << f.month << "/" << f.year;
}

void BuscarPersona(THotel hotel, string nombre,string ape1,string ape2,
                   TNatural &p, TNatural &h,bool &ok)
{
     ok=false;
     p=0;
     while ((p<MAX_PLANTAS) && (!ok) )
     {
        h=0;
        while ( (h<MAX_HABITACIONES) && (!ok) )
        {
            if ( (!hotel[p][h].vacia) && 
                 (hotel[p][h].info.nombre==nombre) &&
                 (hotel[p][h].info.apellido1==ape1) &&
                 (hotel[p][h].info.apellido2==ape2) 
               )  
            {
                  ok=true;
            }
            else
            {
                  ++h;
            }
        }
        if (!ok)
        {
           ++p;
        }
     }
}

void AbandonarHabitacion(THotel &hotel,TNatural num, TFecha fecha_salida)
{
     TNatural p,h,dias;
     double importe;
     
     Numero_a_Planta_Habitacion(num,p,h);                      
     
     if ( (p>=MAX_PLANTAS) || (h>=MAX_HABITACIONES) )
     {
        cout << "ERROR: Numero de habitacin erroneo ... " << endl;
     }
     else if ( hotel[p][h].vacia )
     {
        cout << "ERROR: La habitacin est vaca ... " << endl;
     }
     else
     {
        cout << "Habitacin Numero: " << num << endl;
        EscribirInfoHabitacion(hotel[p][h].info);
        dias = DiasEntreFechas(fecha_salida,hotel[p][h].info.fecha_entrada);
        importe = CalculaFactura(hotel[p][h].info.tipo,dias);
        cout << "Numero de Dias alojado: " << dias << endl;
        cout << "Importe de la Factura:  " << importe << " " << endl;
        hotel[p][h].vacia=true;
     }    
}

void Numero_a_Planta_Habitacion(TNatural num, TNatural &p, TNatural &h)
{
     p = (num/100)-1;
     h = (num%100)-1;
}

TNatural DiasEntreFechas(TFecha f2, TFecha f1)
{
         return TNatural(gregorianoajuliano(f2)-gregorianoajuliano(f1));
}

double gregorianoajuliano(TFecha f) 
{ //dada una fecha del calendario gregoriano, obtiene 
  //un real que la representa 
  TNatural tmes, tanno;
  double jdia; 
  
  //marzo es el mes 0 del ao 
  if (f.month > 2) 
  { 
      tmes = f.month - 3; 
      tanno = f.year; } 
  else //febrero es el mes 11 del ao anterior. 
  { 
       tmes = f.month + 9; 
       tanno = f.year - 1; 
  } 
  jdia = (tanno / 4000) * 1460969; 
  tanno = (tanno % 4000); 
  jdia = jdia + (((tanno / 100) * 146097) / 4) 
       + (((tanno % 100) * 1461) / 4) 
       + (((153 * tmes) + 2) / 5) + f.day + 1721119; 
  
  return jdia; 
}



double CalculaFactura(TTipoHabitacion tipo, TNatural dias)
{
       double pvp_dia;
       
       switch(tipo)
       {
           case simple: pvp_dia = 90.50;  break;
           case doble:  pvp_dia = 120.00; break;
           case suite:  pvp_dia = 350.25; break;
       }
       
       return dias*pvp_dia;
}
