/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>
using namespace std;

#include "MIndice.h"
using namespace MIndice;

// Zona de Declaracin de Constantes
const char ENTER = '\n'; 

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char Menu ();
bool ConfirmarSalir ();
void CargaFicheroIndice(string nombre,TIndice &Indice,TError &error);
void LeePalabra (ifstream &fich, string &palabra, int &posIni, int &posFin);
bool es_Separador(char c);
void SalvaIndiceFichBIN(string nombre,TIndice &Indice);
void CargaIndiceFichBIN(string nombre,TIndice &Indice,TError &error);

// Programa Principal
int main ()
{
    char opcion;
    bool salir;
    string nombre;
    TIndice Indice;
    TError error;
    
    CreaIndice (Indice);
    salir = false;
    
    do
    {
        opcion = Menu ();
        cout << endl;
        error = Ok;
        
        switch (opcion)
        {
            case 'A':
                cout << "Introduzca nombre del fichero: ";
                getline (cin, nombre, ENTER);
                CargaFicheroIndice(nombre,Indice,error);
                break;
            case 'B':
                EscribeIndicePantalla(Indice);
                break;
            case 'C':
                cout << "Introduzca nombre del fichero: ";
                getline (cin, nombre, ENTER);
                SalvaIndiceFichBIN(nombre,Indice);
                break;
            case 'D':
                cout << "Introduzca nombre del fichero: ";
                getline (cin, nombre, ENTER);
                CargaIndiceFichBIN(nombre,Indice,error);
                break;
            case 'X':
                salir = ConfirmarSalir ();
                break;
            default:
                cerr << "Opcion no reconocida, pulse ENTER para continuar.";
                break;
        }
        MostrarError(error);
        system ("Pause"); // Hacer una pausa
    } while (!salir);
    
    DestruyeIndice (Indice);
    
    system ("cls");   // Borrar Pantalla
    return (EXIT_SUCCESS);
}

// Implementacin de Procedimientos y Funciones
char Menu ()
{
    char opcion;
  
    system ("cls");   // Borrar Pantalla
    cout << "Nombre: (Apellidos, Nombre)    Curso: 1" << endl;
    cout << "Especialidad: Gestion          Grupo: A/B" << endl;
    cout << "Puesto: nmero de ordenador    Fecha: 23/06/2010" << endl;
    cout << endl;
    cout << " INDICE" << endl;
    cout << " ======" << endl;
    cout << "A. Construir indice para fichero de texto" << endl;
    cout << "B. Mostrar indice" << endl;
    cout << "C. Almacenar indice en fichero binario" << endl;
    cout << "D. Leer indice de fichero binario" << endl;
    cout << "X. Salir" << endl;
    cout << endl;
  
    do
    {
        cout << "  Introduzca Opcion: " ;
        cin >> opcion;
        cin.ignore ();
        opcion = toupper (opcion);  
    } while (((opcion < 'A') || (opcion > 'D')) && (opcion != 'X'));
    return opcion;
}

bool ConfirmarSalir ()
{ 
    char car;

    cout << "Realmente quiere salir (S/N): ";
    cin >> car;
    cin.ignore ();
  
    return (toupper (car) == 'S');
}

void CargaFicheroIndice(string nombre,TIndice &Indice,TError &error)
{
     ifstream fich;     
     string palabra;
     int posIni, posFin;
     
     DestruyeIndice (Indice);
     CreaIndice (Indice);
                
     fich.open(nombre.c_str());
     
     if (fich.fail() || fich.bad() )
     {
         cout << "Error al Abrir el Fichero " << nombre << endl;            
     }
     else
     {
         posIni=0;
         LeePalabra (fich, palabra, posIni, posFin);
         while (!fich.eof())
         {
             NuevaAparicion (Indice,palabra,posIni,error);  
             posIni=posFin;
             LeePalabra (fich, palabra, posIni, posFin);
         }
         fich.close();
     }
}

void LeePalabra (ifstream &fich, string &palabra, int &posIni, int &posFin)
{
     char c;
     
     palabra = "";
     
     // Salto los posibles separadores antes de la palabra
     c = fich.get();
     while ( (!fich.eof()) && (es_Separador(c)) )
     {
           ++posIni;
           c = fich.get();
     }

     // Leo la Palabra
     posFin = posIni;

     while ( (!fich.eof()) && (!es_Separador(c)) )
     {
           palabra+=c;
           ++posFin;
           c = fich.get();
     }

}

bool es_Separador(char c)
{
     bool es_letra, es_numero;
     
     c = toupper(c);
     es_letra  = (c>='A') && (c<='Z');
     es_numero = (c>='0') && (c<='9');
     
     return (!es_letra)&&(!es_numero);
}

void SalvaIndiceFichBIN(string nombre,TIndice &Indice)
{
     ofstream fich;
     
     fich.open(nombre.c_str(), ios::binary);
     
     if (fich.fail() || fich.bad() )
     {
         cout << "Error al Abrir el Fichero " << nombre << endl;            
     }
     else
     {
         EscribeIndiceFichero(fich, Indice);
         fich.close();
     }
}

void CargaIndiceFichBIN(string nombre,TIndice &Indice,TError &error)
{
     ifstream fich;
     
     DestruyeIndice (Indice);
     CreaIndice (Indice);

     fich.open(nombre.c_str(), ios::binary);
     
     if (fich.fail() || fich.bad() )
     {
         cout << "Error al Abrir el Fichero " << nombre << endl;            
     }
     else
     {
         LeeIndiceFichero (fich, Indice, error);
         fich.close();
     }
}
