#include "MIndice.h"

namespace MIndice
{
    // Procedimientos Auxiliares
    int hash (string s);
    void SacarPalabra(TListaPalabras &l ,string pal, TPalabra &p);
    void DuplicaListaPalabras(TListaPalabras &origen, TListaPalabras &destino);
    void DuplicaPalabra(TPalabra &p1, TPalabra &p2);
    void NumeroDePosiciones(TPalabra &p, int &num);
    void LeeStringBinario(ifstream &fich, string &s);
    void EscribeStringBinario(ofstream &fich, string s);
    
    //PROC del Mdulo      
    void CreaIndice (TIndice & i)
    {
         int x;
         
         for(x=0;x<MAXINDEX;++x)
         {
             i[x] = CreaListaPalabras();
         }
    }

    void DestruyeIndice (TIndice & i)
    {
         int x;
         
         for(x=0;x<MAXINDEX;++x)
         {
             DestruyeListaPalabras(i[x]);
         }
    }

    void NuevaAparicion (TIndice & i, string palabra, int posicion, 
                         TError & error)
    {
         TPalabra p,p2;
         int index;
         
         p = CreaPalabra(palabra); 
         NuevaPosicion(p,posicion,error);
         index = hash(palabra); 
         InsertaListaPalabras(i[index],p,error);
          
         if (error==ElementoExistente)
         {
             SacarPalabra(i[index],palabra,p2);
             NuevaPosicion(p2,posicion,error);
             DestruyePalabra(p);
             InsertaListaPalabras(i[index],p2,error);
             error = Ok;
         }
              
    }

    void LeeIndiceFichero (ifstream & fi, TIndice & i, TError & error)
    {
         string pal;
         int tam,x,pos;
         TPalabra p;
         
         DestruyeIndice(i);
         CreaIndice(i);
         
         LeeStringBinario(fi,pal);
         while (!fi.eof())
         {
             p = CreaPalabra(pal); 
             fi.read((char *)&tam, sizeof(int));
             for(x=0;x<tam;++x)
             {
                 fi.read((char *)&pos, sizeof(int));                               
                 NuevaPosicion(p,pos,error);
             }
             InsertaListaPalabras(i[hash(pal)],p,error);
             LeeStringBinario(fi,pal);  
         }
    }
    
    void EscribeIndiceFichero (ofstream & of, TIndice &i)
    {
         int x, pos, tam;
         TListaPalabras aux;
         TPalabra p;
         string pal;
         TError error;
         
         for(x=0;x<MAXINDEX;++x)
         {
             DuplicaListaPalabras(i[x],aux);
             while (!ListaPalabrasVacia(aux))
             {
                 SacaPrimeroListaPalabras (aux,p,error);
                 Palabra (p,pal);
                 EscribeStringBinario(of,pal);
                 NumeroDePosiciones(p,tam);
                 of.write((char *)&tam, sizeof(int));
                 SacaPrimeraPosicion(p,pos,error);
                 while (error==Ok)
                 {
                       of.write((char *)&pos, sizeof(int));
                       SacaPrimeraPosicion(p,pos,error);
                 }
                 DestruyePalabra(p);
             }
             DestruyeListaPalabras(aux);
             
         }
    }

    void EscribeIndicePantalla (TIndice &i)
    {
         int x, pos;
         TListaPalabras aux;
         TPalabra p;
         string pal;
         TError error;
         
         for(x=0;x<MAXINDEX;++x)
         {
             DuplicaListaPalabras(i[x],aux);
             while (!ListaPalabrasVacia(aux))
             {
                 SacaPrimeroListaPalabras (aux,p,error);
                 Palabra (p,pal);
                 cout << "palabra: " << pal << endl;
                 cout << "Posicion: ";
                 SacaPrimeraPosicion(p,pos,error);
                 while (error==Ok)
                 {
                       cout << pos << " ";
                       SacaPrimeraPosicion(p,pos,error);
                 }
                 cout << endl;
                 DestruyePalabra(p);
             }
             DestruyeListaPalabras(aux);
             
         }
    }
    
    // Implementacin de Procedimientos Auxiliares
    
    int hash (string s)
    {
        return int(s[0])%MAXINDEX;
    }
    
    void SacarPalabra(TListaPalabras &l ,string pal, TPalabra &p)
    {
       TListaPalabras aux;
       TError error;
       bool encontrado;
       string paux;
       
       aux = CreaListaPalabras();
       encontrado = false;
       
       while ( (!ListaPalabrasVacia(l)) && (!encontrado) )
       {
             SacaPrimeroListaPalabras (l,p,error);
             Palabra(p,paux);
             if (paux == pal)
             {
                 encontrado= true;
             }     
             else
             {
                 InsertaListaPalabras (aux,p,error);
             }
       }
       
       while (!ListaPalabrasVacia(aux))
       {
             SacaPrimeroListaPalabras (aux,p,error);
             InsertaListaPalabras (l,p,error);
       }
       
       DestruyeListaPalabras(aux);
       
    }
    
    void DuplicaListaPalabras(TListaPalabras &origen, TListaPalabras &destino)
    {
       TListaPalabras aux;
       TPalabra p,p2;
       TError error;
       
       aux = CreaListaPalabras();
       destino = CreaListaPalabras();
       
       while (!ListaPalabrasVacia(origen))
       {
             SacaPrimeroListaPalabras (origen,p,error);
             InsertaListaPalabras (aux,p,error);
       }
       while (!ListaPalabrasVacia(aux))
       {
             SacaPrimeroListaPalabras (aux,p,error);
             DuplicaPalabra(p,p2);
             InsertaListaPalabras (origen,p,error);
             InsertaListaPalabras (destino,p2,error);
       }
       
       DestruyeListaPalabras(aux);
       
    }
    
    void DuplicaPalabra(TPalabra &p1, TPalabra &p2)
    {
         string pal;
         TListaEnteros aux;
         TError error;
         int x;
         
         Palabra(p1,pal);
         p2 = CreaPalabra(pal);
         
         aux = CreaListaEnteros();
         SacaPrimeraPosicion(p1, x, error);
         while (error==Ok)
         {
               SacaPrimeraPosicion(p1, x, error);
               InsertaListaEnteros(aux,x,error);
         }
         
         while (!ListaEnterosVacia(aux))
         {
             SacaPrimeroListaEnteros (aux,x,error);
             NuevaPosicion (p1, x, error);
             NuevaPosicion (p2, x, error);
         }
         
         DestruyeListaEnteros(aux);
              
    }
    
    void NumeroDePosiciones(TPalabra &p, int &num)
    {
        int pos;
        TError error;
        
        SacaPrimeraPosicion(p,pos,error);
        if (error==Ok)
        {
             NumeroDePosiciones(p,num);
             NuevaPosicion (p,pos,error);
             ++num;
        }
        else
        {
            num=0;
        }
    }
    
    void LeeStringBinario(ifstream &fich, string &s)
    {
        int i,tam;
        char car;
         
        fich.read((char *)&tam, sizeof(int));
        s = "";
        
        for(i=0;i<tam;++i)
        {
            fich.read((char *)&car, sizeof(char));
            s+=car; // Concatenamos el carcter ledo al string
        }
    }

    void EscribeStringBinario(ofstream &fich, string s)
    {
        int i,tam; 
        char car;
    
        tam = s.length();
             
        fich.write((char *)&tam, sizeof(int));
        for(i=0;i<tam;++i)
        {
            car = s[i];              
            fich.write((char *)&car, sizeof(char));
        }
    }

}
