#ifndef _MIndice_h
#define _MIndice_h

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include "MError.h"
#include "MListaEnteros.h"
#include "MPalabra.h"
#include "MListaPalabras.h"

using namespace std;
using namespace MError;
using namespace MListaEnteros;
using namespace MPalabra;
using namespace MListaPalabras;

namespace MIndice
{
     const int MAXINDEX = 32;
     typedef TListaPalabras TIndice[MAXINDEX];

    void CreaIndice (TIndice & i);
    /* Crea un ndice vaco */
    void DestruyeIndice (TIndice & i);
    /* Destruye el ndice, dejndolo nuevamente vaco */
    void NuevaAparicion (TIndice & i, string palabra, int posicion, 
                         TError & error);
    /* Aade una nueva aparicin en el ndice para una palabra determinada. 
    Si la palabra ya exista incluye la nueva posicin en su lista de posiciones. 
    nicamente devuelve un error si falta memoria para realizar la operacin (EstructuraLlena) 
    o bien si se intenta insertar una palabra y posicin que ya exista (ElementoExistente) */
    void LeeIndiceFichero (ifstream & fi, TIndice & i, TError & error);
    /* Destruye el ndice actual y lo vuelve a generar a partir del contenido del fichero binario especificado en el descriptor */
    void EscribeIndiceFichero (ofstream & of, TIndice &i);
    /* Almacena el ndice actual en el fichero binario especificado en el descriptor. El ndice en memoria deber preservarse tras la llamada */
    void EscribeIndicePantalla (TIndice &i);
    /* Escribe el ndice actual en la pantalla, debindose preservar el valor del ndice en memoria tras la llamada */
}
#endif
