#include "MListaEnteros.h"

namespace MListaEnteros
{
    TListaEnteros CreaListaEnteros ()
    {
       return NULL;
    }

    void DestruyeListaEnteros (TListaEnteros & l)
    {
       TListaEnteros aux;
       
       while (l!=NULL)
       {
           aux = l;
           l = l->sig;
           delete(aux);
       }
    }
    
    void InsertaListaEnteros (TListaEnteros & l, int valor, TError & error)
    {
         TListaEnteros nuevo;
         
         if (ListaEnterosLlena(l))
         {
              error = EstructuraLlena;                     
         }
         else if ( (l==NULL) || (valor < l->x))
         {
              nuevo = new (TNodoEntero);
              nuevo->x = valor;
              nuevo->sig = l;
              l = nuevo;
              error = Ok;
         }
         else if (valor == l->x)
         {
              error = ElementoExistente;
         }
         else 
         {
              InsertaListaEnteros (l->sig,valor,error);
         }
    }
    
    
    bool ListaEnterosVacia (TListaEnteros l)
    {
         return (l==NULL);
    }
    
    bool ListaEnterosLlena (TListaEnteros l)
    {
         TListaEnteros aux;
         bool esta_llena;
         
         aux = new (TNodoEntero);
         esta_llena = (aux==NULL);
         
         if (!esta_llena)
         {
             delete(aux);
         }            
         
         return esta_llena;
    }
    
    
    void SacaPrimeroListaEnteros (TListaEnteros &l, int &valor, TError &error)
    {
         TListaEnteros aux;

         if (l==NULL)
         {
              error = ElementoInexistente;
         }
         else
         {
              error = Ok;
              aux = l;
              l = l->sig;
              valor = aux->x;
              delete(aux);
         }
    }

}
