#ifndef _MListaEnteros_h
#define _MListaEnteros_h

#include <iostream>
#include <cstdlib>
#include "MError.h"

using namespace std;
using namespace MError;

namespace MListaEnteros
{
    typedef struct TNodoEntero *TListaEnteros;
    struct TNodoEntero
    {
        int x;
        TListaEnteros sig;
    };
    
    TListaEnteros CreaListaEnteros ();
    /* Funcin que crea una lista de enteros */

    void DestruyeListaEnteros (TListaEnteros & l);
    /* Funcin que destruye una lista de enteros */
    
    void InsertaListaEnteros (TListaEnteros & l, int valor, TError & error);
    /* Inserta en orden el nuevo valor. Si el elemento ya se encuentra en la lista no se modifica la misma y se devuelve el error ElementoExistente */
    
    bool ListaEnterosVacia (TListaEnteros l);
    /* Funcin que indica si la lista est vaca */
    
    bool ListaEnterosLlena (TListaEnteros l);
    /* Funcin que indica si la lista est llena */
    
    void SacaPrimeroListaEnteros (TListaEnteros &l, int &valor, TError &error);
    /* Extrae el primer elemento de la lista, devolviendo su valor y eliminndolo de la misma. Devolver el error ElementoInexistente si la lista se encuentra vaca */

}

#endif
