#include "MListaPalabras.h"

namespace MListaPalabras
{

    TListaPalabras CreaListaPalabras ()
    {
         return NULL;
    }          
    
    void DestruyeListaPalabras (TListaPalabras & l)
    {
         TListaPalabras aux;
         
         while (l!=NULL)
         {
               aux = l;
               l = l->sig;
               DestruyePalabra(aux->p);
               delete(aux);
         }
    }          

    void InsertaListaPalabras (TListaPalabras &l,TPalabra valor,TError &error)
    {
         TListaPalabras nuevo;
         
         if (ListaPalabrasLlena(l))
         {
              error = EstructuraLlena;                     
         }
         else if ( (l==NULL) || (ComparaPalabras(valor,l->p)==menor))
         {
              nuevo = new (TNodo);
              nuevo->p = valor;
              nuevo->sig = l;
              l = nuevo;
              error = Ok;
         }
         else if (ComparaPalabras(valor,l->p)==igual)
         {
              error = ElementoExistente;
         }
         else 
         {
              InsertaListaPalabras (l->sig,valor,error);
         }         
    }
    
    bool ListaPalabrasVacia (TListaPalabras l)
    {
         return (l==NULL);
    }          

    bool ListaPalabrasLlena (TListaPalabras l)
    {
         TListaPalabras aux;
         bool esta_llena;
         
         aux = new (TNodo);
         esta_llena = (aux==NULL);
         
         if (!esta_llena)
         {
             delete(aux);
         }            
         
         return esta_llena;
    }
    void SacaPrimeroListaPalabras (TListaPalabras & l, TPalabra & valor, 
                                   TError & error)
    {
         TListaPalabras aux;

         if (l==NULL)
         {
              error = ElementoInexistente;
         }
         else
         {
              error = Ok;
              aux = l;
              l = l->sig;
              valor = aux->p;
              delete(aux);
         }
    }
    

}
