#ifndef _MListaPalabras_h
#define _MListaPalabras_h

#include <iostream>
#include <cstdlib>
#include <string>
#include "MError.h"
#include "MListaEnteros.h"
#include "MPalabra.h"

using namespace std;
using namespace MError;
using namespace MListaEnteros;
using namespace MPalabra;

namespace MListaPalabras
{
    typedef struct TNodo *TListaPalabras;
    struct TNodo
    {
           TPalabra p;
           TListaPalabras sig;
    };

    TListaPalabras CreaListaPalabras ();
    /* Funcin que crea una lista de palabras */
    void DestruyeListaPalabras (TListaPalabras & l);
    /* Funcin que destruye una lista de palabras */
    void InsertaListaPalabras (TListaPalabras &l,TPalabra valor,TError &error);
    /* Inserta en orden el nuevo valor de palabra. Si ya se encuentra en la lista 
       no se modifica la misma y se devuelve el error ElementoExistente */
    bool ListaPalabrasVacia (TListaPalabras l);
    /* Funcin que indica si la lista est vaca */
    bool ListaPalabrasLlena (TListaPalabras l);
    /* Funcin que indica si la lista est llena */
    void SacaPrimeroListaPalabras (TListaPalabras & l, TPalabra & valor, 
                                   TError & error);
    /* Extrae el primer elemento de la lista, devolviendo su valor y eliminndolo 
    de la misma. Devolver el error ElementoInexistente si la lista se encuentra vaca */

}
#endif
