#ifndef _MPalabra_h
#define _MPalabra_h

#include <iostream>
#include <cstdlib>
#include <string>
#include "MError.h"
#include "MListaEnteros.h"

using namespace std;
using namespace MError;
using namespace MListaEnteros;

namespace MPalabra
{
     struct TPalabra
     {
            string palabra;
            TListaEnteros lista_pos;
     };

     typedef enum {menor, igual, mayor} TComparacion;

     TComparacion ComparaPalabras (TPalabra p1, TPalabra p2);
     /* Compara dos palabras indicando si p1 es menor, igual o mayor que p2. 
     La comparacin de palabras ser sensible a maysculas y minsculas, y 
     se realizar atendiendo exclusivamente a la cadena de caracteres que la 
     consituye, sin tener en cuenta la lista de posiciones en el fichero */
     
     TPalabra CreaPalabra (string palabra);
     /* Crea una palabra partiendo de la cadena indicada */
     
     void DestruyePalabra (TPalabra & p);
     /* Destruye la palabra indicada */
     
     void NuevaPosicion (TPalabra & p, int posicion, TError & error);
     /* Aade la posicin indicada en la lista de posiciones */
     
     void Palabra (TPalabra p, string & c);
     /* Devuelve la cadena de caracteres de la palabra especificada */

     void SacaPrimeraPosicion (TPalabra & p, int & posicion, TError & error);
     /* Devuelve la primera posicin en la lista, eliminndola de la lista */     
}
#endif
