
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <string>
#include "MCita.h"
#include "MLista.h"

using namespace std;
using namespace MCadena;
using namespace MCita;

namespace MLista 
{   
    
    // Cabeceras Procedimientos auxiliares
    void InsertaCabezaLista(TLista &l, TCita cita, TErrorLista &error);
            
    // Implementacin Procedimientos del Modulo
    TLista CrearLista()
    {
           return NULL; 
    }
    
    
    int NumCitasLista(TLista l)
    {
        TLista ptr;
        int res;
        
        res = 0;
        ptr = l;
        while (ptr != NULL)
        {
              ++res;
              ptr = ptr->sig;
        }
        return res;
    }
   
    bool ListaVacia(TLista l)
    {
         return (l == NULL);
    }
    
    
    bool ListaLlena(TLista l)
    {
         TLista aux;
         bool llena;
         
         aux = new (TNodo);
         
         llena = (aux==NULL);
         
         if (!llena)
         {
            delete (aux);
         }
         
         return  llena;
    }
    
    
    void InsertarLista(TLista &l,TCita cita,TErrorLista &error)
    {
         if (ListaVacia(l))
         {
            InsertaCabezaLista(l,cita,error);
         }
         else
         {    
              switch (ComparaHoras(cita.Hora,l->cita.Hora))
              { 
                case Menor: InsertaCabezaLista(l,cita,error);
                            break;
                         
                case Igual: l->cita = cita;
                            break;
                         
                case Mayor: InsertarLista(l->sig,cita,error);
                            break;
              }
         }
    }
   
   
    void EliminarLista(TLista &l,THora hora)
    {
         TLista ptr;

         if (!ListaVacia(l))
         {
              switch (ComparaHoras(hora,l->cita.Hora))
              { 
                case Menor: // La cita No est
                            break;
                         
                case Igual: ptr = l ;
                            l = l->sig;
                            delete (ptr);
                            break;
                         
                case Mayor: EliminarLista(l->sig,hora);
                            break;
              }
         }
    }
    
    void BuscarListaHora(TLista l,THora hora,TCita &cita,bool &encontrado)
    {            
         if (ListaVacia(l))
         {
            encontrado = false;
         }
         else
         {    
              switch (ComparaHoras(cita.Hora,l->cita.Hora))
              { 
                case Menor: encontrado = false;
                            break;
                         
                case Igual: cita = l->cita;
                            encontrado = true;
                            break;
                         
                case Mayor: BuscarListaHora(l->sig,hora,cita,encontrado);
                            break;
              }
         }         
    }
    
    
    void BuscarListaNombre(TLista l,string nombre,TCita &cita,bool &encontrado)
    {
         if (ListaVacia(l))
         {
            encontrado = false;
         }
         else if (IgualCadena(l->cita.evento,nombre)) 
         {
            encontrado = true;
            cita = l->cita;
         }
         else 
         {
            BuscarListaNombre(l->sig,nombre,cita,encontrado); 
         }
    }
    
    void DestruirLista(TLista &l)
    {
         TLista ptr;
         
         while (l != NULL)
         {
            ptr = l;
            l = l->sig;
            delete(ptr);   
         }
    }
    
    void MostrarListaCitas(TLista l)
    {
         TLista ptr;
         
         ptr = l;
         while (ptr != NULL)
         {
               EscribirCita(ptr->cita);
               ptr = ptr->sig;
         }
    }
    
    
    void SalvarListaCitaFichero(ofstream &fich,TLista l)
    {
         TLista ptr;
         
         ptr =l;
         while (ptr != NULL)
         {
               EscribirCitaFichero(ptr->cita,fich);
               ptr = ptr->sig;
         }
         
    }
    
    // Implementacin Procedimientos auxiliares
    void InsertaCabezaLista(TLista &l, TCita cita, TErrorLista &error)
    {
         TLista nuevo;
         
         if (ListaLlena(l))
         {
            error = ErrorListaLlena;
         }
         else
         {
             error = NoError;
             nuevo = new (TNodo);
             nuevo->cita = cita;
             nuevo->sig = l;
             l = nuevo; 
         }

    }
}


