#ifndef _MLista_h_
#define _MLista_h_

#include <iostream>
#include <fstream>
#include <cstdlib>

#include <string>
#include "MCita.h"

using namespace std;
using namespace MCadena;
using namespace MCita;

namespace MLista
{
    typedef enum {NoError,ErrorListaLlena,ErrorListaVacia} TErrorLista;
    
    typedef struct TNodo*TLista;
    struct TNodo
    {
           TCita cita;
           TLista sig;
    };
    
    TLista CrearLista();
    TNatural NumCitasLista(TLista l);
    bool ListaVacia(TLista l);
    bool ListaLlena(TLista l);
    void InsertarLista(TLista &l,TCita cita,TErrorLista &error);
    void EliminarLista(TLista &l,THora hora);
    void BuscarListaHora(TLista l,THora hora,
                         TCita &cita, bool &encontrado);
    void BuscarListaNombre(TLista l,string nombre,
                           TCita &cita,bool &encontrado);                            
    void DestruirLista(TLista &l);
    void MostrarListaCitas(TLista l);
    void SalvarListaCitaFichero(ofstream &fich,TLista l);
    
          
}
#endif


