/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>

#include "MCita.h"
#include "MLista.h"

using namespace std;
using namespace MCita;
using namespace MLista;

// Zona de Declaracin de Constantes
const TNatural MAXDIA = 30;
const TNatural MAXMES = 12;

// Zona de Declaracin de Tipos
typedef TLista TMatriz[MAXMES][MAXDIA];
    
// Zona de Cabeceras de Procedimientos y Funciones
bool Confirmar();
char Menu();
void InicializaMatriz(TMatriz &m);
void DestruyeMatriz(TMatriz &m);
TNatural LeerDia();
TNatural LeerMes();
THora LeerHora();
void PintarCitaDia(TNatural mes, TNatural dia, TCita cita);
void GeneraCarta(TNatural mes,TNatural dia,TCita cita,
                 string nomfichCarta,string nomfich);
void LeePalabra(ifstream &origen, string &s, char &sep);
// Programa Principal

int main()
{
       
    char opmenu,si;
    bool ok,salir;
    TMatriz m;
    TNatural num,dia, mes;
    TCita cita;
    TErrorLista error;
    string evento,nomfich,nomfichCarta;
    THora h;
    ofstream fich;
    
    InicializaMatriz(m);
    salir = false;
    while (!salir)
    {
      opmenu = Menu();
      switch (opmenu)
      {
             case 'A': dia = LeerDia();
                       mes = LeerMes();
                       cita = LeerCita();
                       InsertarLista(m[mes][dia],cita,error);
                       break;
                       
             case 'B': cout << "Escriba el evento"<<endl;
                       cin.getline(evento,MAXCAD,ENTER);
                       for(mes=0;mes<MAXMES;++mes)
                       {
                          for(dia=0;dia<MAXDIA;++dia)
                          {
                              BuscarListaNombre(m[mes][dia],evento,cita,ok);
                              if (ok)
                              {
                                 PintarCitaDia(mes,dia,cita);
                              }
                          }
                       }
                       break;
                       
             case 'C': dia = LeerDia();
                       mes = LeerMes();
                       h   = LeerHora();                  
                       BuscarListaHora(m[mes][dia],h,cita,ok);
                       if (ok)
                       {
                           PintarCitaDia(mes,dia,cita);
                           
                           if(Confirmar())
                           {
                              EliminarLista(m[mes][dia],h);
                           }   
                       }                     
                       break;
             case 'D': for(mes=0;mes<MAXMES;++mes)
                       {
                           for(dia=0;dia<MAXDIA;++dia)
                           {
                              cout << " Citas del " 
                                   << dia+1 << "/" << mes+1 
                                   << ": " << endl;
                              MostrarListaCitas(m[mes][dia]);
                           }
                       }
                       break;               
             case'E':
                     cout<<"Nombre del Fichero: "<<endl;
                     cin.getline(nomfich,MAXCAD,ENTER);
                     fich.open(nomfich);
                     if (!fich.fail())
                     {
                        for(mes=0;mes<MAXMES;++mes)
                        {
                           for(dia=0;dia<MAXDIA;++dia)
                           {
                              num = NumCitasLista(m[mes][dia]);
                              if (num>0)
                              {
                                 fich << mes+1 << " " << dia+1 << " " << num << endl;
                                 SalvarListaCitaFichero(fich,m[mes][dia]);
                              }
                           }
                        }
                     }
                     fich.close(); 
                                    
                     break;
                     
             case'F': cout<<"Nombre del Fichero con la Carta: "<< endl;
                      cin.getline(nomfichCarta,MAXCAD,ENTER);
                      cout<<"Nombre del Fichero a Generar: "<<endl;
                      cin.getline(nomfich,MAXCAD,ENTER);

                      dia = LeerDia();
                      mes = LeerMes();
                      h   = LeerHora();                  
                      BuscarListaHora(m[mes][dia],h,cita,ok);
                      if (ok)
                      {
                         GeneraCarta(mes,dia,cita,nomfichCarta,nomfich);                      
                      }                     
                      break;
                      
             case'X':salir = Confirmar();
                     break;      
      }
      system("pause");
      system("cls");
    }
    
    DestruyeMatriz(m);
    
    return 0;
}


// Implementacin de Procedimientos y Funciones


bool Confirmar()
{
      char si_no;
      
     cout<< "Esta seguro(S/N)?"<<endl;
     cin >> si_no;
     si_no = toupper(si_no);
     
     return (si_no == 'S');
}

char Menu()
{
  char op;


  cout << "           MENU" << endl;
  cout << "           ====" << endl;  
  cout << "Elaborado Por : Nombre Apellidos" << endl;
  cout << "E.T.S.I Informatica de Gestin Curso: 1-A " << endl;
  cout << "Fecha: 30 de Junio de 2.005" << endl;
  cout << endl << endl; // 2 saltos de lnea
  
  cout << "A. Insertar  Evento desde teclado ."<<endl;
  cout << "B. Buscar Evento ."<<endl;
  cout << "C. Borrar Evento."<<endl;
  cout << "D. Pintar lista de Evento ."<<endl;
  cout << "E. Salvar Evento a fichero de texto."<<endl;
  cout << "F. Preparar  carta justificante."<<endl;
  cout << "X. Salir del Programa" << endl;
  
  cout << endl << "Seleccione una Opcion: ";
  
  cin >> op;
  cin.ignore(); //limpia el ENTER del buffer de teclado
  op = toupper(op); // Paso op a maysculas
  
  while ( ((op<'A') || (op>'F')) && (op!='X') )
  { cout << endl << "Opcion Incorrecta ...";
    cout << endl << "Opcion: ";
    cin >> op;
    cin.ignore();     //limpia el ENTER del buffer de teclado
    op = toupper(op); // Paso op a maysculas
  }
  
  return op;
     
}


void InicializaMatriz(TMatriz &m)
{
     TNatural dia,mes;
     
     for(mes=0;mes<MAXMES;++mes)
     {
        for(dia=0;dia<MAXDIA;++dia)
        {
           m[mes][dia] = CrearLista();
        }
     }
        
}

void DestruyeMatriz(TMatriz &m)
{
     TNatural dia,mes;
     
     for(mes=0;mes<MAXMES;++mes)
     {
        for(dia=0;dia<MAXDIA;++dia)
        {
           m[mes][dia] = CrearLista();
        }
     }
}

TNatural LeerDia()
{
   TNatural dia;
   
   
   cout <<"Escriba el dia del evento (1 a 30)"<<endl;
   cin>>dia;
   cin.ignore();
   --dia;
   
   while (dia>=MAXDIA)
   {
         cout<<"Dia erroneo"<<endl;
         cout <<"Escriba el dia del evento (1 a 30)"<<endl;
         cin>>dia;
         cin.ignore();
         --dia;
   }
   
   return dia;
}

TNatural LeerMes()
{
   TNatural mes;
   
   
   cout <<"Escriba el mes del evento (1 a 12)"<<endl;
   cin>>mes;
   cin.ignore();
   --mes;
   
   while (mes>=MAXMES)
   {
         cout<<"Mes erroneo"<<endl;
         cout <<"Escriba el mes del evento (1 a 12)"<<endl;
         cin>>mes;
         cin.ignore();
         --mes;
   }
   
   return mes;
}

void PintarCitaDia(TNatural mes, TNatural dia, TCita cita)
{
     cout << "Cita: " << dia << "/" << mes << " ";
     EscribirCita(cita);
     cout << endl;
}

THora LeerHora()
{
      THora h;
      
      cout << "Hora: ";
      cin >> h.hora;
      cin.ignore();
      cout << "Minutos: ";
      cin >> h.minutos;
      cin.ignore();

      return h;
}

void GeneraCarta(TNatural mes,TNatural dia,TCita cita,
                 string nomfichCarta,string nomfich)
{
     ifstream origen;
     ofstream destino;
     char car,sep;
     string s,h;
     
     origen.open(nomfichCarta);
     destino.open(nomfich);
     
     if ( (!origen.fail()) && (!destino.fail()) )
     {
         car = origen.get();
         while (!origen.eof())
         {
            if (car=='$')
            {
               LeePalabra(origen,s,sep);
               if (IgualCadena(s,"DIA"))
               {
                    destino << dia+1;
               }
               else if (IgualCadena(s,"MES"))
               {
                    destino << mes+1;
               }
               else if (IgualCadena(s,"HORA"))
               {
                    Hora_a_Cadena(cita.Hora,h);
                    destino << h;
               }
               else if (IgualCadena(s,"EVENTO"))
               {
                    destino << cita.evento;
               }
               else // Desconocido
               {
                    destino << s;
               }               
               destino << sep;            
            }
            else
            {
              destino << car;
            }
            car = origen.get();
         }
         
         origen.close();
         destino.close();         
     }
}

void LeePalabra(ifstream &origen, string &s, char &sep)
{
     TNatural i;
     
     i = 0;
     
     sep = origen.get();
     while ( (!origen.eof()) && (i<MAXCAD) && 
             (toupper(sep)>='A') && (toupper(sep)<='Z') )
     {
        s[i] = sep;
        sep = origen.get();
        ++i;
     }
     
     s[i] = FINCAD;
}

