#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"
#include "MFormula1.h"

using namespace MCadena;
using namespace std;

namespace MFormula1
{
          
   // PROC/FUNC COCHE   
   void Estado_a_Cadena(TEstado e, TCadena &s)
   {
        switch (e)
        {
            case retirado:        CopiaCadena("Retirado",s); break;
            case en_competicion:  CopiaCadena("En Competicion",s); break;
        }
   }
   
   void Cadena_a_Estado(TCadena s,TEstado &e, bool &ok)
   {
        if (ComparaCadena(s,"Retirado")==Igual)
        {
           ok = true;
           e = retirado;
        }
        else if (ComparaCadena(s,"En Competicion")==Igual)
        {
           ok = true;
           e = retirado;
        }
        else
        {
           ok = false; 
        }
   }

   void LeerCoche(TCoche &c)
   {
       TCadena s;
       bool ok;
        
       cout << "Nombre Escuderia: ";
       cin.getline(c.nombre, MAXCAD+1, ENTER);
       cout << "Numero del Coche: ";
       cin >> c.numero;
       cin.ignore();
       cout << "Velocidad Media :" ;
       cin >> c.velocidad_media;
       cin.ignore();
       c.numero_vueltas_completadas = 0;
       do
       {
         cout << "Estado: ";
         cin.getline(s,MAXCAD+1,ENTER);
         Cadena_a_Estado(s,c.estado,ok);
       } while (!ok);       
   }
   
   void EscribirCoche(TCoche c)
   {
       TCadena s;
        
       cout << "Nombre Escuderia: " << c.nombre << endl;
       cout << "Numero del Coche: " << c.numero << endl;
       cout << "Velocidad Media : " << c.velocidad_media << endl;
       cout << "Numero Vueltas  : " << c.numero_vueltas_completadas << endl;
       Estado_a_Cadena(c.estado,s);
       cout << "Estado: " << s << endl;
   }
   
   void LeerCocheFichero(ifstream &fich, TCoche &c)
   {
       TCadena s;
       bool ok;
        
       fich.getline(c.nombre, MAXCAD+1, ENTER);
       fich >> c.numero;
       fich.ignore();
       fich >> c.velocidad_media;
       fich.ignore();
       fich >> c.numero_vueltas_completadas;
       fich.ignore();
       fich.getline(s,MAXCAD+1,ENTER);
       Cadena_a_Estado(s,c.estado,ok);
   }
   
   void EscribirCocheFichero(ofstream &fich, TCoche c)
   {
       TCadena s;
        
       fich << c.nombre << endl;
       fich << c.numero << endl;
       fich << c.velocidad_media << endl;
       fich << c.numero_vueltas_completadas << endl;
       Estado_a_Cadena(c.estado,s);
       fich << s << endl;
   }
   
   // PROC/FUNC DE TABLA   
   int IndiceTabla(TCadena nombre)
   {
       char car;
       int i;
       car = toupper(nombre[0]);
       i= int(car)-int('A');
       if ( (i<0) || (i>=MAXTABLA) )
       {
            i=0; // Para evitar errores
       }
       return i;
   }
   
   void InicializarTabla(TTabla &tabla)
   {
        int i;
        
        for(i=0;i<MAXTABLA;++i)
        {
            tabla[i] = CrearLista();
        }
   }
   
   void DestruirTabla(TTabla &tabla)
   {
        int i;
        
        for(i=0;i<MAXTABLA;++i)
        {
            DestruirLista(tabla[i]);
        }
   }
   
   void InsertarCocheTabla(TTabla &tabla, TCoche c, bool &llena)
   {
        int i;
        
        i = IndiceTabla(c.nombre);
        InsertarCocheLista(tabla[i],c,llena);
   }
   //PROC/FUNC DE LISTA
   TLista CrearLista()
   {
        return NULL;  
   }
   
   void DestruirLista(TLista &l)
   {
        TLista aux;
        
        while (l!=NULL)
        {
              aux = l;
              l = l->sig;
              delete (aux);
        }
   }
   
   bool ListaVacia(TLista l)
   {
        return (l==NULL);
   }
   
   bool ListaLlena(TLista l)
   {
        TLista aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        
        if (!llena)
        {
            delete(aux);       
        }
        
        return llena;        
   }
   
   void InsertarCocheLista(TLista &l, TCoche c, bool &llena)
   {
        TLista aux;
        llena = ListaLlena(l);
        
        if (!llena)
        {
            if ( (ListaVacia(l)) || 
                 (ComparaCadena(c.nombre,l->coche.nombre)==Menor) )
            {
                 // Inserto por la Cabeza
                 aux = new (TNodo);
                 aux -> coche = c;
                 aux -> sig = l;
                 l = aux;
            }
            else
            {
                InsertarCocheLista(l->sig, c, llena);
            }
        }
   }

}

