#ifndef _Mformula1_h
#define _Mformula1_h

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MCadena.h"

using namespace MCadena;
using namespace std;

namespace MFormula1
{
   const int MAXTABLA = 26;
          
   typedef enum {retirado, en_competicion} TEstado;

   struct TCoche
   {
       TCadena nombre;
       int numero;
       double velocidad_media;
       double numero_vueltas_completadas;
       TEstado estado;
   };
   
   typedef struct TNodo * TLista;
   struct TNodo
   {
       TCoche coche;
       TLista sig;
   };
   
   typedef TLista TTabla[MAXTABLA];
   
   // PROC/FUNC COCHE
   void Estado_a_Cadena(TEstado e, TCadena &s);
   void Cadena_a_Estado(TCadena s,TEstado &e, bool &ok);
   void LeerCoche(TCoche &c);
   void EscribirCoche(TCoche c);
   void LeerCocheFichero(ifstream &fich, TCoche &c);
   void EscribirCocheFichero(ofstream &fich, TCoche c);
   
   // PROC/FUNC DE TABLA
   int IndiceTabla(TCadena nombre);
   void InicializarTabla(TTabla &tabla);
   void DestruirTabla(TTabla &tabla);
   void InsertarCocheTabla(TTabla &tabla, TCoche c, bool &llena);
   
   //PROC/FUNC DE LISTA
   TLista CrearLista();
   void DestruirLista(TLista &l);
   bool ListaVacia(TLista l);
   bool ListaLlena(TLista l);
   void InsertarCocheLista(TLista &l, TCoche c, bool &llena);
   
}
#endif
