#include "MPasajero.h"

namespace MPasajero 
{     
    // IMPLEMENTACION PROC/FUNC declarados en la definicin del Modulo
    
    TTipoAsiento SUC_TipoAsiento(TTipoAsiento t)
    {
          int ord;
          ord = int(t) + 1;
          return TTipoAsiento(ord);
    }
    
    void TipoAsiento_a_Cadena(TTipoAsiento t, string &s)
    {
         switch(t)
         {
             case ventanilla:  s="ventanilla"; 
                               break;
             case pasillo:     s="pasillo";
                               break;
         }
    }
    
    void Cadena_a_TipoAsiento(string s, TTipoAsiento &t, bool &ok)
    {
         string aux;
         
         t=ventanilla;
         ok = false;
         
         while ( (t<=pasillo) && (!ok) )
         {
               TipoAsiento_a_Cadena(t,aux);
               if (s==aux)
               {
                   ok = true;
               }
               else
               {
                   t = SUC_TipoAsiento(t);
               }               
         }
    }
    
    void LeerTipoAsiento(TTipoAsiento &asiento) 
    {
         string s;
         bool ok;
         
         cout << "\tTipo de asiento (ventanilla/pasillo): ";
         getline(cin,s,ENTER);
         Cadena_a_TipoAsiento(s,asiento,ok);
         while (!ok)
         {
            cout << "\tTipo de asiento incorrecto. Intntelo de nuevo (ventanilla/pasillo): " << endl;   
            getline(cin,s,ENTER);
            Cadena_a_TipoAsiento(s,asiento,ok);
         }       
    }
    
    void LeerBillete(TBillete &billete)
    {
         cout << "\tOrigen           : ";
         getline(cin,billete.origen,ENTER);
         cout << "\tDestino          : ";
         getline(cin,billete.destino,ENTER);
         cout << "\tNmero de asiento: ";
         cin >> billete.numeroAsiento;
         cin.ignore();
         LeerTipoAsiento(billete.tipo);
    }
    
    void EscribirBillete(TBillete billete)
    {
         string s;
         
         TipoAsiento_a_Cadena(billete.tipo,s);
         cout << "\tOrigen           : " << billete.origen << endl;
         cout << "\tDestino          : " << billete.destino << endl;
         cout << "\tNmero de asiento: " << billete.numeroAsiento << endl;
         cout << "\tTipo de asiento  : " << s << endl;
    }
    
    void LeerPasajero(TPasajero &pasajero)
    {
         cout << "\tDNI              : ";
         cin >> pasajero.dni; 
         cin.ignore();
         LeerBillete(pasajero.billete);
         cout << "\tKilos de equipaje: ";
         cin >> pasajero.kilosEquipaje;
         cin.ignore();
         
     }
    void EscribirPasajero(TPasajero pasajero)
    {
         cout << "\tDNI              : " << pasajero.dni << endl; 
         EscribirBillete(pasajero.billete);
         cout << "\tKilos de equipaje: " << pasajero.kilosEquipaje << endl <<endl;        
     }
     
    void LeerPasajeroFichTXT(ifstream &fich, TPasajero &pasajero)
    {
         string s;
         bool ok;
         
         fich >> pasajero.dni;
         getline(fich,pasajero.billete.origen,SEPARADOR);
         getline(fich,pasajero.billete.destino,SEPARADOR);
         fich >> pasajero.billete.numeroAsiento;
         fich.ignore();
         getline(fich,s,SEPARADOR);
         Cadena_a_TipoAsiento(s,pasajero.billete.tipo,ok);
         fich >> pasajero.kilosEquipaje;
    }
    
    void EscribirPasajeroFichTXT(ofstream &fich, TPasajero pasajero)
    {
         string s;
         
         TipoAsiento_a_Cadena(pasajero.billete.tipo, s);
         
         fich << pasajero.dni                    << ESPACIO 
              << pasajero.billete.origen         << SEPARADOR 
              << pasajero.billete.destino        << SEPARADOR
              << pasajero.billete.numeroAsiento  << ESPACIO
              << s                               << SEPARADOR
              << pasajero.kilosEquipaje          << endl;
    }
    
    void Origen(string &origen, TBillete billete)
    {
         origen = billete.origen;
    }
    void Destino(string &destino, TBillete billete)
    {
         destino = billete.destino;     
    }
    TNatural Asiento(TBillete billete)
    {
         return billete.numeroAsiento;
    }
   

}
