#ifndef _MPasajero_h_
#define _MPasajero_h_

#include <iostream>
#include <cstdlib>
#include <fstream>
#include "MCadena.h"

using namespace std;

namespace MPasajero
{ 
    const char SEPARADOR = '#';
    const char ESPACIO   = ' ';
    const char ENTER     = '\n';
    
    typedef enum { ventanilla, pasillo } TTipoAsiento;
    
    typedef unsigned int TNatural;
    struct TBillete
    {
           string origen;
           string destino;
           int numeroAsiento;
           TTipoAsiento tipo;
    };
    
    struct TPasajero 
    {
           TNatural dni;
           TBillete billete;
           int kilosEquipaje;
    };
   
    TTipoAsiento SUC_TipoAsiento(TTipoAsiento asiento); 
    void TipoAsiento_a_Cadena(TTipoAsiento t, string &s); 
    void Cadena_a_TipoAsiento(string s, TTipoAsiento &t, bool &ok);
    void LeerTipoAsiento(TTipoAsiento &asiento);
    void LeerBillete(TBillete &billete);
    void EscribirBillete(TBillete billete);
    void LeerPasajero(TPasajero &pasajero);   
    void EscribirPasajero(TPasajero pasajero);
    void LeerPasajeroFichTXT(ifstream &fich, TPasajero &pasajero);
    void EscribirPasajeroFichTXT(ofstream &fich, TPasajero pasajero);
    void Origen(string &origen, TBillete billete);
    void Destino(string &destino, TBillete billete);
    TNatural Asiento(TBillete billete);
}

#endif
