#include "MTren.h"

namespace MTren 
{     
    
    // Funciones auxiliares
    
    // Devuelve el nmero de vagones del tren
    TNatural Longitud (TTren tren);
    // Devuelve el vagn que le corresponde a un billete
    TNatural NVagon(TNatural numBillete);
    
    TTren CrearTren(TNatural numVagones, TError &err) 
    {
          TTren tren;
          TVagon vagonVacio;
          TNatural i;
          
          tren = NULL;
          CrearVagon(vagonVacio);    
         
          for (i=1;i<=numVagones;i++) 
          {
              InsertarVagon(tren, vagonVacio, i, err);              
          }
          
          return tren;
    }
    
      
    bool TrenVacio(TTren tren)
    {
       bool vacio;
       vacio = true;
       while (tren!=NULL && vacio)
       {
             vacio = vacio && VagonVacio(tren->vagon);
             tren = tren->sig;
       }
       
       return vacio;           
    }

    bool TrenLleno(TTren tren)
    {
       bool lleno;
       lleno = true;
       while (tren!=NULL && lleno)
       {
            lleno = lleno && VagonLleno(tren->vagon);
            tren = tren->sig;
       }
        
       return lleno;
    }
    
    void InsertarVagon(TTren &tren, TVagon vagon, TNatural pos, TError &err)
    {
         TTren nuevo;
         TTren aux;
         TNatural i; // nmero de vagn (1,2,...,n)
         TNatural l; // nmero total de vagones del tren
         
         l=Longitud(tren);
         
         if ( (pos<1) || (l>pos+1) )                // Un nuevo vagn slo se puede enganchar  
         {                                        // al fina, al principio o entre los 
              err = ErrorPosicionIncorrecta;      // vagones que ya hay
         }
         else 
         {
              err = NoError;
              nuevo = new (TNodo);
              CopiarVagon(vagon, nuevo->vagon);
              if (pos==1)
              {   
                err = NoError;
                nuevo->sig = tren;
                tren = nuevo;
              }
              else 
              {
              //Recorro el tren hasta encontrar la posicin que le corresponde
                        aux = tren;
                        i=1;
                        while ((aux->sig!=NULL) && pos!=i+1)
                        {
                              aux=aux->sig;
                              i++;
                        }
                        nuevo->sig=aux->sig;
                        aux->sig=nuevo;
              }   
         }
    }
    void SentarPasajero(TTren &tren, TPasajero pasajero, TError &err)
    {
         TTren aux;
         TNatural i, nvagon;
         
         nvagon = NVagon(Asiento(pasajero.billete));
         
         // Como dice el enunciado, suponemos los billetes emitidos correctamente
         // por lo que el vagon al que pertenece estar en el tren
         
         //Recorro el tren hasta encontrar el vagon nmero nvagon
         aux = tren;
         i=1;
         while (aux!=NULL && nvagon!=i)
         {
            aux=aux->sig;
            i++;
         }
         
         OcuparAsiento(pasajero, aux->vagon, err);
     }
    void EliminarPasajero(TTren &tren, TNatural numBillete, TError &err)
    {
         TTren aux;
         TNatural nvagon, i;
         
         nvagon = NVagon(numBillete);
         
         // Como dice el enunciado, suponemos los billetes emitidos correctamente
         // por lo que el vagon al que pertenece estar en el tren
         
         //Recorro el tren hasta encontrar el vagon nmero nvagon
         aux = tren;
         i=1;
         while (aux!=NULL && nvagon!=i)
         {
            aux=aux->sig;
            i++;
         }
         
         LiberarAsiento(aux->vagon, numBillete, err);
    }
    
    void EliminarPasajerosDestino(TTren &tren, string destino)
    {
         TTren aux;
         
         aux = tren;
         while (aux!=NULL)
         {
               EliminarPasajerosDestinoVagon(aux->vagon, destino);
               aux=aux->sig;
         }
         
    }
    
	void BuscarPasajero(TTren tren, TNatural dni, TPasajero &pasajero, TError &err)
    {
        TTren aux;
         
        err = ErrorNoEncontrado;
        aux = tren;
        while (aux!=NULL && err!=NoError)
        {
            BuscarPasajeroVagon(aux->vagon, dni, pasajero, err);
            aux=aux->sig;
        }
    }
    
    void DestruirTren(TTren &tren)
    {
       TTren aux;
       
       while (tren!=NULL)
       {
             aux = tren;
             tren = tren->sig;
             delete(aux);
       }         
    }
    
	void MostrarTren(TTren tren)
    {
       TTren aux;
       TNatural i;
       aux = tren;
       i=1;
       while (aux!=NULL)
       {
             cout << "VAGON " << i << endl;
             MostrarVagon(aux->vagon);
             cout << endl;
             aux = aux->sig;
             i++;
       }

    }
	
	void CargarTrenFichero(TTren &tren, string nomFich, TError &err)
    {
         ifstream fich;
         TPasajero pasajero;
         
         fich.open(nomFich.c_str());
         if ( fich.bad() || fich.fail() )
         {
            err = ErrorAperturaFichero;  
         }
         else
         {
            err = NoError; 
            LeerPasajeroFichTXT(fich,pasajero);
            while (!fich.eof())
            {
               SentarPasajero(tren,pasajero,err);
               LeerPasajeroFichTXT(fich,pasajero);
            }
            fich.close();
         }
    }
	

	void SalvarTrenFichero(TTren tren, string nomFich, TError &err)
    {
         ofstream fich;
         TTren aux;
         
         fich.open(nomFich.c_str());
         if ( fich.bad() || fich.fail() )
         {
            err = ErrorCrearFichero;  
         }
         else
         {
            err = NoError; 
            aux = tren;
            while (aux!=NULL)
            {
               EscribirVagonFichTXT(fich,aux->vagon);
               aux = aux->sig;
            }
            fich.close();
         }
    }
	

    
    // Funciones auxiliares
    
    TNatural Longitud (TTren tren)
    {
       TNatural l;
       l=0;
       while (tren!=NULL)
       {
             l=l+1;
             tren = tren -> sig;
       }
       return l;
    }
    
    TNatural NVagon(TNatural numBillete)
    {
       return  (numBillete/MAX + 1);
    }

}
