#ifndef _MTren_h_
#define _MTren_h_

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MVagon.h"

using namespace std;
using namespace MVagon;

namespace MTren 
{ 
   
    typedef struct TNodo *TTren;
    
    struct TNodo
    {
        TVagon vagon;
        TTren sig;
    };
    
    TTren CrearTren(TNatural numVagones, TError &err);
    void InsertarVagon(TTren &tren, TVagon vagon, TNatural pos, TError &err);
    bool TrenVacio(TTren tren);
    bool TrenLleno(TTren tren);
    void SentarPasajero(TTren &tren, TPasajero pasajero, TError &err);
    void MostrarTren(TTren tren);
    void EliminarPasajero(TTren tren, TNatural asiento, TError &err);
    void EliminarPasajerosDestino(TTren &tren, string destino);
	void BuscarPasajero(TTren tren, TNatural dni, TPasajero &pasajero, TError &err);
	void DestruirTren(TTren &tren);
	void CargarTrenFichero(TTren &tren, string nomFich, TError &err);
	void SalvarTrenFichero(TTren tren, string nomFich, TError &err);
}

#endif
