#include "MVagon.h"

namespace MVagon 
{ 
       
    void CrearVagon(TVagon &vagon)
    {
       TNatural i;
       for (i=0;i<MAX;i++) {
           vagon[i].vacio=true;
       }
     }
     
    bool VagonVacio(TVagon vagon)
    {
         TNatural i;
         i=0;
            
         while ((i < MAX) && vagon[i].vacio) 
         {
               i++;
         }
         return (i>=MAX);
     }
     
    bool VagonLleno(TVagon vagon)
    {
         TNatural i;
         i=0;
         
         while ((i < MAX) && !vagon[i].vacio) 
         {
               i++;
         }
         return (i>=MAX);        
     }
     
    void OcuparAsiento(TPasajero pasajero, TVagon &vagon, TError &err)
    {
         TNatural asiento; // N de asiento del pasajero
         TNatural lugar;   // Posicin relativa dentro del vagn.
        
         asiento=Asiento(pasajero.billete);
         lugar = LugarVagon(asiento);
         if (!vagon[lugar-1].vacio) 
         {
               err = ErrorAsientoOcupado;
         }
         else 
         {
              cout << "\t\tDNI: " << pasajero.dni << " Asiento: " << Asiento(pasajero.billete) << endl;
              vagon[lugar-1].pasajero=pasajero;
              vagon[lugar-1].vacio=false;
         }
           
    }
     
    void MostrarVagon(TVagon vagon)
    {
         TNatural i;
         for (i=0;i<MAX;i++) {
             if(!vagon[i].vacio) 
                EscribirPasajero(vagon[i].pasajero);
         }
     }
    
    void CopiarVagon(TVagon origen, TVagon &destino)
    {
        TNatural i;
        for (i=0;i<MAX;i++) 
        {
             destino[i]=origen[i];
         } 
     }
    void LiberarAsiento(TVagon vagon, TNatural num, TError &err)
    {
         TNatural lugar;
         
         lugar = LugarVagon(num);
         
         if (vagon[lugar-1].vacio) 
         {
               err = ErrorAsientoVacio;
         }
         else 
         {
              vagon[lugar-1].vacio=true;
         }
    }
    
    void EliminarPasajerosDestinoVagon(TVagon vagon, string destino)
    {
       string d;
       TNatural i;
       for (i=0;i<MAX;i++) {
           if (!vagon[i].vacio)
           {
              Destino(d, vagon[i].pasajero.billete);
              if (d==destino)
              {
                 cout << "\t\tDNI: " << vagon[i].pasajero.dni << " Asiento: " << Asiento(vagon[i].pasajero.billete) << endl;
                 vagon[i].vacio=true;
              }
           }
       }
    }
    
    void BuscarPasajeroVagon(TVagon vagon, TNatural dni, TPasajero &pasajero, TError &err)
    {
        TNatural i;
        
        err=ErrorNoEncontrado;
        i=0;
         
        while (i < MAX && err!=NoError)
        {
            if (!vagon[i].vacio && vagon[i].pasajero.dni==dni)
            {
               pasajero=vagon[i].pasajero;
               err=NoError;
            }
            i++;
        }     
    } 
    void EscribirVagonFichTXT(ofstream &fich, TVagon vagon) 
    {
         TNatural i;
         for (i=0;i<MAX;i++) 
         {
             if(!vagon[i].vacio) 
                EscribirPasajeroFichTXT(fich,vagon[i].pasajero);
         }    
     }
     
    TNatural LugarVagon(TNatural numBillete)
    {
         TNatural nvagon; // N de vagn que le corresponde al n de asiento del pasajero
         TNatural lugar;  // Sitio dentro del vagn
         
         // EJEMPLO: el pasajero con el asiento n 132 del tren se sentara en 
         // el asiento 12 del vagn 7: 
         // nvagon = (132/20) +1 = 7
         // lugar = 132 - 6*20 = 132 - 120 = 12
         
         nvagon = numBillete/MAX + 1;
         lugar = numBillete - ((nvagon -1)*MAX);
         
         return lugar;
     }
}
