#ifndef _MVagon_h_
#define _MVagon_h_

#include <iostream>
#include <cstdlib>
#include <fstream>
#include "MPasajero.h"
#include "MErrores.h"

using namespace std;
using namespace MPasajero;
using namespace MErrores;

namespace MVagon
{ 
    const TNatural MAX = 20;

    struct TAsiento
    {
           TPasajero pasajero;
           bool vacio;
    };
    
    typedef TAsiento TVagon[MAX];
    
    void CrearVagon(TVagon &vagon);
    bool VagonVacio(TVagon vagon);
    bool VagonLleno(TVagon vagon);
    void OcuparAsiento(TPasajero pasajero, TVagon &vagon, TError &err);
    void MostrarVagon(TVagon vagon);
    void CopiarVagon(TVagon origen, TVagon &destino);
    void LiberarAsiento(TVagon vagon, TNatural num, TError &err);
    void EliminarPasajerosDestinoVagon(TVagon vagon, string destino);
    void EscribirVagonFichTXT(ofstream &fich, TVagon vagon);
    void BuscarPasajeroVagon(TVagon vagon, TNatural dni, TPasajero &pasajero, TError &err);
    TNatural LugarVagon(TNatural numBillete);
}

#endif
