/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MPasajero.h"
#include "MVagon.h"
#include "MTren.h"
#include "MErrores.h"

using namespace std;
using namespace MErrores;
using namespace MPasajero;
using namespace MVagon;
using namespace MTren;

// Zona de Declaracin de Constantes

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();
void Recorrido(TNatural nvagones, TError &err);
// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TPasajero p;
  TNatural n, dni;
  TTren tren;
  string nomFich,destino;
  TError err;
  
  
  salir = false;
  cout << endl << "\t\tCuntos vagones tiene el tren? ";
  cin >> n;
  tren = CrearTren(n, err);
  
  while(!salir)
  {
    op = menu();
    cout << endl;
    err = NoError;
    
    switch(op)
    {
       case 'A': LeerPasajero(p);
                 SentarPasajero(tren, p, err);
                 break;
                 
       case 'B': MostrarTren(tren);
                 break;
                 
       case 'C': cout << "Nombre del fichero : ";
                 getline(cin, nomFich, ENTER);
                 SalvarTrenFichero(tren, nomFich, err);
                 break;
       case 'D': cout << "Nombre del fichero : ";
                 getline(cin, nomFich, ENTER);
                 CargarTrenFichero(tren, nomFich, err);
                 break;
       case 'E': cout << "Bajar pasajeros con destino a...";
                 getline(cin, destino,ENTER);
                 EliminarPasajerosDestino(tren, destino);
                 break;      
       case 'F': cout << "DNI : ";
                 cin >> dni;
                 BuscarPasajero(tren, dni, p, err);
                 if (err==NoError)
                 {
                    EscribirPasajero(p);
                 }
                 break;
                                  
       case 'G': Recorrido(n,err);
                 break;
      
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirTren(tren);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
 
  cout << "Apellidos, Nombre:       Curso: 1" << endl;
  cout << "Especialidad     :       Grupo: A/B/C" << endl;
  cout << "Puesto:                  Fecha: 12/09/2008" << endl;
  cout << endl;
   cout << "    RENFE" << endl;
  cout << "     ======" << endl;
  cout << "  A. Subir pasjero al tren." << endl;
  cout << "  B. Mostrar pasajeros del tren." << endl;
  cout << "  C. Salvar datos de pasajeros en un fichero de texto." << endl;
  cout << "  D. Leer lista de pasajeros en un fichero de texto." << endl;
  cout << "  E. Parada en estacin: bajada de viajeros." << endl;
  cout << "  F. Buscar pasajero en el tren por su DNI" << endl;
  cout << "  G. Mostrar recorrido." << endl;
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'H')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "?Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}

void Recorrido(TNatural nvagones, TError &err)
{
     
     ifstream fich;
     TPasajero pasajero;
     string estacion, fichEstacion;
     TTren tren;
     tren = CrearTren(nvagones, err); 
       
     fich.open("recorrido.txt");
     if ( fich.bad() || fich.fail() )
     {
            err = ErrorAperturaFichero;  
     }
     else
     {
            err = NoError;
            getline(fich, estacion,ENTER); 
            
            while (!fich.eof() && err==NoError)
            {
               cout << estacion << endl;
               cout << "\tBajan: " << endl;
               EliminarPasajerosDestino(tren, estacion);
               fichEstacion = estacion + ".txt";
               cout << "\tSuben: " << endl;
               CargarTrenFichero(tren, fichEstacion, err);
               
               getline(fich, estacion,ENTER);             
               
               
            }
            fich.close();
         }
     DestruirTren(tren);
 }
 
