#include "MABB.h"

namespace MABB 
{ 
   // Cabeceras de los PROC/FUNC auxiliares
   void SalvaABB(ofstream &fich,TABB a);
   int MAX(int a, int b);
   void EliminaRaiz(TABB &a);
   TEquipo MenorHijoIzquierdo(TABB &a);
  
  TABB CrearABB()
  {
       return NULL;
  }
  
  void InsertarEquipo(TABB &a, TEquipo e, TError &error)
  {
       if (a==NULL)
       {
           a = new (TNodo);
           if (a==NULL)
           {
               error = ErrorSinMemoria;
           }        
           else
           {
               error = NoError;
               a->equipo = e;
               a->izq = CrearABB();
               a->dch = CrearABB();
           }
       }
       else if (e.nombre < a->equipo.nombre)
       {
           InsertarEquipo(a->izq,e,error);
       }
       else if (e.nombre == a->equipo.nombre)
       {
           error = ErrorYaExiste;
       }
       else // if (e.nombre > a->equipo.nombre)
       {
           InsertarEquipo(a->dch,e,error);
       }
  }
  
  void ListarABB_Nombre(TABB a)
  {
       if (a!=NULL)
       {
           ListarABB_Nombre(a->izq);
           EscribeEquipo(a->equipo);
           ListarABB_Nombre(a->dch);
       }
  }
  
  void ListarABB_Ranking(TABB a)
  {
       int i,max_ranking;
       TEquipo e;
       TError err;
       
       max_ranking = MaxRanking(a);
       for(i=1;i<=max_ranking;++i)
       {
          BuscarEquipoRanking(a,i,e,err);
          if (err==NoError)
          {
             EscribeEquipo(e);
          }
       }
  }
  
  void BuscarEquipoRanking(TABB &a, int ranking, TEquipo &e, TError &error)
  {
        
       if (a==NULL)
       {
           error = ErrorNoExiste;
       }
       else if (ranking == a->equipo.ranking)
       {
           e = a->equipo;
           error=NoError;
       }
       else 
       {
           BuscarEquipoRanking(a->izq,ranking,e,error);
           if (error==ErrorNoExiste)
           {
              BuscarEquipoRanking(a->dch,ranking,e,error);
           }
       }       
  }
  
  void BuscarEquipoNombre(TABB &a, string nombre, TEquipo &e, TError &error)
  {
       if (a==NULL)
       {
           error = ErrorNoExiste;
       }
       else if (nombre < a->equipo.nombre)
       {
           BuscarEquipoNombre(a->izq,nombre,e,error);
       }
       else if (nombre == a->equipo.nombre)
       {
           error = NoError;
           e = a->equipo;
       }
       else 
       {
           BuscarEquipoNombre(a->dch,nombre,e,error);
       }
  }
  
  void EliminarEquipoNombre(TABB &a, string nombre, TError &error)
  {
      if (a==NULL)
       {
           error = ErrorNoExiste;
       }
       else if (nombre < a->equipo.nombre)
       {
           EliminarEquipoNombre(a->izq,nombre,error);
       }
       else if (nombre == a->equipo.nombre)
       {
           error = NoError;
           EliminaRaiz(a);
       }
       else 
       {
           EliminarEquipoNombre(a->dch,nombre,error);
       }
  }
  
  void DestruirABB(TABB &a)
  {
       if (a!=NULL)
       {
           DestruirABB(a->izq);
           DestruirABB(a->dch);
           delete(a);
       }
  }

  void SalvaABBFichero(string nomFich, TABB a, TError &err)
  {
       ofstream fich;
       
       fich.open(nomFich.c_str());
       if ( fich.bad()|| fich.fail() )
       {
            err = ErrorFichero;
       }
       else
       {
           err = NoError;
           SalvaABB(fich,a);
           fich.close();
       }
  }  
  
  //PROC/FUNC auxiliares
  void SalvaABB(ofstream &fich,TABB a)
  {
       if (a!=NULL)
       {
           EscribeEquipoFichero(fich,a->equipo);        
           SalvaABB(fich,a->izq);           
           SalvaABB(fich,a->dch);
       }
  }
  
   int MAX(int a, int b)
   {
       int max;
       
       if (a>=b)
       {
           max = a;      
       }
       else
       {
           max = b;
       }
       return max;
   }
   
   int MaxRanking(TABB a)
   {
       int m,mI,mD;
       if (a==NULL)
       {
          m=0;
          mI=0;
          mD=0;         
       }
       else
       {
          m=a->equipo.ranking;
          mI=MaxRanking(a->izq);
          mD=MaxRanking(a->dch);
       }
       return MAX(m,MAX(mI,mD));
   }   

   void EliminaRaiz(TABB &a)
   {
        TABB aux;
        TEquipo menor;
        TError err;
        
        if (a->izq==NULL) // Sin Hijo Izquierdo
        {
            aux = a;
            a = a->dch;
            delete (aux);              
        }
        else if (a->dch==NULL) // Sin Hijo Derecho
        {
            aux = a;
            a = a->izq;
            delete (aux);              
        }
        else
        {
            menor = MenorHijoIzquierdo(a->dch);
            a->equipo = menor;
            EliminarEquipoNombre(a->dch,menor.nombre,err);
        }
        
   }
   
   TEquipo MenorHijoIzquierdo(TABB &a)
   {
       TEquipo menor;
           
       if (a->izq==NULL)
       {
           menor = a->equipo;
       }    
       else
       {
           menor = MenorHijoIzquierdo(a->izq);
       }       
       return menor;
   }
}
