#ifndef _MABB_h_
#define _MABB_h_

#include <iostream>
#include <fstream>
#include <string>

#include "MError.h"
#include "MEquipo.h"

using namespace std;
using namespace MError;
using namespace MEquipo;

namespace MABB 
{ 


  typedef struct TNodo *TABB;  
  
  struct TNodo
  { 
    TEquipo equipo;
    TABB izq; 
    TABB dch;
  };
  
  TABB CrearABB();
  void InsertarEquipo(TABB &a, TEquipo e, TError &error);
  void ListarABB_Nombre(TABB a);
  void ListarABB_Ranking(TABB a);
  int MaxRanking(TABB a);
  void BuscarEquipoRanking(TABB &a, int ranking, TEquipo &e, TError &error);
  void BuscarEquipoNombre(TABB &a, string nombre, TEquipo &e, TError &error);
  void EliminarEquipoNombre(TABB &a, string nombre, TError &error);
  void DestruirABB(TABB &a);
  void SalvaABBFichero(string nomFich, TABB a, TError &err);
}
#endif



