#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>

#include "MError.h"
#include "MEquipo.h"
#include "MABB.h"


using namespace std;

using namespace MError;
using namespace MEquipo;
using namespace MABB;

char menu();
bool Confirmar();
void CargarEquiposFichero(string nomFich,TABB &a, TError &error);

int main()
{ 
  bool salir;
  char op;
  TABB a;
  TEquipo e;
  string nomFich, nombre;
  int ranking;
  TError error;
      
  salir = false;
  a = CrearABB();
  
  while(!salir)
  { 
    op = menu();
    error = NoError;
  
    switch(op)
    { 
      case 'A': LeeEquipo(e);
                InsertarEquipo(a,e,error);
                break;
      case 'B': ListarABB_Nombre(a);
                break;
      case 'C': cout << "Nombre del Fichero: ";
                getline(cin,nomFich,ENTER);
                SalvaABBFichero(nomFich,a,error);
                break;      
      case 'D': cout << "Nombre del Equipo: ";
                getline(cin,nombre,ENTER);
                BuscarEquipoNombre(a,nombre,e,error);
                if (error==NoError)
                {
                   EscribeEquipo(e);
                   if (Confirmar())
                   {
                      EliminarEquipoNombre(a,nombre,error);
                   }
                }
                break;
      case 'E': cout << "Nombre del Fichero: ";
                getline(cin,nomFich,ENTER);
                CargarEquiposFichero(nomFich,a,error);
                break;      
      case 'F': ListarABB_Ranking(a);
                break;      
      case 'G': cout << "Ranking FIBA: ";
                cin >> ranking;
                cin.ignore();
                BuscarEquipoRanking(a,ranking,e,error);
                if (error==NoError)
                {
                   EscribeEquipo(e);
                   if (Confirmar())
                   {
                      EliminarEquipoNombre(a,e.nombre,error);
                   }
                }

                break;      
      case 'X': salir = Confirmar();
                break;    
      default:  cout << "... Opcin Incorrecta ..." << endl;
                cout << endl;
                break;
    }
    
    if (op!='X')
    { 
      MuestraError(error);          
      system("PAUSE");
      system("CLS");
    }
  }
  DestruirABB(a);  
  return 0;
}

char menu()
{ char op;

  cout << "Nombre: (Apellidos, Nombre)            Curso:" << endl;
  cout << "Especialidad: Gestin                  Grupo: A" << endl;
  cout << "Puesto: nmero de ordenador            Fecha: 29/05/2009" << endl;
  cout << endl;
  cout << "Eurobasket 2009" << endl;
  cout << "===============" << endl;  
  cout << "A. Insertar Equipo." << endl;
  cout << "B. Listar por Nombre." << endl;
  cout << "C. Salvar Equipos a Fichero." << endl;
  cout << "D. Borrar Equipo por Nombre." << endl;
  cout << "E. Cargar Equipos desde Fichero." << endl;
  cout << "F. Listar por Ranking." << endl;
  cout << "G. Borrar Equipo por Ranking." << endl;
  cout << endl;
  cout << "X. Salir del Programa" << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro el ENTER
  op = toupper(op);
  
  return op;
}

bool Confirmar()
{ char car;

  cout << "Est seguro (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro el ENTER
  car = toupper(car);

  return (car=='S');
}

void CargarEquiposFichero(string nomFich,TABB &a, TError &error)
{
       ifstream fich;
       TEquipo e;
       
       fich.open(nomFich.c_str());
       if ( fich.bad()|| fich.fail() )
       {
           error = ErrorFichero;
       }
       else
       {
           LeeEquipoFichero(fich,e);
           while (!fich.eof())
           {
                 InsertarEquipo(a,e,error);
                 LeeEquipoFichero(fich,e);
           }
           fich.close();
           error = NoError;
       }
}
