#include "MCola.h"

// Implementa las operaciones para manejar el tipo TCola
namespace MCola
{
   int LongitudCola (TCola cola);
       
   void CrearCola (TCola &cola)
   {
      cola.frente = NULL;
      cola.final = NULL;
    }

    void DestruirCola (TCola &cola)
    {
       TPuntero ptr;
       
       while ( cola.frente != NULL )
       {
          ptr = cola.frente;
          cola.frente = cola.frente->sig;
          delete ptr;
       }
       CrearCola(cola); //Para que la variable cola contenga una cola vlida
     }

     
     bool ColaVacia (TCola cola)
     {
           return (cola.frente == NULL);
     }

     bool ColaLlena(TCola cola)
     {
         TPuntero aux;
         bool llena;
         
         aux = new NodoCola;
         llena = (aux==NULL);
         
         if (!llena)
         {
            delete(aux); // Solo lo hemos creado para ver si se poda
         }
         return llena;
     }

     void MeterCola (TCola& cola, TElemento valor, TError &error)
     {
          TPuntero ptr;
          
          ptr = new NodoCola;
          if (ptr == NULL)
          {
             error = ErrorColaLlena;
          }
          else
          {
              error = NoError;
              ptr->elemento = valor;
              ptr->sig = NULL;
              if (ColaVacia(cola) )
              { // si es el primero frente y final lo apuntan
                cola.frente = ptr;
              }
              else
              {
               cola.final->sig = ptr;
              }
              cola.final = ptr;
          }
     }
     
     void SacarCola (TCola& cola, TElemento& valor, TError &error)
     {
          TPuntero ptr;
          if (ColaVacia (cola))
          {
             error = ErrorColaVacia;
          }
          else
          {
              error = NoError;
              ptr = cola.frente;
              valor = ptr->elemento;
              cola.frente= cola.frente->sig;
              delete ptr;
              if (cola.frente == NULL) // era el ultimo
              {
                 cola.final = NULL;
              }
          }
     } 
     
     void ImprimirCola (TCola cola)
     {
          TPuntero ptr;
          ptr = cola.frente;
          
          while (ptr != NULL)
          {
              cout << ptr->elemento << " ";
              ptr = ptr -> sig;      
          }      
          cout << endl;
     }          

     void CargarColaFicheroTexto(TCola &cola, ifstream &f, TError &error)
     {
          int num,i;
          string valor;
          
          DestruirCola(cola); //FALLARA AQU SI LA COLA NO EST CREADA
          CrearCola(cola);
          
          f >> num; 
          f.ignore();
          
          for (i=0; i<num; i++)
          {
              f >> valor; 
              f.ignore();
              MeterCola(cola,valor,error);
          }    
     }     

     void SalvarColaFicheroTexto(TCola cola, ofstream &f, TError &error)     
     {
          int longitud;
          TPuntero ptr;
          
          longitud = LongitudCola(cola);
          f << longitud << endl;
          
          ptr = cola.frente;
          while (ptr != NULL)
          {
                f << ptr->elemento << endl;
                ptr = ptr->sig;
          }
     }
          
     int LongitudCola(TCola cola)
     {
         int longitud = 0;
         TPuntero ptr;
         
         ptr = cola.frente;
         while (ptr != NULL)
         {
               longitud++;
               ptr = ptr -> sig;
         }
         return longitud;
     }          
}     
