#ifndef _MCola_h_ // para evitar inclusin duplicada
#define _MCola_h_

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "MError.h"

using namespace std;
using namespace MError;

namespace MCola
{
          //Tipo de los elementos almacenados en la cola
          typedef string TElemento;
                 
          typedef struct NodoCola *TPuntero;
          struct NodoCola
          {
              TElemento elemento;
              TPuntero sig;
          };
          
          /*Implementacin eficiente de una cola, con un registro con dos
            punteros. "frente" apunta al frente de la cola y "final" apunta
            al final de la cola
          */
          struct TCola
          {
               TPuntero frente, final;
          };
          
          void CrearCola (TCola &cola); // Crea la Cola
          bool ColaVacia (TCola cola); // comprueba si la Cola est vaca
          bool ColaLlena (TCola cola); // comprueba si la Cola est llena
          void MeterCola (TCola &cola, TElemento valor, TError &error);
          // introduce valor al final de la Cola
          void SacarCola (TCola &cola, TElemento &valor, TError &error);
          // saca el valor del frente de la Cola
          void DestruirCola (TCola &cola); // libera la memoria
          void ImprimirCola (TCola cola);
          void CargarColaFicheroTexto(TCola &cola, ifstream &f, TError &error);
          
          //Opciones necesarias para la opcin E-F
          void SalvarColaFicheroTexto(TCola cola, ofstream &f, TError &error);
}

#endif
