#include "MCurso.h"

namespace MCurso
{ 
    // CABECERAS PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    void LeerColectivo(TColectivo &c, TError &err);
    void EscribirColectivo(TColectivo e);
    TColectivo SUC(TColectivo c);
    string Mayusculas(string s);
    string Colectivo_a_Cadena(TColectivo c);
    void Cadena_a_Colectivo(string s, TColectivo &c, TError &err);
    
    // IMPLEMENTACION DE LA FUNCIONALIDAD DEL MDULO
    void LeerColectivo(TColectivo &c, TError &err)
    {
         string s;
         
         cout << "Introduzca colectivo (Desempleados, Jovenes, Mayores, Todos): ";
         getline(cin,s,ENTER);
         Cadena_a_Colectivo(s,c,err);
    }
    
    void EscribirColectivo(TColectivo c)
    {
         cout << Colectivo_a_Cadena(c);
    }
    
    void LeerCurso(TCurso &curso)
    {
         TError err;
         
         cout << "Introduzca codigo del curso: ";
         cin >> curso.codigo;
         cin.ignore();
         
         LeerColectivo(curso.colectivo,err);
         while (err == ErrorColectivoDesconocido)
         {
               MostrarError(err);
               LeerColectivo(curso.colectivo,err);
         }      
         
         CrearCola(curso.solicitantes);         
    }
    
    void EscribirCurso(TCurso curso)
    {
        
         cout << "Codigo del curso: " << curso.codigo << endl; 
         cout << "Colectivo: " << Colectivo_a_Cadena(curso.colectivo) << endl;
         cout << "Solicitantes: " << endl;
         ImprimirCola(curso.solicitantes);
    }
             
    void InsertarSolicitanteCurso(TCurso &curso, string solicitante, TError &err)
    {
         MeterCola(curso.solicitantes,solicitante,err);     
    }     
    
    void CargarCursoFicheroTexto(TCurso &curso, ifstream &f, TError &err)
    {
         string colectivo;
         
         f >> curso.codigo; 
         f.ignore();
         
         if (!f.eof())
         {
           err = NoError;
           getline(f,colectivo,SEP); 
           Cadena_a_Colectivo(colectivo,curso.colectivo,err);
         
           CrearCola(curso.solicitantes); //Si no se hace esto antes FALLARA
           CargarColaFicheroTexto(curso.solicitantes,f,err);
         }
         else
         {
             err = ErrorFichero;
         }      
    }     
    
    void SalvarCursoFicheroTexto(TCurso curso, ofstream &f, TError &err)
    {
         int longitud;
         
         f << curso.codigo << endl;
         f << Colectivo_a_Cadena(curso.colectivo) << "#";
         SalvarColaFicheroTexto(curso.solicitantes,f,err); 
         
    }
         
    void DestruirCurso(TCurso &curso)
    {
         DestruirCola(curso.solicitantes);     
    }     
    
    //PROCEDIMIENTOS Y FUNCIONES AUXILIARES      
    TColectivo SUC(TColectivo c)
    {
        int ord;
        ord = int(c)+1;
        return TColectivo(ord);     
    }
    
    string Mayusculas(string s)
    {
           string res;
           int i;
           
           res="";
           for(i=0;i<s.length();++i)
           {
                res+=toupper(s[i]);
           }
           return res;
    }
    
    string Colectivo_a_Cadena(TColectivo e)
    {
           string res;
           
           switch (e)
           {
                  case Desempleados:    res = "Desempleados"; break;
                  case Jovenes:         res = "Jovenes"; break;
                  case Mayores:         res = "Mayores"; break;
                  case Todos:           res = "Todos"; break;
           }
           
           return res;
    }
    
    void Cadena_a_Colectivo(string s, TColectivo &c, TError &err)
    {
         err = ErrorColectivoDesconocido;
         c = Desempleados;
         
         while ( (c<=Todos) && (err!=NoError) )
         {
               if (Mayusculas(s)==Mayusculas(Colectivo_a_Cadena(c)))
               {
                  err = NoError;                                                         
               }
               else
               {
                   c = SUC(c);
               }               
         }
    }
    
    bool TieneSolicitantes(TCurso curso)
    {
      return !ColaVacia(curso.solicitantes);    
    }
    
    void SacarSolicitanteCurso(TCurso &curso, string &solicitante, TError &err)
    {
         SacarCola(curso.solicitantes, solicitante,err);
         if (err == ErrorColaVacia)
         {
            err = ErrorCursoVacio;
         }   
    }          
    
    void AnularInscripcionCurso(TCurso &curso, string solicitante, TError &err)
    {
         TCola colaaux;
         string s;
         TError err2;

         err = ErrorSolicitanteNoInscrito;         
         CrearCola(colaaux);
         while (!ColaVacia(curso.solicitantes))
         {
               SacarCola(curso.solicitantes,s,err2);
               if (s != solicitante)
               {
                     MeterCola(colaaux,s,err2);
               }      
               else
               {
                   err = NoError;
               }    
         }     
         while (!ColaVacia(colaaux))
         {
               SacarCola(colaaux,s,err2);
               MeterCola(curso.solicitantes,s,err2);      
         }       
         DestruirCola(colaaux);
    }   
}     



