#ifndef _MCurso_h_
#define _MCurso_h_

#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>

#include "MError.h"
#include "MCola.h"

using namespace std;
using namespace MError;
using namespace MCola;

namespace MCurso
{ 
    const int MAX_COLECTIVO = 4;
    const char ENTER = '\n';
    const char SEP = '#';
          
    typedef enum TColectivo { Desempleados, Jovenes, Mayores, Todos };

    typedef int TCodigo;
    
    struct TCurso
    {
        TCodigo codigo;
        TColectivo colectivo;
        TCola solicitantes;     
    };               

    //Necesarios para las opciones A-D    
    void LeerCurso(TCurso &curso);
    void EscribirCurso(TCurso curso);
    void InsertarSolicitanteCurso(TCurso &curso, string solicitante, TError &err);
    void CargarCursoFicheroTexto(TCurso &curso, ifstream &f, TError &err);
    void DestruirCurso(TCurso &curso);
    
    //Necesarios para las opciones E-F
    void SalvarCursoFicheroTexto(TCurso curso, ofstream &f, TError &err);

    //Necesarios para las opciones G-H
    void AnularInscripcionCurso(TCurso &curso, string solicitante, TError &err);
    void SacarSolicitanteCurso(TCurso &curso, string &solicitante, TError &err);
    bool TieneSolicitantes(TCurso curso);
}

#endif
