#include "MListaCursos.h"

namespace MListaCursos
{ 

    //Procedimientos auxiliares
    void BuscarCurso(TListaCursos l, int codigo, TListaCursos &curso, TError &error);
    void BuscarCursoPorColectivo(TListaCursos &l, TListaCursos p1, TListaCursos &p2, TError &err);
    void TransferirCursoAux(TListaCursos &p1, TListaCursos &p2, TError &err);
        
    void CrearLista(TListaCursos &l)
    {
        l = NULL;
    }
    
    bool ListaVacia(TListaCursos l)
    {
        return (l==NULL);
    }
    
    bool ListaLlena(TListaCursos l)
    {
        TListaCursos aux;
        bool llena;
        
        aux = new (TNodo);
        llena = (aux==NULL);
        if (!llena)
        {
           delete(aux); //Se borra porque se ha creado para ver si se poda
        }
        
        return llena;
    }
     
    void InsertarCursoLista(TListaCursos &l, TCurso c, TError &err)
    {
        TListaCursos nuevoNodo;
        
        if ( (ListaVacia(l)) || c.codigo < l->curso.codigo )
        {
           // Inserto por la cabeza
           if (ListaLlena(l))
           {
               err = ErrorListaLlena;
           }  
           else
           {
               err = NoError;
               nuevoNodo = new (TNodo);
               nuevoNodo->curso = c;
               nuevoNodo->sig = l;
               l = nuevoNodo;
           }
        }
        else if ( c.codigo == l->curso.codigo )
        {
             err = ErrorCursoDuplicado;
        }
        else
        {
             InsertarCursoLista(l->sig,c,err);
        }
    }
    
    void InsertarSolicitanteLista(TListaCursos &l, int codigo, string solicitante, TError &err)
    {
         TListaCursos ptr;
         
         BuscarCurso(l,codigo,ptr,err);
         if (err != ErrorCursoNoEncontrado)
         {
            InsertarSolicitanteCurso(ptr->curso,solicitante,err);
         }        
    }
             
    int LongitudLista(TListaCursos l)
	{
        int i;
        TListaCursos ptr;
        
        ptr = l;
        i=0;
        
        while (ptr!=NULL)
        {
              ++i;
              ptr = ptr->sig;
        }
        
        return i;
    }
    
    void DestruirLista(TListaCursos &l)
    {
        TListaCursos ptr;
        
        while (l!=NULL)
        {
              ptr=l;
              l=l->sig;
              delete(ptr);
        }
    }
    
    void CargarListaFicheroTexto(TListaCursos &l, string nombre, TError &err)
    {
         ifstream fichin;
         TCurso curso;
         
         fichin.open(nombre.c_str());
         if (fichin.fail() || fichin.bad())
         {
            err = ErrorFichero;
         }
         else
         {
            DestruirLista(l);
            CrearLista(l);
             
            CargarCursoFicheroTexto(curso, fichin, err);
            while (err == NoError)
            {
               InsertarCursoLista(l, curso, err);
               CargarCursoFicheroTexto(curso,fichin,err);
            }  
            err = NoError;
         }       
    }
         
    void SalvarListaFicheroTexto(TListaCursos l, string nombre, TError &err)
    {
         ofstream fichout;
         TListaCursos ptr;
         
         fichout.open(nombre.c_str());
         
         if (fichout.fail() || fichout.bad())
         {
            err = ErrorFichero;
         }
         else
         {
             ptr = l;
             while (ptr != NULL)
             {
                SalvarCursoFicheroTexto(ptr->curso,fichout,err);
                ptr = ptr -> sig;
             }         
         }    
    }     

    void MostrarLista(TListaCursos l)
    {
         TListaCursos ptr;
         
         ptr = l;
         while (ptr != NULL)
         {
               EscribirCurso(ptr->curso); cout << endl;
               ptr = ptr -> sig;      
         }      
    }
         
    void BuscarCursoLista(TListaCursos l, int codigo, TCurso &c, TError &err)
    {
         TListaCursos aux;
         
         BuscarCurso(l,codigo,aux,err);
         if (err == NoError)
         {
            c = aux->curso;
         }   
    }
         
    void BuscarCurso(TListaCursos l, int codigo, TListaCursos &curso, TError &error)
    {
        
         error = NoError;
         curso = l;
         while ((curso != NULL) && (curso->curso.codigo < codigo))
         { 
               curso = curso -> sig;
         }    
         
         if ((curso == NULL) || (curso->curso.codigo != codigo))
         {
               error = ErrorCursoNoEncontrado;
         }    
    }      
    
    void BorrarCursoLista(TListaCursos &l, int codigo, TError &err)
    {
         TListaCursos ant, ptr;
         
         ant = NULL;
         ptr = l;
         err = NoError;
         
         while ((ptr != NULL) && (ptr->curso.codigo < codigo))
         {
               ant = ptr;
               ptr = ptr -> sig;
         }      
         
         if ((ptr == NULL) || (ptr->curso.codigo != codigo))
         {
             err = ErrorCursoNoEncontrado;
         }
         else
         {
             if (ant == NULL)
             {
                 l = l -> sig;
             }
             else
             {
                 ant->sig = ptr->sig;
             }     
             DestruirCurso(ptr->curso);         
             delete ptr;
         }        
    }     
    
    void TransferirCursoLista(TListaCursos &l, int codigo, TError &err)
    {
         TListaCursos ptr1,ptr2;
         TError err2;
         string solicitante;
         
         //Se localiza el curso a tranferir
         BuscarCurso(l,codigo,ptr1,err);
         if (err == NoError)
         {
           BuscarCursoPorColectivo(l,ptr1,ptr2,err2);
           if (err2 == NoError)
           {
              TransferirCursoAux(ptr1,ptr2,err2);
              if (TieneSolicitantes(ptr1->curso))
              {
                cout << "No han podido transferirse todos los solicitantes." << endl;
                cout << "Los siguientes participantes se descartarn:" << endl;
                while (TieneSolicitantes(ptr1->curso))
                {
                    SacarSolicitanteCurso(ptr1->curso, solicitante,err2);
                    cout << solicitante << " ";
                }
                cout << endl;
              }  
              BorrarCursoLista(l,ptr1->curso.codigo,err);
           } 
           else
           {
               err = ErrorTransfiriendoCurso;
           }               
         }        
    }     
    
    void BuscarCursoPorColectivo(TListaCursos &l, TListaCursos p1, TListaCursos &p2, TError &err)
    {
         TListaCursos ptr;
         
         err = NoError;     
         ptr = l;
         while ( (ptr != NULL) && (ptr->curso.codigo == p1->curso.codigo || 
                (ptr->curso.codigo != p1->curso.codigo && ptr->curso.colectivo != p1->curso.colectivo)) )
         {
               ptr = ptr -> sig;
         }
         if ((ptr == NULL) || (ptr->curso.codigo == p1->curso.codigo))
         {
              err = ErrorCursoNoEncontrado;
         }
         else 
         {
              p2 = ptr;     
         }                
    }
         
    void TransferirCursoAux(TListaCursos &p1, TListaCursos &p2, TError &err)
    {
           string solicitante;
           TError err2;
           
           err2 = NoError;
           SacarSolicitanteCurso(p1->curso,solicitante,err);
           while ((err == NoError) && (err2 == NoError))
           {
                 InsertarSolicitanteCurso(p2->curso,solicitante,err2);
                 SacarSolicitanteCurso(p1->curso,solicitante,err);
           }         
    }     
    
    void AnularInscripcion(TListaCursos &l,string solicitante)
    {
         TListaCursos ptr;
         TError err;
         
         ptr = l;
         cout << "El solicitante se encontraba inscrito en los siguientes cursos: " << endl;
         while (ptr!=NULL)
         {
               AnularInscripcionCurso(ptr->curso,solicitante,err);
               if (err == NoError)
               {
                  cout << ptr->curso.codigo << " ";
               }        
               ptr = ptr -> sig;
         }           
    }     
}

