/*----------------------------------------------------------------
|	Autor:                                                        |
|	Fecha:                            Versin: 1.0	              |
|-----------------------------------------------------------------|
|	Descripcin del Programa:                                     |
|  								                                  |
| ----------------------------------------------------------------*/

// Incluir E/S y Libreras Standard
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>

#include "MError.h"
#include "MCurso.h"
#include "MListaCursos.h"

using namespace std;
using namespace MError;
using namespace MCurso;
using namespace MListaCursos;

// Zona de Declaracin de Constantes

// Zona de Declaracin de Tipos

// Zona de Cabeceras de Procedimientos y Funciones
char menu();
bool Confirmar();

// Programa Principal
int main()
{
  // Zona de Declaracin de Variables del Programa principal
  char op;
  bool salir;
  TListaCursos l_cursos;
  TCurso curso;
  int codigo;
  string solicitante,nombre;
  TError err;
  
  salir = false;
  CrearLista(l_cursos);
  
  while(!salir)
  {
    err = NoError;           
    op = menu();
    cout << endl;
    
    switch(op)
    {
       case 'A': LeerCurso(curso);
                 InsertarCursoLista(l_cursos,curso,err);
                 break;
       case 'B': cout << "Codigo del Curso: ";
                 cin >> codigo;
                 cin.ignore();
                 BuscarCursoLista(l_cursos,codigo,curso,err);
                 if (err == NoError)
                 {
                    cout << endl;
                    EscribirCurso(curso);
                    cout << endl;
                    cout << "NIF del Asistente al Curso: ";
                    getline(cin,solicitante,ENTER);
                    InsertarSolicitanteLista(l_cursos,codigo,solicitante,err);          
                 }   
                 break;
       case 'C': cout << "Nombre del Fichero: ";
                 getline(cin,nombre,ENTER);
                 CargarListaFicheroTexto(l_cursos,nombre,err);
                 break;
       case 'D': MostrarLista(l_cursos);
                 break;
       case 'E': cout << "Nombre del Fichero: ";
                 getline(cin,nombre,ENTER);
                 SalvarListaFicheroTexto(l_cursos,nombre,err);
                 break;
       case 'F': cout << "Codigo del Curso: ";
                 cin >> codigo;
                 cin.ignore();
                 BuscarCursoLista(l_cursos,codigo,curso,err);
                 if (err == NoError)
                 {
                    cout << endl;
                    EscribirCurso(curso);
                    cout << endl;
                    if (Confirmar())
                    {
                       BorrarCursoLista(l_cursos,codigo,err);
                    }             
                 }   
                 break;
       case 'G': cout << "NIF del Solicitante: ";
                 getline(cin,solicitante,ENTER);
                 AnularInscripcion(l_cursos,solicitante);
                 break;
       case 'H': cout << "Codigo del Curso: ";
                 cin >> codigo;
                 cin.ignore();
                 TransferirCursoLista(l_cursos,codigo,err);        
                 break;
       case 'X': salir = Confirmar();
                 cout << endl << endl;
                 break;    
    }
    MostrarError(err);
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
  }
  DestruirLista(l_cursos);
  return 0;	   // Valor de retorno al S.O.
}

// Implementacin de Procedimientos y Funciones
char menu()
{
  char op;
  
  cout << "Nombre: (Apellidos, Nombre)    Curso: 1" << endl;
  cout << "Especialidad: Sistemas         Grupo: A/B/C" << endl;
  cout << "Puesto: nmero de ordenador    Fecha: 24/06/2010" << endl;
  cout << endl;
  cout << "     Formacion para el Empleo" << endl;
  cout << "     ========================" << endl;
  cout << "  A. Insertar Curso." << endl;
  cout << "  B. Insertar Solicitante." << endl;
  cout << "  C. Cargar Cursos desde Fichero de Texto." << endl;
  cout << "  D. Mostrar Todos los Cursos." << endl;
  cout << "  E. Salvar Todos los Cursos a Fichero de Texto." << endl;
  cout << "  F. Eliminar Curso." << endl;
  cout << "  G. Anular Inscripcion a Cursos." << endl;
  cout << "  H. Transferir un Curso." << endl;
 
  cout << "  X. Salir del Programa" << endl;
  cout << endl;
  cout << "  Introduzca su opcion: " ;
  
  cin >> op;
  cin.ignore();
  op = toupper(op);
  
  while ( ((op<'A') || (op>'H')) && (op!='X') )
  {
    cout << "  Opcion Incorrecta ..." << endl;
    cout << endl;
    cout << "  Introduzca su opcion: " ;
    cin >> op;
    cin.ignore();
    op = toupper(op);  
  }
  
  return op;

}

bool Confirmar()
{ 
  char car;

  cout << "Esta seguro(S/N)?";
  cin >> car;
  cin.ignore();
  car = toupper(car);
  
  return (car=='S');
}


