#include "MButaca.h"

namespace MButaca 
{     
    unsigned int numButacasVacias(TButacas but);
    void rellenarNHuecos(TButacas &but, unsigned int num);
      
    //Inicializa la estructura but, a un estado en el que hay num butacas, todas ellas vacas.
    void InicializarButacas(TButacas &but,unsigned int num){
         unsigned int i;
         
         if (num > MAX_BUTACAS)
         {
            num = MAX_BUTACAS;
         }   
         but.tam = num;
         for (i=0; i<num; i++)
         {
             but.ocupacion[i] = false;    
         }
    }
    
    /* Inicializa la estructura but con la informacin del estado de ocupacin de un cine, 
    ledo del fichero fich (el nmero del butacas ledo del fichero y su estado de ocupacin). 
    Ntese que fich no es el nombre de un fichero, sino el manejador del fichero del que se lee.
    */
    void LeerButacasFich(TButacas &but, ifstream &fich){
         unsigned int i;
         char estado;
         
         fich >> but.tam; //Numero de butacas del cine 
         for (i=0; i<but.tam; i++)
         {
             fich >> estado;
             if (estado == 'O')
             {
                but.ocupacion[i] = true;
             }
             else
             {
                but.ocupacion[i] = false;       
             }   
         }
    }     
    
    /* Intenta comprar num butacas en la estructura but. Si es posible (haba al menos num butacas vacas), 
    devuelve true en el parmetro ok, y las pone a ocupadas (no importa cuales se pongan a ocupada, 
    siempre se pongan exactamente num). En caso de no haber butacas suficientes, devuelve false en ok. 
    */
    void ComprarButacas(TButacas &but, unsigned int num, bool &ok){
         unsigned int num_vacias;
 
         ok = false;        
         num_vacias = numButacasVacias(but);
         if (num_vacias >= num)
         {
            ok = true;
            rellenarNHuecos(but,num);
         }
    }     
    
    unsigned int numButacasVacias(TButacas but){
         unsigned int num_vacias, i;
            
         num_vacias = 0;
         //Contamos el nmero de butacas vacas
         for(i=0; i<but.tam; i++)
         {
            if (but.ocupacion[i] == false)
            {
                num_vacias++;                   
            }
         }     
         return num_vacias;
    }             
    
    //Antes se ha comprobado si hay huecos suficientes
    void rellenarNHuecos(TButacas &but, unsigned int num){
         unsigned int i,rellenos;
         
         i=0;
         rellenos=0;
         while ( (rellenos<num) && (i<but.tam))
         {
            if (but.ocupacion[i] == false)
            {
               but.ocupacion[i] = true;
               rellenos++;                   
            }             
            i++;           
         }                 
    }
    
    /* Muestra en pantalla una lnea con el estado de ocupacin de las butacas but. 
    Las butacas deben aparecer en orden, apareciendo por cada una 'O' si est ocupada y 'V' si estaba vaca. 
    Por ejemplo, si el cine tiene 10 butacas, estando las dos primeras vacias y el resto ocupadas, 
    deber mostrar: VVOOOOOOOO
    */  
    void MostrarOcupacion(TButacas but){
         unsigned int i;
         
         for (i=0; i<but.tam; i++)
         {
             if (but.ocupacion[i])
             {
               cout << "O";
             }
             else
             {
               cout << "V";    
             }          
         }    
         cout << endl;
    }     
}
