#ifndef _MButaca_h_
#define _MButaca_h_

#include <iostream>
#include <fstream>

using namespace std;

namespace MButaca
{ 
    const unsigned int MAX_BUTACAS = 20;
    
    typedef bool TOcupacion [MAX_BUTACAS];
    
    struct TButacas
    {
           unsigned int tam;
           TOcupacion ocupacion;
    };

    void InicializarButacas(TButacas &but,unsigned int num);
    //Inicializa la estructura but, a un estado en el que hay num butacas, todas ellas vacas.
    
    void LeerButacasFich(TButacas &but, ifstream &fich);
    /* Inicializa la estructura but con la informacin del estado de ocupacin de un cine, 
    ledo del fichero fich (el nmero del butacas ledo del fichero y su estado de ocupacin). 
    Ntese que fich no es el nombre de un fichero, sino el manejador del fichero del que se lee.
    */
    
    void ComprarButacas(TButacas &but, unsigned int num, bool &ok);
    /* Intenta comprar num butacas en la estructura but. Si es posible (haba al menos num butacas vacas), 
    devuelve true en el parmetro ok, y las pone a ocupadas (no importa cuales se pongan a ocupada, 
    siempre se pongan exactamente num). En caso de no haber butacas suficientes, devuelve false en ok. 
    */
    
    void MostrarOcupacion(TButacas but);
    /* Muestra en pantalla una lnea con el estado de ocupacin de las butacas but. 
    Las butacas deben aparecer en orden, apareciendo por cada una 'O' si est ocupada y 'V' si estaba vaca. 
    Por ejemplo, si el cine tiene 10 butacas, estando las dos primeras vacias y el resto ocupadas, 
    deber mostrar: VVOOOOOOOO
    */
    
}

#endif
