#include "MListaCines.h"


namespace MListaCines 
{     
    
    TLista CrearListaCines()
    {
       return NULL;
    }
    
    bool ListaCinesVacia(TLista l)
    {
       return (l==NULL);           
    }

	void LeerCinesFichero(TLista &l, TCadena nomFich, TError &err)
    {
         ifstream fich;
         unsigned int cod;
         TButacas but;
         
         fich.open(nomFich);
         if ( (fich.bad()) || (fich.fail()) )
         {
            err = ErrorAperturaFichero;  
         }
         else
         {
            err = NoError;
            DestruirCines(l);
            l = CrearListaCines(); 
            fich >> cod; 
            while (!fich.eof())
            {
               LeerButacasFich(but,fich);
               InsertarCine(l,cod,but,err);
               fich >> cod; 

            }
            fich.close();
         }
    }

    void InsertarCine(TLista &l, unsigned int cod, TButacas but, TError &err) 
    {
         TLista nuevo;
         
         if ( (ListaCinesVacia(l)) || (cod < l->cine.cod) )
         {   // Inserto por la cabeza
             err = NoError;
             nuevo = new (TNodo);
             nuevo->cine.cod = cod;
             nuevo->cine.butacas = but;
             nuevo->sig = l;
             l = nuevo;
         }
         else if (cod == l->cine.cod)
         {   
             err = ErrorCineExiste;
         }
         else
         {
             InsertarCine(l->sig,cod,but,err);
         } 
    }

    void BorrarCine(TLista &l,unsigned int cod, TError &err)
    {
        TLista ptr;
         
         if ( (ListaCinesVacia(l)) || (cod < l->cine.cod) )
         {
             err = ErrorNoEncontrado;
         }
         else if (cod == l->cine.cod)
         {
             err = NoError;
             ptr = l;
             l = l->sig;
             delete(ptr);
         }
         else
         {
             BorrarCine(l->sig,cod,err);
         }
    }
    
    void DestruirCines(TLista &l)
    {
       TLista aux;
       
       while (l!=NULL)
       {
             aux = l;
             l = l->sig;
             delete(aux);
       }         
    }
    
	void MostrarCines(TLista l)
    {
       TLista ptr;
       
       ptr = l;
       
       while (ptr!=NULL)
       {
             cout << ptr->cine.cod << " ";
             MostrarOcupacion(ptr->cine.butacas);
             cout << endl;
             ptr = ptr->sig;
       }

    }

    void ComprarButacasCine(TLista &l, unsigned int cod, unsigned int num, TError &err)
    {
         TLista ptr;
         bool ok;
         
         ptr = l;
         
         //Localizamos el cine
         while ((ptr!=NULL) && (ptr->cine.cod != cod))
         {
               ptr = ptr->sig;
         }      
         
         if (ptr != NULL) //Hemos encontrado el cine
         {
                 ComprarButacas(ptr->cine.butacas,num,ok);
                 if (ok)
                 {
                    err = NoError;
                 }           
                 else
                 {
                    err = ErrorNoDisponible;    
                 }    
         }
         else //No hemos encontrado el cine
         {
             err = ErrorNoEncontrado;    
         }            
    }     
}
