#ifndef _MListaCines_h_
#define _MListaCines_h_

#include <iostream>
#include <fstream>

#include "MButaca.h"

using namespace std;
using namespace MButaca;

namespace MListaCines 
{ 
    //Es necesario definirlo para el fichero      
    const unsigned int MAXCAD = 30;
    typedef char TCadena[MAXCAD+1];
    
    typedef enum 
    { 
        ErrorNoEncontrado, ErrorCineExiste, ErrorNoDisponible, 
        ErrorAperturaFichero, ErrorCrearFichero, NoError
    } TError;
    
    struct TCine
    {
        unsigned int cod;
        TButacas butacas;   
    };
                      
    typedef struct TNodo *TLista;
    
    struct TNodo
    {
        TCine cine;
        TLista sig;
    };
    
    TLista CrearListaCines();
    //Esta operacin crea una lista de cines vaca.
    
    bool ListaCinesVacia(TLista l);
    //Esta operacin devuelve true si la lista de cines est vaca, false en caso contrario.
    
	void LeerCinesFichero(TLista &l,TCadena nom_fich, TError &err);
    //Esta operacin crea en L una lista de cines con la informacin almacenada en el fichero de texto nom_fich, cuyo formato se describe ms adelante. El contenido previo de la lista L se descartar.
    
    void MostrarCines(TLista l);
    //Muestra por pantalla la informacin de todos los cines (cdigo y estado de ocupacion de sus butacas) contenidos en L.
    
    void InsertarCine(TLista &l, unsigned int cod, TButacas but, TError &err); 
    /*Aade a la lista de cines L un nuevo nodo (ordenado por cdigo), cuyo cdigo es cod, y con num butacas, 
      que tendrn inicialmente el estado de ocupacin a vaco.
    */  
    
    void BorrarCine(TLista &l,unsigned int cod, TError &err);
    //Elimina de la lista de cines L aquel cuyo cdigo es cod.
    
    void ComprarButacasCine(TLista &l, unsigned int cod, unsigned int num, TError &err);
    /*Selecciona de la lista de cines aque cuyo cdigo es cod. Si no existe, muestra un mensaje de error, 
    y si existe, intenta combrar num butadas en dicho cine. Si no es posible se muestra un mensaje de error.
    */
    
    void DestruirCines(TLista &l);
    //Libera todos los recursos ocupados por la lista de cines L.
    
}

#endif
